


<?php $__env->startSection('css'); ?>
<link href="<?php echo e(asset('css/dropzone.min.css')); ?>" rel="stylesheet">
<script src="<?php echo e(asset('js/dropzone.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/clipboard.min.js')); ?>"></script>
<style>
    .btn-group-sm>.btn, .btn-sm {
        --tblr-btn-line-height: 1.5;
        --tblr-btn-icon-size: .75rem;
        margin-right: 5px;
        font-size: 12px !important;
        margin: 13px 0 10px 5px !important;
    }

    .li-link {
        padding: 10px;
        margin: 4px;
    }

    .btn.disabled, .btn:disabled, fieldset:disabled .btn {
        border-color: #0000 !important;
    }

    .custom-nav {
        position: absolute;
        right: 5px;
        top: -2px;
    }

    .media-name {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="card">
                <div class="row g-0">
                    <div class="col-12 col-md-3 border-end">
                        <div class="card-body">
                            <h4 class="subheader"><?php echo e(__('Update Business Card')); ?></h4>
                            <div class="list-group list-group-transparent">
                                
                                <?php echo $__env->make('user.pages.edit-cards.includes.nav-link', ['link' => 'galleries'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-9 d-flex flex-column">
                        <form action="<?php echo e(route('user.update.galleries', Request::segment(3))); ?>" method="post" enctype="multipart/form-data" id="myForm">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <h3 class="card-title mb-4"><?php echo e(__('Galleries')); ?></h3>

                                <div class="row">
                                    
                                    <?php for($i = 0; $i < count($galleries); $i++): ?> 
                                    <div class="row" id="<?php echo e($i); ?>">
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Gallery Image')); ?> <span
                                                        class='text-muted'>(<?php echo e(__('Recommended : 200 x 200 pixels')); ?>)</span></label>
                                                <div class="input-group mb-2">
                                                    <input type="text"
                                                        class="image<?php echo e($galleries[$i]->id); ?> media-model form-control"
                                                        name="gallery_image[]"
                                                        placeholder="<?php echo e(__('Gallery Image')); ?>" 
                                                        value="<?php echo e($galleries[$i]->gallery_image); ?>" required>
                                                    <button class="btn btn-primary btn-md" type="button"
                                                        onclick="openMedia(<?php echo e($galleries[$i]->id); ?>)"><?php echo e(__('Choose
                                                        image')); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Image Caption')); ?></label>
                                                <input type="text" class="form-control" name="caption[]"
                                                    placeholder="<?php echo e(__('Image Caption')); ?>..."
                                                    value="<?php echo e($galleries[$i]->caption); ?>" required>
                                                <button class='btn btn-danger btn-sm mt-2'
                                                    onclick='removeGallery(<?php echo e($i); ?>)'>
                                                    <?php echo e(__('Remove')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endfor; ?>

                                    
                                    <div id="more-gallery" class="row"></div>

                                    
                                    <div class="col-lg-12 mb-5">
                                        <button type="button" onclick="addGallery()" class="btn btn-primary">
                                            <?php echo e(__('Add New')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent mt-auto">
                                <div class="btn-list justify-content-end">
                                    <a href="<?php echo e(route('user.cards')); ?>" class="btn">
                                        <?php echo e(__('Cancel')); ?>

                                    </a>
                                    <a href="<?php echo e(route('user.edit.testimonials', Request::segment(3))); ?>" class="btn btn-primary">
                                        <?php echo e(__('Skip')); ?>

                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Submit')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <div class="modal modal-blur fade" id="openMediaModel" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-xl modal-dialog-centered modal-dialog-scrollable" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('Media Library')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row row-cards" id="captions">
                        
                        <?php echo $__env->make('user.pages.edit-cards.media.upload', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        
                        <?php echo $__env->make('user.pages.edit-cards.media.list', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        
                        <div id="pagination"></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn me-auto" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                </div>
            </div>
        </div>
    </div>
</div>


<?php $__env->startPush('custom-js'); ?>
<script>
    var count = <?php echo e(count($galleries)); ?>;
    var currentSelection = 0;
    function addGallery() {
        "use strict";
        if (count>=<?php echo e($plan_details->no_of_galleries); ?>) {
            new swal({
                title: `<?php echo e(__('Oops!')); ?>`,
                icon: 'warning',
                text: `<?php echo e(__('You have reached your current plan limit.')); ?>`,
                timer: 2000,
                buttons: false,
                showConfirmButton: false,
            });
        }
    else {
        count++;
        var id = getRandomInt();
        var gallery =
            "<div class='row' id="+ id +"><div class='col-md-6 col-xl-6'><div class='mb-3'><label class='form-label required'><?php echo e(__('Gallery Image')); ?> <span class='text-muted'>(<?php echo e(__('Recommended : 200 x 200 pixels')); ?>)</span></label><div class='input-group mb-2'><input type='text' class='image"+ id +" media-model form-control' name='gallery_image[]' placeholder='<?php echo e(__('Gallery Image')); ?>' required><button class='btn btn-primary btn-md' type='button' onclick='openMedia("+ id +")'><?php echo e(__('Choose image')); ?></button></div></div></div><div class='col-md-6 col-xl-6'> <div class='mb-3'> <label class='form-label required'><?php echo e(__('Image Caption')); ?></label> <input type='text' class='form-control' name='caption[]' placeholder='<?php echo e(__('Image Caption')); ?>...' required> <a href='#' class='btn mt-3 btn-danger btn-sm' onclick='removeGallery("+id+")'><?php echo e(__('Remove')); ?></a> </div><br></div>";
            $("#more-gallery").append(gallery).html();
        }
    }

    // Remove service
    function removeGallery(id) {
    "use strict";
        $("#"+id).remove();
    }

    // Generate random number
    function getRandomInt() {
        min = Math.ceil(0);
        max = Math.floor(9999999999);
        return Math.floor(Math.random() * (max - min) + min); //The maximum is exclusive and the minimum is inclusive
    }

    // Open Media modal
    function openMedia(id){
        "use strict";
        currentSelection = id;
        $('#openMediaModel').modal('show');
    }
</script>

<script type="text/javascript">
    Dropzone.options.dropzone = {
            maxFilesize  : <?php echo e(env('SIZE_LIMIT')/1024); ?>,
            acceptedFiles: ".jpeg,.jpg,.png,.gif",
            init: function() {
            this.on("success", function(file, response) {
                loadMedia();
            });
        }
        };
</script>


<script>
    // Default values
    var currentPage = 1;
    var totalPages = 1;

    // Previous image
    function loadPreviousPage() {
        "use strict";

        if (currentPage > 1) {
            currentPage--;
            loadMedia(currentPage);
        }
    }

    // Next page
    function loadNextPage() {
        "use strict";

        if (currentPage < totalPages) {
            currentPage++;
            loadMedia(currentPage);
        }
    }

    // Load media images
    function loadMedia(page = 1) {
        $.ajax({
            url: '<?php echo e(route('user.media')); ?>',
            method: 'GET',
            data: { page: page },
            dataType: 'json',
            success: handleMediaResponse,
            error: function (xhr, status, error) {
                console.error(error);
            }
        });
    }

    // Media response
    function handleMediaResponse(response) {
        "use strict";
        
        var mediaData = response.media.data;
        if (mediaData.length > 0) {
            $('#noImagesFound').hide();
            $('#showPagination').removeClass('d-none').addClass('card pagination-card');
            displayMediaCards(mediaData);
            updatePaginationInfo(response.media);
        } else {
            $('#noImagesFound').show();
            $('#showPagination').addClass('d-none');
            $('#mediaCardsContainer').html('');
            updatePaginationInfo(response.media);
        }
    }

    // Display media images in card type
    function displayMediaCards(mediaData) {
        "use strict";
        
        // Generate media image
        var mediaCardsHtml = '';
        mediaData.forEach(function (media) {
            mediaCardsHtml += `
                <div class="col-md-3 mb-4">
                    <div class="card">
                        <img src="${media.base_url}${media.media_url}" class="card-img-top" style="height: 200px; object-fit: cover;" alt="${media.media_name}">
                        <div class="card-body">
                            <h5 class="card-title media-name">${media.media_name}</h5>
                            <a class="btn btn-icon btn-primary btn-md copyBoard" data-clipboard-text="${media.media_url}" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php echo e(__('Copy')); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <rect x="8" y="8" width="12" height="12" rx="2"></rect>
                                    <path d="M16 8v-2a2 2 0 0 0 -2 -2h-8a2 2 0 0 0 -2 2v8a2 2 0 0 0 2 2h2"></path>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            `;
        });
        $('#mediaCardsContainer').html(mediaCardsHtml);
    }

    // Update pagination
    function updatePaginationInfo(media) {
        "use strict";
        
        $('#paginationStartIndex').text(media.from);
        $('#paginationEndIndex').text(media.to);
        $('#paginationTotalCount').text(media.total);
        currentPage = media.current_page;
        totalPages = media.last_page;

        $('#prevPageBtn').prop('disabled', currentPage <= 1);
        $('#nextPageBtn').prop('disabled', currentPage >= totalPages);
    }

    // Load more image in pagination
    $(document).ready(function () {
        "use strict";
        
        loadMedia(); // Initial load
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        "use strict";
        
        var clipboard = new ClipboardJS('.copyBoard');

        // Success
        clipboard.on('success', function (e) {
            "use strict";

            // Place value in the field
            $('.image'+currentSelection).val(e.text);

            // Hide media modal
            $('#openMediaModel').modal('hide');
        });

        // Error
        clipboard.on('error', function (e) {
            "use strict";
        
            showErrorAlert('<?php echo e(__("Failed to copy text to clipboard. Please try again.")); ?>');
        });

        // Show success message
        function showSuccessAlert(message) {
            "use strict";
        
            showAlert(message, 'success');
        }

        // Show error message
        function showErrorAlert(message) {
            "use strict";
        
            showAlert(message, 'danger');
        }

        // Show alert
        function showAlert(message, type) {
            "use strict";
        
            var alertDiv = document.createElement('div');
            alertDiv.classList.add('alert', 'alert-important', 'alert-' + type, 'alert-dismissible');
            alertDiv.setAttribute('role', 'alert');

            var innerContent = '<div class="d-flex">' +
                '<div>' +
                message +
                '</div>' +
                '</div>' +
                '<a class="btn-close" data-bs-dismiss="alert" aria-label="close"></a>';

            alertDiv.innerHTML = innerContent;
            document.querySelector('#showAlert').appendChild(alertDiv);

            setTimeout(function () {
                "use strict";
        
                alertDiv.remove();
            }, 3000);
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/edit-galleries.blade.php ENDPATH**/ ?>