


<?php $__env->startSection('css'); ?>
    <style>
        .visitors-card {
            height: 450px !important;
        }
    </style>
<?php $__env->stopSection(); ?>


<?php
    use App\User;
    use App\Plan;
    use App\Category;
    use Illuminate\Support\Facades\Auth;

    // Get user plan details
    $plan = User::where('user_id', Auth::user()->user_id)->first();
    $active_plan = json_decode($plan->plan_details);

    // Default
    $purchasedPlan = '';

    // Check active plan
    if ($active_plan != null) {
        // Check plan type is exists
        if (isset($active_plan->plan_type) == false) {
            // Get plan details
            $getPlan = Plan::where('plan_id', Auth::user()->plan_id)->first();

            $active_plan->plan_type = env('APP_TYPE');
            $active_plan->no_of_vcard_products = $getPlan->no_of_services;
            $active_plan->no_of_links = $getPlan->no_of_links;
            $active_plan->no_testimonials = $getPlan->no_testimonials;
            $active_plan->business_hours = $getPlan->business_hours;
            $active_plan->contact_form = $getPlan->contact_form;
            $active_plan->no_of_enquires = $getPlan->no_of_enquires;
            $active_plan->no_of_stores = $getPlan->no_of_vcards;
            $active_plan->no_of_categories = $getPlan->no_of_categories;
            $active_plan->no_of_store_products = $getPlan->no_of_services;
            $active_plan->pwa = $getPlan->pwa;
            $active_plan->password_protected = $getPlan->password_protected;
            $active_plan->advanced_settings = $getPlan->advanced_settings;
            $active_plan->additional_tools = $getPlan->additional_tools;

            // Update existing users plan details
            User::where('user_id', Auth::user()->user_id)->update([
                'plan_details' => json_encode($active_plan),
            ]);

            // Add category
            $category = new Category();
            $category->user_id = Auth::user()->user_id;
            $category->category_id = 'others';
            $category->thumbnail = 'images/categories/others.avif';
            $category->category_name = 'Others';
            $category->save();

            $purchasedPlan = env('APP_TYPE');
        } else {
            $plan = User::where('user_id', Auth::user()->user_id)->first();
            $active_plan = json_decode($plan->plan_details);

            $purchasedPlan = $active_plan->plan_type;
        }
    }
?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Dashboard')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page title -->
        <div class="page-body">
            <div class="container-fluid">
                
                <?php if(Session::has("failed")): ?>
                <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('failed')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                
                <?php if(Session::has("success")): ?>
                <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                <div class="row mb-3">
                    <div class="col-sm-12 col-lg-12">
                        <div class="row row-deck row-cards">
                            
                            <div class="col-sm-6 <?php echo e($active_plan->plan_type == 'BOTH' ? 'col-lg-3' : 'col-lg-4'); ?>">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="subheader"><?php echo e(__('Current Plan')); ?></div>
                                        </div>
                                        <?php if($active_plan->plan_price == 0): ?>
                                            <div class="h1"><?php echo e(__($active_plan->plan_name)); ?></div>
                                            <p><?php echo e(__('FREE PLAN')); ?></p>
                                        <?php else: ?>
                                            <h1 class="text-uppercase"><b><?php echo e(__($active_plan->plan_name)); ?></b></h1>
                                        <?php endif; ?>
                                        <a href="<?php echo e(route('user.plans')); ?>">
                                            <?php echo e(__('Show details')); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>

                            
                            <?php if($active_plan->plan_type == 'VCARD'): ?>
                                
                                <div class="col-sm-6 col-lg-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="subheader"><?php echo e(__('Business Cards')); ?></div>
                                            </div>
                                            <div class="h1">
                                                <?php echo e($business_card == 999 ? __('Unlimited') : $business_card); ?></div>
                                            <a href="<?php echo e(route('user.cards')); ?>">
                                                <?php echo e(__('Show details')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            <?php if($active_plan->plan_type == 'STORE'): ?>
                                
                                <div class="col-sm-6 col-lg-4">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="subheader"><?php echo e(__('Stores')); ?></div>
                                            </div>
                                            <div class="h1"><?php echo e($storesCount == 999 ? __('Unlimited') : $storesCount); ?>

                                            </div>
                                            <a href="<?php echo e(route('user.stores')); ?>">
                                                <?php echo e(__('Show details')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            <?php if($active_plan->plan_type == 'BOTH'): ?>
                                
                                <div class="col-sm-6 col-lg-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="subheader"><?php echo e(__('Business Cards')); ?></div>
                                            </div>
                                            <div class="h1">
                                                <?php echo e($business_card == 999 ? __('Unlimited') : $business_card); ?></div>
                                            <a href="<?php echo e(route('user.cards')); ?>">
                                                <?php echo e(__('Show details')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="col-sm-6 <?php echo e($active_plan->plan_type == 'BOTH' ? 'col-lg-3' : 'col-lg-4'); ?>">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="subheader"><?php echo e(__('Stores')); ?></div>
                                            </div>
                                            <div class="h1"><?php echo e($storesCount == 999 ? __('Unlimited') : $storesCount); ?>

                                            </div>
                                            <a href="<?php echo e(route('user.stores')); ?>">
                                                <?php echo e(__('Show details')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            
                            <div class="col-sm-6 <?php echo e($active_plan->plan_type == 'BOTH' ? 'col-lg-3' : 'col-lg-4'); ?>">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-3">
                                            <div class="subheader"><?php echo e(__('Remaining Days')); ?></div>
                                        </div>

                                        <?php if($active_plan->validity == 9999): ?>
                                            <p class="h1"><?php echo e(__('Lifetime')); ?></p>
                                        <?php else: ?>
                                            <p class="h1">
                                                <?php echo e($remaining_days > 0 ? $remaining_days : __('Plan Expired!')); ?></p>
                                        <?php endif; ?>

                                        <a href="<?php echo e(route('user.plans')); ?>">
                                            <?php echo e(__('Show details')); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 col-lg-12 col-xl-8 mb-2">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader mb-2"><?php echo e(__('Overview')); ?></div>
                                </div>
                                <div class="row">
                                    <div class="col">
                                        <div id="cards"></div>
                                    </div>
                                    <div class="col-md-auto">
                                        <div class="divide-y divide-y-fill">
                                            <div></div>
                                            <div class="px-3">
                                                <div>
                                                    <span class="status-dot bg-orange"></span> <?php echo e(__('vCards')); ?>

                                                </div>
                                                <div class="h2"><?php echo e($totalvCards); ?></div>
                                            </div>
                                            <div class="px-3">
                                                <div>
                                                    <span class="status-dot bg-green"></span> <?php echo e(__('Stores')); ?>

                                                </div>
                                                <div class="h2"><?php echo e($totalStores); ?></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-12 col-lg-12 col-xl-4">
                        <div class="card">
                            <div class="card-body">
                                
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader mb-2"><?php echo e(__('Platforms')); ?></div>
                                </div>
                                <div id="platforms"></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="col-md-12 col-lg-12 col-xl-5 mb-2">
                        <div class="card">
                            <div class="card-header">
                                <div class="subheader"><?php echo e(__('This week\'s audience of cards')); ?></div>
                            </div>
                            <div class="card-body">
                                <div id="thisWeekAudience"></div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-12 col-lg-12 col-xl-4 mb-2">
                        <div class="card">
                            <div class="card-body">
                                
                                <div class="d-flex align-items-center mb-3">
                                    <div class="subheader mb-2"><?php echo e(__('Devices')); ?></div>
                                </div>
                                <div id="devices"></div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 col-lg-12 col-xl-3 mb-2">
                        <div class="card visitors-card">
                            <div class="card-header">
                                <div class="subheader"><?php echo e(__('Top 10 Most Viewed Cards')); ?></div>
                            </div>
                            <div class="card-table table-responsive">
                                <table class="table table-vcenter">
                                    <thead>
                                        <tr>
                                            <th><?php echo e(__('Card name')); ?></th>
                                            <th><?php echo e(__('Visitors')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        
                                        <?php $__currentLoopData = $highestCards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $highestCard): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <a href="<?php echo e(asset($highestCard['card'])); ?>" target="_blank">
                                                        <span
                                                            style="width: 150px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; display: block">/<?php echo e($highestCard['card']); ?>

                                                    </a>
                                                    </span>
                                                </td>
                                                <td><strong><?php echo e($highestCard['count']); ?></strong></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/apexcharts.min.js')); ?>"></script>
    <script>
        // Overview
        // @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            window.ApexCharts && (new ApexCharts(document.getElementById('cards'), {
                chart: {
                    type: "line",
                    fontFamily: 'inherit',
                    height: 212,
                    parentHeightOffset: 0,
                    toolbar: {
                        show: false,
                    },
                    animations: {
                        enabled: false
                    },
                },
                fill: {
                    opacity: 1,
                },
                stroke: {
                    width: 2,
                    lineCap: "round",
                    curve: "smooth",
                },
                series: [{
                    name: `<?php echo e(__('vCards')); ?>`,
                    data: [<?php echo e($vcards); ?>]
                }, {
                    name: `<?php echo e(__('Stores')); ?>`,
                    data: [<?php echo e($stores); ?>]
                }],
                tooltip: {
                    theme: 'dark'
                },
                grid: {
                    padding: {
                        top: -20,
                        right: 0,
                        left: -4,
                        bottom: -4
                    },
                    strokeDashArray: 4,
                },
                xaxis: {
                    labels: {
                        padding: 0,
                    },
                    tooltip: {
                        enabled: false
                    },
                    type: 'year',
                },
                yaxis: {
                    labels: {
                        padding: 4,
                    },
                },
                labels: [`<?php echo e(__('Jan')); ?>`, `<?php echo e(__('Feb')); ?>`, `<?php echo e(__('Mar')); ?>`,
                    `<?php echo e(__('Apr')); ?>`, `<?php echo e(__('May')); ?>`, `<?php echo e(__('Jun')); ?>`,
                    `<?php echo e(__('July')); ?>`, `<?php echo e(__('Aug')); ?>`, `<?php echo e(__('Sept')); ?>`,
                    `<?php echo e(__('Oct')); ?>`, `<?php echo e(__('Nov')); ?>`, `<?php echo e(__('Dec')); ?>`
                ],
                colors: ["#F76707", "#2FB344"],
                legend: {
                    show: false,
                },
            })).render();
        });
        // @formatter:on

        // Platforms
        // @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            window.ApexCharts && (new ApexCharts(document.getElementById('platforms'), {
                chart: {
                    type: "donut",
                    fontFamily: 'inherit',
                    height: 250,
                    sparkline: {
                        enabled: true
                    },
                    animations: {
                        enabled: false
                    },
                },
                fill: {
                    opacity: 1,
                },
                series: <?php echo json_encode($highestPlatforms['count']); ?>,
                labels: <?php echo json_encode($highestPlatforms['platform']); ?>,
                tooltip: {
                    theme: 'dark'
                },
                grid: {
                    strokeDashArray: 4,
                },
                colors: ["#4263eb", "#f76707", "#330902", "#1092a3", "#ed023d", "#007a0c", "#db25db"],
                legend: {
                    show: true,
                    position: 'bottom',
                    offsetY: 12,
                    markers: {
                        width: 10,
                        height: 10,
                        radius: 100,
                    },
                    itemMargin: {
                        horizontal: 8,
                        vertical: 8
                    },
                },
                tooltip: {
                    fillSeriesColor: false
                },
            })).render();
        });
        // @formatter:on

        // This Week Audience
        // @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            window.ApexCharts && (new ApexCharts(document.getElementById('thisWeekAudience'), {
                chart: {
                    type: "area",
                    fontFamily: 'inherit',
                    height: 355,
                    parentHeightOffset: 0,
                    toolbar: {
                        show: false,
                    },
                    animations: {
                        enabled: false
                    },
                    stacked: true,
                },
                dataLabels: {
                    enabled: false,
                },
                fill: {
                    opacity: .16,
                    type: 'solid'
                },
                stroke: {
                    width: 2,
                    lineCap: "round",
                    curve: "smooth",
                },
                series: [{
                    name: "<?php echo e(__('vCard')); ?>",
                    data: <?php echo json_encode($currentWeekVisitors['vcard']); ?>

                }, {
                    name: "<?php echo e(__('Store')); ?>",
                    data: <?php echo json_encode($currentWeekVisitors['store']); ?>

                }],
                tooltip: {
                    theme: 'dark'
                },
                grid: {
                    padding: {
                        top: -20,
                        right: 0,
                        left: -4,
                        bottom: -4
                    },
                    strokeDashArray: 4,
                },
                xaxis: {
                    labels: {
                        padding: 0,
                    },
                    tooltip: {
                        enabled: false
                    },
                    axisBorder: {
                        show: false,
                    },
                    categories: [`<?php echo e(__('Monday')); ?>`, `<?php echo e(__('Tuesday')); ?>`,
                        `<?php echo e(__('Wednesday')); ?>`, `<?php echo e(__('Thursday')); ?>`, `<?php echo e(__('Friday')); ?>`,
                        `<?php echo e(__('Saturday ')); ?>`, `<?php echo e(__('Sunday')); ?>`
                    ],
                },
                yaxis: {
                    labels: {
                        padding: 4
                    },
                },
                colors: ["#4263eb", "#f76707"],
                legend: {
                    show: false,
                },
            })).render();
        });
        // @formatter:on

        // Devices
        // @formatter:off
        document.addEventListener("DOMContentLoaded", function() {
            window.ApexCharts && (new ApexCharts(document.getElementById('devices'), {
                chart: {
                    type: "donut",
                    fontFamily: 'inherit',
                    height: 410,
                    sparkline: {
                        enabled: true
                    },
                    animations: {
                        enabled: false
                    },
                },
                fill: {
                    opacity: 1,
                },
                series: <?php echo json_encode($highestDevices['count']); ?>,
                labels: <?php echo json_encode($highestDevices['device']); ?>,
                tooltip: {
                    theme: 'dark'
                },
                grid: {
                    strokeDashArray: 4,
                },
                colors: ["#4263eb", "#f76707", "#330902", "#1092a3", "#ed023d", "#007a0c", "#db25db"],
                legend: {
                    show: true,
                    position: 'bottom',
                    offsetY: 12,
                    markers: {
                        width: 10,
                        height: 10,
                        radius: 100,
                    },
                    itemMargin: {
                        horizontal: 8,
                        vertical: 8
                    },
                },
                tooltip: {
                    fillSeriesColor: false
                },
            })).render();
        });
        // @formatter:on
    </script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/dashboard.blade.php ENDPATH**/ ?>