

<?php $__env->startSection('css'); ?>
<script src="<?php echo e(asset('js/html2pdf.bundle.min.js')); ?>"></script>
<script>
    function generatePDF() {
        const element = document.getElementById('invoice');
        html2pdf()
		.set({ filename: `<?php echo e($transaction->invoice_prefix); ?><?php echo e($transaction->invoice_number); ?>`+'.pdf', html2canvas: { scale: 4 } })
		.from(element)
		.save();
    }
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('Invoice')); ?>

                    </h2>
                </div>
                <!-- Page title actions -->
                <div class="col-auto ms-auto d-print-none">
                    <div class="dropdown">
                        <button type="button" class="btn btn btn-primary dropdown-toggle" data-bs-toggle="dropdown">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-printer" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M17 17h2a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2h-14a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h2"></path>
                                <path d="M17 9v-4a2 2 0 0 0 -2 -2h-6a2 2 0 0 0 -2 2v4"></path>
                                <path d="M7 13m0 2a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2z"></path>
                            </svg>
                            <?php echo e(__('Actions')); ?>

                        </button>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" onclick="generatePDF()" onclick="javascript:window.print();">
                                <?php echo e(__('Download')); ?>

                            </a>
                            <a class="dropdown-item" onclick="javascript:window.print();">
                                <?php echo e(__('Print')); ?>

                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="card card-lg">
                <div class="p-5" id="invoice">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-6">
                                <p class="h3"><?php echo e(__($transaction->billing_details['from_billing_name'])); ?></p>
                                <address>
                                    <?php echo e(__($transaction->billing_details['from_billing_name'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['from_billing_address'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_address'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['from_billing_state'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_state'])); ?>,
                                    <?php echo e(__($transaction->billing_details['from_billing_city'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_city'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['from_billing_country'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_country'])); ?>,
                                    <?php echo e(__($transaction->billing_details['from_billing_zipcode'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_zipcode'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['from_billing_email'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_email'])); ?>


                                    <br>
                                    <?php echo e(__($transaction->billing_details['from_billing_phone'] == null ? __('Not Available') :
                                    $transaction->billing_details['from_billing_phone'])); ?>

                                    <br>
                                    <br>
                                    <?php if($transaction->billing_details['from_vat_number'] != null): ?>
                                    <p><?php echo e(__('Tax Number:')); ?>

                                        <?php echo e(__($transaction->billing_details['from_vat_number'])); ?></p>
                                    <?php endif; ?>
                                </address>
                            </div>
                            <div class="col-6 text-end">
                                <p class="h3"><?php echo e(__($transaction->billing_details['to_billing_name'])); ?></p>
                                <address>
                                    <?php echo e(__($transaction->billing_details['to_billing_address'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_address'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['to_billing_state'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_state'])); ?>,
                                    <?php echo e(__($transaction->billing_details['to_billing_city'] == null ? __('Not Available')
                                    :
                                    $transaction->billing_details['to_billing_city'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['to_billing_country'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_country'])); ?>,
                                    <?php echo e(__($transaction->billing_details['to_billing_zipcode'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_zipcode'])); ?><br>
                                    <?php echo e(__($transaction->billing_details['to_billing_email'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_email'])); ?>

                                    <br>
                                    <?php echo e(__($transaction->billing_details['to_billing_phone'] == null ? __('Not Available') :
                                    $transaction->billing_details['to_billing_phone'])); ?>

                                    <br>
                                    <?php if($transaction->billing_details['to_vat_number'] != null): ?>
                                    <p><?php echo e(__('Tax Number:')); ?>

                                        <?php echo e(__($transaction->billing_details['to_vat_number'])); ?></p>
                                    <?php endif; ?>
                                </address>
                                <h4><?php echo e(__('INVOICE DATE')); ?> :
                                    <?php echo e(date('d-m-Y h:i A', strtotime($transaction->transaction_date))); ?></h4>
                            </div>
                            <?php if($transaction->invoice_number > 0): ?>
                            <div class="row">
                                <div class="col-10 my-5">
                                    <h1><?php echo e(__('INVOICE NO')); ?> :
                                        <?php echo e(__($transaction->invoice_prefix)); ?><?php echo e($transaction->invoice_number); ?></h1>
                                </div>
                                <div class="col-2">
                                    <img src="<?php echo e(asset('app/assets/elements/paid.png')); ?>"
                                        class="img-responsive p-3">
                                </div>
                            </div>
                            <?php endif; ?>

                        </div>
                        <table class="table table-transparent table-responsive">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 1%"></th>
                                    <th colspan="3"><?php echo e(__('Description')); ?></th>
                                    <th class="text-end" style="width: 1%"><?php echo e(__('Amount')); ?></th>
                                </tr>
                            </thead>
                            <tr>
                                <td class="text-center">1</td>
                                <td colspan="3">
                                    <p class="strong mb-1"><?php echo e(__('Extended')); ?> : <?php echo e(__($transaction->desciption)); ?></p>
                                    <div><?php echo e(__('Via')); ?> :
                                        <?php echo e(__($transaction->payment_gateway_name)); ?></div>
                                </td>
                                <td class="text-end">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($transaction->transaction_currency == $currency->iso_code): ?>
                                        <?php echo e($currency->symbol); ?><?php echo e(formatCurrency($transaction->billing_details['subtotal'])); ?>

                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4" class="strong text-end"><?php echo e(__('Subtotal')); ?></td>
                                <td class="text-end">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($transaction->transaction_currency == $currency->iso_code): ?>
                                        <?php echo e($currency->symbol); ?><?php echo e(formatCurrency($transaction->billing_details['subtotal'])); ?>

                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            </tr>

                            <?php if($transaction->billing_details['tax_amount'] > 0): ?>
                            <tr>
                                <td colspan="4" class="strong text-end">

                                    <?php echo e(__($transaction->billing_details['tax_name'])); ?> <?php echo e(__('Rate')); ?>


                                    (<?php echo e($transaction->billing_details['tax_value']); ?>%)

                                </td>

                                <td class="text-end">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($transaction->transaction_currency == $currency->iso_code): ?>
                                        <?php echo e($currency->symbol); ?><?php echo e(formatCurrency($transaction->billing_details['tax_amount'])); ?>

                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>

                            </tr>
                            <?php endif; ?>

                            
                            <?php if(isset($transaction->billing_details['applied_coupon']) != null): ?>
                            <tr>
                                <td colspan="4" class="font-weight-bold text-end"><strong><?php echo e(__('Applied Coupon')); ?> : <?php echo e($transaction->billing_details['applied_coupon']); ?></strong></td>
                                <td class="font-weight-bold text-end">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($transaction->transaction_currency == $currency->iso_code): ?>
                                        - <?php echo e($currency->symbol); ?><?php echo e(formatCurrency($transaction->billing_details['discounted_price'])); ?>

                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                            <?php endif; ?>

                            <tr>
                                <td colspan="4" class="font-weight-bold text-end"><strong><?php echo e(__('Total')); ?></strong></td>
                                <td class="font-weight-bold text-end">
                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($transaction->transaction_currency == $currency->iso_code): ?>
                                        <strong><?php echo e($currency->symbol); ?><?php echo e(formatCurrency($transaction->billing_details['invoice_amount'])); ?></strong>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>

                            </tr>
                        </table>
                        <p class="text-center mt-5">
                            <?php echo e(__($config[29]->config_value)); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/transactions/view-invoice.blade.php ENDPATH**/ ?>