

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('WHOIS Lookup')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            <div class="row row-deck row-cards">
                
                <div class="col-sm-6 col-lg-6">
                    <form action="<?php echo e(route('user.result.whois-lookup')); ?>" method="post" class="card">
                        <?php echo csrf_field(); ?>

                        <div class="card-body">
                            <div class="row">
                                
                                <div class="col-md-12 col-xl-12">
                                    <div class="mb-3">
                                        <label class="form-label required"><?php echo e(__('Domain')); ?></label>
                                        <input type="text" class="form-control" name="domain"
                                            value="<?php echo e($domain ?? (old('domain') ?? '')); ?>"
                                            placeholder="<?php echo e(__('Eg: https://domain.com')); ?>" required>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer text-end">
                            <button type="submit" class="btn btn-primary">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-search"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                    fill="none" stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="10" cy="10" r="7"></circle>
                                    <line x1="21" y1="21" x2="15" y2="15"></line>
                                </svg>
                                <?php echo e(__('Search')); ?>

                            </button>
                            <a href="<?php echo e(route('user.whois-lookup')); ?>" class="btn btn-dark">
                                <?php echo e(__('Reset')); ?>

                            </a>
                        </div>
                    </form>
                </div>

                
                <div class="col-sm-6 col-lg-6">
                    <?php if(isset($results)): ?>
                    <div class="card border-0 shadow-sm">
                        <div class="card-header align-items-center">
                            <div class="row">
                                <div class="col">
                                    <div class="font-weight-medium py-1"><?php echo e(__('Result')); ?></div>
                                </div>
                            </div>
                        </div>

                        <div class="card-body">
                            <?php if(empty($results)): ?>
                            <?php echo e(__('No results found.')); ?>

                            <?php else: ?>
                            <div class="list-group list-group-flush my-n3">
                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Domain')); ?></div>
                                        <div class="col-12 col-lg-8 text-break d-flex align-items-center">
                                            <img class="avatar avatar-sm"
                                                src="https://icons.duckduckgo.com/ip3/<?php echo e($results->domainName); ?>.ico"
                                                rel="noreferrer" class="rounded">
                                            <span><?php echo e($results->domainName); ?></span>
                                        </div>
                                    </div>
                                </div>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Registrar Name')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break"><?php echo e($results->registrar); ?></div>
                                    </div>
                                </div>

                                <?php if($results->owner): ?>
                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Registrant Name')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break"><?php echo e($results->owner); ?></div>
                                    </div>
                                </div>
                                <?php endif; ?>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Domain Created date')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break">
                                            <?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                                            \Carbon\Carbon::createFromTimestamp($results->creationDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                                            \Carbon\Carbon::createFromTimestamp($results->creationDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                                            config('app.timezone')))->toOffsetName()])); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Domain Updated date')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break">
                                            <?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                                            \Carbon\Carbon::createFromTimestamp($results->updatedDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                                            \Carbon\Carbon::createFromTimestamp($results->updatedDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                                            config('app.timezone')))->toOffsetName()])); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Domain Expiration
                                            date')); ?></div>
                                        <div class="col-12 col-lg-8 text-break">
                                            <?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                                            \Carbon\Carbon::createFromTimestamp($results->expirationDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                                            \Carbon\Carbon::createFromTimestamp($results->expirationDate)->tz(Auth::user()->timezone
                                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                                            config('app.timezone')))->toOffsetName()])); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('Domain Name servers')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break">
                                            <?php $__currentLoopData = $results->nameServers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serverName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-break <?php echo e(!$loop->first ? 'mt-1' : ''); ?>">
                                                <?php echo e($serverName); ?>

                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>

                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('States')); ?></div>
                                        <div class="col-12 col-lg-8 text-break">
                                            <?php $__currentLoopData = $results->states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stateName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="text-break <?php echo e(!$loop->first ? 'mt-1' : ''); ?>">
                                                <?php echo e($stateName); ?>

                                            </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>

                                <?php if($results->whoisServer): ?>
                                <div class="list-group-item px-0">
                                    <div class="row align-items-center">
                                        <div class="col-12 col-lg-4 text-break text-muted"><?php echo e(__('WHOIS server')); ?>

                                        </div>
                                        <div class="col-12 col-lg-8 text-break"><?php echo e($results->whoisServer); ?></div>
                                    </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="card border-0 shadow-sm">
                        <div class="card-header align-items-center">
                            <div class="row">
                                <div class="col">
                                    <div class="font-weight-bold"><?php echo e(__('Result')); ?></div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body mb-n3">
                            <div class="form-row">
                                <h2 class="text-center"><?php echo e(__('Waiting for result')); ?><span class="animated-dots"></span></h2>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/additional/whois-lookup.blade.php ENDPATH**/ ?>