

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title mb-2">
                        <?php echo e(__('Tax Settings')); ?>

                    </h2>
                    <p class="text-muted"><?php echo e(__('These details will be used for the invoice.')); ?></p>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <form action="<?php echo e(route('admin.update.tax.setting')); ?>" method="post" class="card">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Invoice Number Prefix')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_prefix"
                                                placeholder="<?php echo e(__('Invoice Number Prefix')); ?>..."
                                                value="<?php echo e($config[15]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Name')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_name"
                                                placeholder="<?php echo e(__('Name')); ?>..."
                                                value="<?php echo e($config[16]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Email')); ?> </label>
                                            <input type="email" class="form-control" name="invoice_email"
                                                placeholder="<?php echo e(__('Email')); ?>..."
                                                value="<?php echo e($config[17]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Phone')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_phone"
                                                placeholder="<?php echo e(__('Phone')); ?>..."
                                                value="<?php echo e($config[18]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Address')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_address"
                                                id="invoice_address" placeholder="<?php echo e(__('Address')); ?>..."
                                                value="<?php echo e($config[19]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('City')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_city"
                                                placeholder="<?php echo e(__('City')); ?>..."
                                                value="<?php echo e($config[20]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('State/Province')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_state"
                                                placeholder="<?php echo e(__('State/Province')); ?>..."
                                                value="<?php echo e($config[21]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('ZIP Code')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_zipcode"
                                                placeholder="<?php echo e(__('ZIP Code')); ?>..."
                                                value="<?php echo e($config[22]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Country')); ?> </label>
                                            <input type="text" class="form-control" name="invoice_country"
                                                placeholder="<?php echo e(__('Country')); ?>..."
                                                value="<?php echo e($config[23]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Tax Name')); ?> </label>
                                            <input type="text" class="form-control" name="tax_name"
                                                placeholder="<?php echo e(__('Tax Name')); ?>..."
                                                value="<?php echo e($config[24]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Tax ID')); ?> </label>
                                            <input type="text" class="form-control" name="tax_number"
                                                placeholder="<?php echo e(__('Tax ID')); ?>..."
                                                value="<?php echo e($config[26]->config_value); ?>" required>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Tax Value')); ?> </label>
                                            <input type="text" class="form-control" name="tax_value"
                                                placeholder="<?php echo e(__('Tax Value')); ?>..."
                                                value="<?php echo e($config[25]->config_value); ?>" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4 col-xl-4">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Invoice Footer')); ?> </label>
                                            <textarea class="form-control" name="invoice_footer" id="invoice_footer"
                                                cols="10" rows="3" placeholder="<?php echo e(__('Invoice Footer')); ?>..."
                                                required><?php echo e($config[29]->config_value); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo e(__('Save')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="row row-deck row-cards mt-5">
                <h2 class="page-title">
                    <?php echo e(__('Invoice Email Settings')); ?>

                </h2>
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <form action="<?php echo e(route('admin.update.email.setting')); ?>" method="post" class="card">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-4 col-xl-6">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Email Heading')); ?> </label>
                                            <textarea class="form-control" name="email_heading" id="email_heading"
                                                cols="30" rows="3" placeholder="<?php echo e(__('Email Heading')); ?>..."
                                                required><?php echo e($config[27]->config_value); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-xl-6">
                                        <div class="mb-3">
                                            <label class="form-label"><?php echo e(__('Email Footer')); ?> </label>
                                            <textarea class="form-control" name="email_footer" id="email_footer"
                                                cols="30" rows="3" placeholder="<?php echo e(__('Email Footer')); ?>..."
                                                required><?php echo e($config[28]->config_value); ?></textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <button type="submit" class="btn btn-primary">
                                    <?php echo e(__('Save')); ?>

                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/tax/index.blade.php ENDPATH**/ ?>