<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Choose a Card Type')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-6 col-md-2 col-xl-2 col-lg-2">

                    <div class="card">

                        <label class="form-imagecheck mb-2">
                            <input name="card-type" type="radio" value="business" class="form-imagecheck-input"
                                onclick="chooseCardTpe(this)">
                            <span class="shadow-none">
                                <img src="<?php echo e(asset("img/vCards/business.png")); ?>" alt="<?php echo e(__('Business')); ?>"
                                    class="form-imagecheck-image p-2">
                            </span>
                            <h4 class="text-center mt-4"><?php echo e(__('Business')); ?></h4>
                        </label>

                    </div>

                </div>
                <div class="col-6 col-md-2 col-xl-2 col-lg-2">

                    <div class="card">

                        <label class="form-imagecheck mb-2">
                            <input name="card-type" type="radio" value="personal" class="form-imagecheck-input"
                                onclick="chooseCardTpe(this)">
                            <span class="shadow-none">
                                <img src="<?php echo e(asset("img/vCards/personal.png")); ?>" alt="<?php echo e(__('Personal')); ?>"
                                    class="form-imagecheck-image p-2">
                            </span>
                            <h4 class="text-center mt-4"><?php echo e(__('Personal')); ?></h4>
                        </label>

                    </div>

                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startPush('custom-js'); ?>
<script>
    function chooseCardTpe(selectedCard) {
    var selectedCardValue = selectedCard.value;
    if (selectedCardValue == "business") {
        window.location = `<?php echo e(route('user.create.card', 'type=business')); ?>`;
    } else {
        window.location = `<?php echo e(route('user.create.card', 'type=personal')); ?>`;
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/cards/choose-a-card.blade.php ENDPATH**/ ?>