

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Software Update')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-cards">
                
                <div class="col-sm-12 col-lg-8">
                    <div class="card">
                        <form action="<?php echo e(route('admin.check.update')); ?>" method="post" class="card">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    
                                    <div class="col-md-6 col-xl-6">
                                        <div class="mb-3">
                                            <label class="form-label required"><?php echo e(__('Envato Purchase Code')); ?></label>
                                            <input type="text" class="form-control" name="purchase_code"
                                                placeholder="<?php echo e(__('Envato Purchase Code')); ?>..."
                                                value="<?php echo e($purchase_code); ?>" required>
                                            <small class="form-hint">
                                                <p><a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-"
                                                        target="_blank"><?php echo e(__("Where is my purchase code?")); ?></a>
                                                </p>
                                            </small>
                                        </div>
                                    </div>
                                    <div class="col-md-12 col-xl-12 mt-2">
                                        <button type="submit" class="btn btn-primary btn-md ms-auto">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="icon icon-tabler icon-tabler-refresh" width="24" height="24"
                                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                                stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                                <path d="M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"></path>
                                                <path d="M4 13a8.1 8.1 0 0 0 15.5 2m.5 4v-4h-4"></path>
                                            </svg>
                                            <?php echo e(__('Check update')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>

                        </form>
                    </div>


                    
                    <?php if(isset($response)): ?>
                    <div class="col-sm-12 col-lg-12 p-2 mt-3">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="row">
                                        <div class="alert alert-success bg-white">
                                            <h1 class="display-5 "><?php echo e($response['version']); ?></h1>
                                            <p class="mb-3 h1"><?php echo e($response['message']); ?></p>
                                            <?php if($response['update'] == true): ?>
                                            <p class="text-dark mb-4"><?php echo $response['notes']; ?></p>
                                            <p><?php echo e(__('IMPORTANT: Before starting this process, we recommend you to take a backup of your files.')); ?></p>
                                            <?php endif; ?>
                                        </div>

                                        
                                        <?php if($response['update'] == true): ?>
                                        <form action="<?php echo e(route('admin.update.code')); ?>" method="post">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" class="form-control" name="app_version"
                                                value="<?php echo e($response['version']); ?>">
                                            <div class="col-md-12 col-xl-12">
                                                <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                    <?php echo e(__('Install')); ?>

                                                </button>
                                            </div>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <div class="col-sm-12 col-lg-4 d-block">
                    <img src="<?php echo e(asset('img/piracy.png')); ?>" alt="Piracy">

                    
                    <?php if(isset($response)): ?>
                    
                    <?php if($response['license'] == 'Regular License'): ?>
                    <a href="https://codecanyon.net/cart/configure_before_adding/33165916?license=extended&ref=nativecode&size=source"
                        target="_blank" rel="noopener noreferrer">
                        <img class="mt-3" src="<?php echo e(asset('img/upgrade-to-extended-license.png')); ?>"
                            alt="Upgrade to Extended License">
                    </a>
                    <?php endif; ?>
                    <?php if($response['license'] == 'Extended License'): ?>
                    <a href="https://codecanyon.net/user/nativecode" target="_blank" rel="noopener noreferrer">
                        <img class="mt-3" src="<?php echo e(asset('img/in-extended-license.png')); ?>" alt="Get Support">
                    </a>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>

            </div>
        </div>
    </div>
    
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/update/index.blade.php ENDPATH**/ ?>