

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Checkout')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-body">
            <?php if($selected_plan == null): ?>
                <div class="container-fluid mt-3">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h3 class="card-title"><?php echo e(__('No Plan Found')); ?></h3>
                                <a href="<?php echo e(route('user.pages.checkout', Request::segment(3))); ?>"
                                    class="btn btn-primary"><?php echo e(__('Back')); ?></a>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="container-fluid mt-3">
                    
                    <?php if(Session::has('failed')): ?>
                        <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                            <div class="d-flex">
                                <div>
                                    <?php echo e(Session::get('failed')); ?>

                                </div>
                            </div>
                            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(Session::has('success')): ?>
                        <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                            <div class="d-flex">
                                <div>
                                    <?php echo e(Session::get('success')); ?>

                                </div>
                            </div>
                            <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                        </div>
                    <?php endif; ?>

                    <div class="row">
                        <div class="col-lg-4 mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <h3 class="card-title"><?php echo e(__('Upgrade/Renewal Plan')); ?></h3>
                                    <div class="card-table table-responsive">
                                        <table class="table table-vcenter">
                                            <thead>
                                                <tr>
                                                    <th class="w-1"><?php echo e(__('Description')); ?></th>
                                                    <th class="w-1"><?php echo e(__('Price')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <div>
                                                            <?php echo e(__($selected_plan->plan_name)); ?> -
                                                            <?php echo e(__($selected_plan->validity)); ?>

                                                            <?php echo e(__('Days')); ?>

                                                        </div>
                                                    </td>
                                                    <td class="text-bold text-end">
                                                        <?php echo e($currency->symbol); ?><?php echo e($selected_plan->plan_price == '0' ? 0 : formatCurrency($selected_plan->plan_price)); ?>

                                                    </td>
                                                </tr>
                                                <?php if($config[25]->config_value > 0): ?>
                                                    <tr>
                                                        <td>
                                                            <div>
                                                                <?php echo e(__($config[24]->config_value)); ?>

                                                                (<?php echo e($config[25]->config_value); ?>%)
                                                            </div>
                                                        </td>
                                                        <td class="text-bold text-end">
                                                            <?php echo e($currency->symbol); ?><?php echo e(formatCurrency(((float) $selected_plan->plan_price * (float) $config[25]->config_value) / 100)); ?>

                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                                <tr class="d-none" id="appliedCoupon"></tr>
                                                <tr>
                                                    <td class="h5 text-bold"> <?php echo e(__('Total Payable Amount')); ?> </td>
                                                    <td class="w-1 text-bold h3 text-end" id="total">
                                                        <?php echo e($currency->symbol); ?><?php echo e(formatCurrency($total)); ?>

                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <!-- Coupon Code -->
                                    <form id="couponForm" class="my-3">
                                        <div class="input-group">
                                            <input type="text"
                                                class="form-control text-uppercase"
                                                placeholder="<?php echo e(__('Coupon Code')); ?>"
                                                value="<?php echo e(old('coupon_code') ?? $coupon_code); ?>" name="coupon_code" id="coupon_code">
                                            <button type="submit" class="btn btn-primary mx-2" id="applyCoupon"><?php echo e(__('Apply')); ?></button>
                                        </div>
                                        <p class="fw-bold mt-2" id="discountMessage"></p>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-8">
                            <form action="<?php echo e(route('prepare.payment.gateway', $selected_plan->plan_id)); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                <div class="col-lg-12 mb-3">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="row">
                                                    <h3 class="card-title text-muted mb-3"><?php echo e(__('Billing Details')); ?></h1>
                                                    <input type="hidden" name="applied_coupon" id="applied_coupon" class="form-control">
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('Name')); ?></label>
                                                            <input type="text" class="form-control" name="billing_name" placeholder="<?php echo e(__('Name')); ?>" value="<?php echo e(Auth::user()->billing_name == null ? Auth::user()->name : Auth::user()->billing_name); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('Email')); ?></label>
                                                            <input type="email" class="form-control"
                                                                name="billing_email" placeholder="<?php echo e(__('Email')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_email == null ? Auth::user()->email : Auth::user()->billing_email); ?>"
                                                                required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('Phone')); ?></label>
                                                            <input type="tel" class="form-control"
                                                                name="billing_phone" placeholder="<?php echo e(__('Phone')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_phone); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('Address')); ?></label>
                                                            <input type="tel" class="form-control"
                                                                name="billing_address" id="billing_address"
                                                                placeholder="<?php echo e(__('Address')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_address); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('City')); ?></label>
                                                            <input type="text" class="form-control"
                                                                name="billing_city" placeholder="<?php echo e(__('City')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_city); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4 col-xl-4">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('State/Province')); ?></label>
                                                            <input type="text" class="form-control"
                                                                name="billing_state"
                                                                placeholder="<?php echo e(__('State/Province')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_state); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xl-6">
                                                        <div class="mb-3">
                                                            <label class="form-label required"><?php echo e(__('Zip Code')); ?></label>
                                                            <input type="text" class="form-control"
                                                                name="billing_zipcode"
                                                                placeholder="<?php echo e(__('Zip Code')); ?>"
                                                                value="<?php echo e(Auth::user()->billing_zipcode); ?>" required>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xl-6">
                                                        
                                                        <?php echo $__env->make('user.pages.checkout.includes.countries', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                    </div>
                                                    <div class="col-md-6 col-xl-6">
                                                        <div class="mb-3">
                                                            <label class="form-label required" for="type"><?php echo e(__('Type')); ?></label>
                                                            <select name="type" id="type"
                                                                class="form-control" required>
                                                                <option value="personal"
                                                                    <?php echo e(Auth::user()->type == 'personal' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Personal')); ?></option>
                                                                <option value="business"
                                                                    <?php echo e(Auth::user()->type == 'business' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Business')); ?></option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-6 col-xl-6">
                                                        <div class="mb-3">
                                                            <label class="form-label"><?php echo e(__('Tax Number')); ?> </label>
                                                            <input type="text" class="form-control"
                                                                name="vat_number"
                                                                placeholder="<?php echo e(__('Tax Number')); ?>"
                                                                value="<?php echo e(Auth::user()->vat_number); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <h3 class="card-title text-muted"><?php echo e(__('Payment method')); ?></h3>
                                            <div class="row">
                                                <div class="col-lg-12">
                                                    <div class="mb-3">
                                                        <div class="row">
                                                            <input type="hidden" name="payment_gateway_amount" id="payment_gateway_amount" value="<?php echo e($total); ?>" class="form-control">
                                                            <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="col-lg-4 mb-3">
                                                                    <div
                                                                        class="form-selectgroup form-selectgroup-boxes d-flex flex-column">
                                                                        <label class="form-selectgroup-item flex-fill">
                                                                            <input type="radio" name="payment_gateway_id" value="<?php echo e($gateway->payment_gateway_id); ?>" class="form-selectgroup-input">
                                                                            <div
                                                                                class="form-selectgroup-label d-flex align-items-center p-3">
                                                                                <div class="me-3">
                                                                                    <span
                                                                                        class="form-selectgroup-check"></span>
                                                                                </div>
                                                                                <span class="avatar me-3"
                                                                                    style="background-image: url(<?php echo e(asset($gateway->payment_gateway_logo)); ?>)"></span>
                                                                                <div>
                                                                                    <div class="font-weight-medium h4">
                                                                                        <?php echo e(__($gateway->display_name)); ?>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <input type="submit" value="<?php echo e(__('Continue for payment')); ?>"
                                                            class="btn btn-primary">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    
<?php $__env->startSection('scripts'); ?>
    <script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/confetti.browser.min.js')); ?>"></script>
    <script>
        // Array of element IDs
        var elementIds = ['billing_country', 'type'];

        // Loop through each element ID
        elementIds.forEach(function(id) {
            // Check if the element exists
            var el = document.getElementById(id);
            if (el) {
                // Apply TomSelect to the element
                new TomSelect(el, {
                    copyClassesToDropdown: false,
                    dropdownClass: 'dropdown-menu ts-dropdown',
                    optionClass: 'dropdown-item',
                    controlInput: '<input>',
                    maxOptions: null,
                    render: {
                        item: function(data, escape) {
                            if (data.customProperties) {
                                return '<div><span class="dropdown-item-indicator">' + data
                                    .customProperties + '</span>' + escape(data.text) + '</div>';
                            }
                            return '<div>' + escape(data.text) + '</div>';
                        },
                        option: function(data, escape) {
                            if (data.customProperties) {
                                return '<div><span class="dropdown-item-indicator">' + data
                                    .customProperties + '</span>' + escape(data.text) + '</div>';
                            }
                            return '<div>' + escape(data.text) + '</div>';
                        },
                    },
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<script>
    document.getElementById('couponForm').addEventListener('submit', function (e) {
        "use strict";
        e.preventDefault();  // Prevent form from submitting the traditional way
        
        let form = this;
        let formData = new FormData(form);
        let couponCodeInput = document.getElementById('coupon_code');
        let appliedCoupon = document.getElementById('appliedCoupon');
        let discountMessage = document.getElementById('discountMessage');
        let applied_coupon = document.getElementById('applied_coupon');
        let applyCoupon = document.getElementById('applyCoupon');

        fetch('<?php echo e(route('user.checkout.coupon', $selected_plan->plan_id)); ?>', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            },
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // trigger confetti
                confetti({
                    particleCount: 200,
                    spread: 900,
                    colors: ['#f1c40f', '#f39c12', '#e67e22', '#e74c3c', '#9b59b6', '#8e44ad', '#7f8c8d'],
                });

                couponCodeInput.classList.remove('is-invalid');
                couponCodeInput.classList.add('is-valid');
                appliedCoupon.classList.remove('d-none');

                // Update the table with coupon code and discount
                let newRow = `
                    <tr>
                        <td><?php echo e(__('Coupon Code')); ?> : <strong>${data.coupon_code}</strong></td>
                        <td class="text-bold text-end">-<?php echo e($currency->symbol); ?>${parseFloat(data.discountPrice).toFixed(2)}</td>
                    </tr>
                `;
                appliedCoupon.innerHTML = newRow;  // Replace the existing table with the new one

                // Display discount message
                discountMessage.innerHTML = '<?php echo e(__('Coupon applied!')); ?>';

                // Update the total
                if (data.total > 0) {
                    document.getElementById('total').innerHTML = '<?php echo e($currency->symbol); ?>' + data.total.toFixed(2);
                    // Update payment_gateway_amount value
                    document.getElementById('payment_gateway_amount').value = data.total;
                } else {
                    document.getElementById('total').innerHTML = '<?php echo e($currency->symbol); ?>0.00';
                    // Update payment_gateway_amount value
                    document.getElementById('payment_gateway_amount').value = 0;
                }

                // Update the coupon code input
                applied_coupon.value = data.coupon_id;
            } else {
                couponCodeInput.classList.remove('is-valid');
                couponCodeInput.classList.add('is-invalid');
                appliedCoupon.classList.add('d-none');
                appliedCoupon.innerHTML = "";  // Replace the existing table with the new one
                discountMessage.innerHTML = data.message;
                // Update the total
                document.getElementById('total').innerHTML = '<?php echo e($currency->symbol); ?><?php echo e(formatCurrency($total)); ?>';

                // Update the total
                applied_coupon.value = "";
            }
        })
        .catch(error => console.error('Error:', error));
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/checkout/checkout.blade.php ENDPATH**/ ?>