


<?php $__env->startSection('custom-script'); ?>
<script src="<?php echo e(asset('js/clipboard.min.js')); ?>"></script>
<?php if($settings->google_adsense_code != 'DISABLE_ADSENSE_ONLY'): ?>

<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>" crossorigin="anonymous"></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div>
    <section class="text-gray-700">
        <div class="container px-5 py-12 mx-auto">
            
            <div class="mb-2">
                <h1 class="text-3xl font-bold font-large title-font text-gray-900 mb-4">
                    <?php echo e(__('JS Minifier')); ?>

                </h1>
            </div>

            
            <form action="<?php echo e(route('web.result.js.minifier')); ?>" method="post">
                <?php echo csrf_field(); ?>
                
                <div class='mb-3 space-y-2 w-full'>
                    <label class='font-bold text-gray-600 py-2'><?php echo e(__('JS Code')); ?> <abbr title='required'>*</abbr></label>
                    <textarea name="js" id="js" cols="30" rows="10" class="appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter font-mono text-base text-black rounded-lg h-48 px-4 py-2" placeholder="<?php echo e(__('JS Code')); ?>"><?php if(isset($js)): ?><?php echo e($js); ?><?php endif; ?></textarea>
                </div>

                <button type="submit" class="group relative font-heading px-10 py-5 mb-8 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-md" onclick="convert()"><?php echo e(__('Convert')); ?></button>
            </form>

            
            <?php if(isset($results)): ?>
                <div class='mb-3 space-y-2 w-full'>
                    <label class='font-bold text-gray-600 py-2'><?php echo e(__('Output')); ?> <abbr title='required'>*</abbr></label>
                    <textarea name="result" id="result" cols="30" rows="10" class="appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter font-mono text-base text-black rounded-lg h-48 px-4 py-2" placeholder="<?php echo e(__('Output')); ?>"><?php echo e($results); ?></textarea>
                </div>

                <button class="copyBtn group relative font-heading px-10 py-5 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-md" data-clipboard-action="copy" data-clipboard-target="#result"><?php echo e(__('Copy to clipboard')); ?></button>
            <?php endif; ?>
        </div>
    </section>
</div>


<?php $__env->startSection('custom-js'); ?>
<script>
new ClipboardJS('.copyBtn');
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', ['nav' => true, 'banner' => false, 'footer' => true, 'cookie' => true, 'setting' => true,
'title' => __('JS Minifier - Web Tools')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/website/pages/web-tools/js-minifier.blade.php ENDPATH**/ ?>