


<?php $__env->startSection('css'); ?>
<style>
    .ts-control>input {
        display: contents !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Edit Plan')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <form action="<?php echo e(route('admin.update.plan')); ?>" method="post" class="card">
                        <?php echo csrf_field(); ?>
                        <div class="card-header">
                            <h4 class="page-title"><?php echo e(__('Plan Details')); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="row">
                                        <input type="hidden" class="form-control" name="plan_id"
                                            placeholder="<?php echo e(__('Plan ID')); ?>" value="<?php echo e($plan_details->plan_id); ?>"
                                            readonly>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Recommended Plan')); ?></div>
                                                <select class="form-select recommended" name="recommended">
                                                    <option value="on" <?php echo e($plan_details->recommended == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->recommended == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Private Plan')); ?></div>
                                                <select class="form-select is_private" name="is_private">
                                                    <option value="on" <?php echo e($plan_details->is_private == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->is_private == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4"></div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label required"><?php echo e(__('Plan Type')); ?></div>
                                                <select class="form-select plan_type" name="plan_type" onchange="checkPlanType(this)" required>
                                                    <option value="" selected disabled><?php echo e(__('Choose a plan type')); ?></option>
                                                    <option value="BOTH" class="<?php echo e($plan_details->plan_type == "BOTH" ? "selected" : "d-none"); ?>" <?php echo e($plan_details->plan_type == "BOTH" ? "selected" : "disabled"); ?>><?php echo e(__('Both')); ?></option>
                                                    <option value="VCARD" class="<?php echo e($plan_details->plan_type == "VCARD" ? "selected" : "d-none"); ?>"  <?php echo e($plan_details->plan_type == "VCARD" ? "selected" : "disabled"); ?>><?php echo e(__('vCard Only')); ?></option>
                                                    <option value="STORE" class="<?php echo e($plan_details->plan_type == "STORE" ? "selected" : "d-none"); ?>"  <?php echo e($plan_details->plan_type == "STORE" ? "selected" : "disabled"); ?>><?php echo e(__('Store Only')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Plan Name')); ?></label>
                                                <input type="text" class="form-control" name="plan_name"
                                                    placeholder="<?php echo e(__('Plan Name')); ?>"
                                                    value="<?php echo e($plan_details->plan_name); ?>" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Description')); ?></label>
                                                <input type="text" class="form-control" name="plan_description"
                                                    placeholder="<?php echo e(__('Description')); ?>"
                                                    value="<?php echo e($plan_details->plan_description); ?>" required>

                                            </div>
                                        </div>
                                        <h2 class="page-title my-3">
                                            <?php echo e(__('Plan Prices')); ?>

                                        </h2>
                                        <div class="col-md-6 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Price')); ?></label>
                                                <input type="number" class="form-control" name="plan_price" min="0"
                                                    step="0.01" placeholder="<?php echo e(__('Price')); ?>"
                                                    value="<?php echo e($plan_details->plan_price); ?>" required>
                                                <small class="text-muted"><?php echo e(__('For free, enter 0')); ?> </small>
                                            </div>
                                        </div>

                                        <div class="col-md-6 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Validity')); ?></label>
                                                <input type="number" class="form-control" name="validity" min="1"
                                                    max="9999" placeholder="<?php echo e(__('Validity')); ?>"
                                                    value="<?php echo e($plan_details->validity); ?>" required>
                                                <small class="text-muted"><?php echo e(__('For forever, enter 9999')); ?> </small>
                                            </div>
                                        </div>

                                        
                                        <?php if($plan_details->plan_type == "BOTH" || $plan_details->plan_type == "VCARD"): ?>
                                        <div class="row" id="vcard-features">
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('vCard Features')); ?>

                                            </h2>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of vCards')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_vcards" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of vCards')); ?>"
                                                        value="<?php echo e($plan_details->no_of_vcards); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Services')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_services" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Services')); ?>"
                                                        value="<?php echo e($plan_details->no_of_services); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Products')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_vcard_products" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Products')); ?>"
                                                        value="<?php echo e($plan_details->no_of_vcard_products); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Links')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_links" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Links')); ?>"
                                                        value="<?php echo e($plan_details->no_of_links); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Payment Listed')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_payments" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Payment Listed')); ?>"
                                                        value="<?php echo e($plan_details->no_of_payments); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div> 
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Testimonials')); ?></label>
                                                    <input type="number" class="form-control" name="no_testimonials" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Testimonials')); ?>"
                                                        value="<?php echo e($plan_details->no_testimonials); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div> 
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Galleries')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_galleries" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Galleries')); ?>"
                                                        value="<?php echo e($plan_details->no_of_galleries); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Business Hours')); ?></div>
                                                    <select class="form-select business_hours" name="business_hours" required>
                                                        <option value="on" <?php echo e($plan_details->business_hours == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                        <option value="off" <?php echo e($plan_details->business_hours == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Appointment')); ?></div>
                                                    <select class="form-select appointment" name="appointment" required>
                                                        <option value="on" <?php echo e($plan_details->appointment == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                        <option value="off" <?php echo e($plan_details->appointment == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Contact Form')); ?></div>
                                                    <select class="form-select contact_form" name="contact_form" required>
                                                        <option value="on" <?php echo e($plan_details->contact_form == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                        <option value="off" <?php echo e($plan_details->contact_form == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('No. of Enquiries')); ?></div>
                                                    <input type="number" class="form-control" name="no_of_enquires" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Enquiries')); ?>"
                                                        value="<?php echo e($plan_details->no_of_enquires); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        
                                        
                                        <?php if($plan_details->plan_type == "BOTH" || $plan_details->plan_type == "STORE"): ?>
                                        <div class="row" id="store-features">
                                            <h2 class="page-title mb-3">
                                                <?php echo e(__('Store Features')); ?>

                                            </h2>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Stores')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_stores" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Stores')); ?>"
                                                        value="<?php echo e($plan_details->no_of_stores); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Categories')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_categories" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Categories')); ?>"
                                                        value="<?php echo e($plan_details->no_of_categories); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                            <div class="col-md-6 col-xl-2">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('No. of Products')); ?></label>
                                                    <input type="number" class="form-control" name="no_of_store_products" min="1"
                                                        max="999" placeholder="<?php echo e(__('No. of Products')); ?>"
                                                        value="<?php echo e($plan_details->no_of_store_products); ?>" required>
                                                    <small class="text-muted"><?php echo e(__('For unlimited, enter 999')); ?> </small>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <h2 class="page-title my-3">
                                            <?php echo e(__('Additional features')); ?>

                                        </h2>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label required"><?php echo e(__('Custom Domain')); ?></div>
                                                <select class="form-select custom_domain" name="custom_domain" required>
                                                    <option value="on" <?php echo e($plan_details->custom_domain == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->custom_domain == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label required">
                                                    <?php echo e(__('Advanced Settings')); ?> 
                                                </div>
                                                <select class="form-select advanced_settings" name="advanced_settings" required>
                                                    <option value="on" <?php echo e($plan_details->advanced_settings == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->advanced_settings == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label required">
                                                    <?php echo e(__('PWA')); ?> 
                                                    <span class="form-help bg-primary text-white" data-bs-toggle="popover" data-bs-placement="top" data-bs-html="true" data-bs-content="<p><?php echo e(__('PWA stands for Progressive Web Application. PWAs are web applications that are built using common web technologies like HTML, CSS, JavaScript, and WebAssembly. They are designed to work on any platform with a standards-compliant browser, including desktop and mobile devices.')); ?></p>">?</span>
                                                </div>
                                                <select class="form-select pwa" name="pwa" required>
                                                    <option value="on" <?php echo e($plan_details->pwa == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->pwa == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label required">
                                                    <?php echo e(__('Additional Tools')); ?> 
                                                </div>
                                                <select class="form-select additional_tools" name="additional_tools" required>
                                                    <option value="on" <?php echo e($plan_details->additional_tools == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->additional_tools == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Personalized Link')); ?></div>
                                                <select class="form-select personalized_link" name="personalized_link">
                                                    <option value="on" <?php echo e($plan_details->personalized_link == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->personalized_link == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Hide Branding')); ?></div>
                                                <select class="form-select hide_branding" name="hide_branding">
                                                    <option value="on" <?php echo e($plan_details->hide_branding == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->hide_branding == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Free Setup')); ?></div>
                                                <select class="form-select free_setup" name="free_setup">
                                                    <option value="on" <?php echo e($plan_details->free_setup == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->free_setup == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Free Support')); ?></div>
                                                <select class="form-select free_support" name="free_support">
                                                    <option value="on" <?php echo e($plan_details->free_support == 1 ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                    <option value="off" <?php echo e($plan_details->free_support == 0 ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
<script>
function checkPlanType(type) {
    "use strict";
    var planType = type.value;
    switch (planType) { 
        case 'VCARD': 

            // Remove store inputs "required" attributes
            $("input[name='no_of_stores']").removeAttr('required');
            $("input[name='no_of_categories']").removeAttr('required');
            $("input[name='no_of_store_products']").removeAttr('required');

            // Hidden store
            $("#store-features").attr("class", "row d-none");

            // Add vcard inputs "required" attributes
            $("input[name='no_of_vcards']").attr('required', 'required');
            $("input[name='no_of_services']").attr('required', 'required');
            $("input[name='no_of_vcard_products']").attr('required', 'required');
            $("input[name='no_of_links']").attr('required', 'required');
            $("input[name='no_of_payments']").attr('required', 'required');
            $("input[name='no_of_galleries']").attr('required', 'required');
            $("input[name='no_testimonials']").attr('required');
            $("input[name='business_hours']").attr('required', 'required');
            $("input[name='contact_form']").attr('required', 'required');
            $("input[name='no_of_enquires']").attr('required', 'required');

            // Enable vcard
            $("#vcard-features").attr("class", "row");

            break;
        case 'STORE': 

            // Remove vcard inputs "required" attributes
            $("input[name='no_of_vcards']").removeAttr('required');
            $("input[name='no_of_services']").removeAttr('required');
            $("input[name='no_of_vcard_products']").removeAttr('required');
            $("input[name='no_of_links']").removeAttr('required');
            $("input[name='no_of_payments']").removeAttr('required');
            $("input[name='no_of_galleries']").removeAttr('required');
            $("input[name='business_hours']").removeAttr('required');
            $("input[name='contact_form']").removeAttr('required');
            $("input[name='no_testimonials']").removeAttr('required');
            $("input[name='no_of_enquires']").removeAttr('required');

            // Hidden vcard
            $("#vcard-features").attr("class", "row d-none");

            // Add store inputs "required" attributes
            $("input[name='no_of_stores']").attr('required', 'required');
            $("input[name='no_of_categories']").attr('required', 'required');
            $("input[name='no_of_store_products']").attr('required', 'required');

            // Enable Store
            $("#store-features").attr("class", "row");

            break;
        default:
            // Add vcard/store inputs "required" attributes
            $("input[name='no_of_vcards']").attr('required', 'required');
            $("input[name='no_of_services']").attr('required', 'required');
            $("input[name='no_of_vcard_products']").attr('required', 'required');
            $("input[name='no_of_links']").attr('required', 'required');
            $("input[name='no_of_payments']").attr('required', 'required');
            $("input[name='no_of_galleries']").attr('required', 'required');
            $("input[name='business_hours']").attr('required', 'required');
            $("input[name='no_testimonials']").attr('required');
            $("input[name='contact_form']").attr('required', 'required');
            $("input[name='no_of_enquires']").attr('required', 'required');

            $("input[name='no_of_stores']").attr('required', 'required');
            $("input[name='no_of_categories']").attr('required', 'required');
            $("input[name='no_of_store_products']").attr('required', 'required');

            // Enable vcard
            $("#vcard-features").attr("class", "row");
            // Enable Store
            $("#store-features").attr("class", "row");
    }
}
</script>

<script>
    // Array of element selectors
    var elementSelectors = ['.plan_type', '.business_hours','.contact_form', '.pwa', '.custom_domain', '.advanced_settings', '.additional_tools', '.personalized_link', '.hide_branding', '.free_setup', '.free_support', '.recommended', '.is_private'];

    // Function to initialize TomSelect on an element
    function initializeTomSelect(el) {
        new TomSelect(el, {
            copyClassesToDropdown: false,
            dropdownClass: 'dropdown-menu ts-dropdown',
            optionClass: 'dropdown-item',
            controlInput: '<input>',
            maxOptions: null,
            render: {
                item: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
                option: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
            },
        });
    }

    // Initialize TomSelect on existing elements
    elementSelectors.forEach(function(selector) {
        var elements = document.querySelectorAll(selector);
        elements.forEach(function(el) {
            initializeTomSelect(el);
        });
    });

    // Observe the document for dynamically added elements
    var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            mutation.addedNodes.forEach(function(node) {
                if (node.nodeType === 1) { // Ensure it's an element node
                    elementSelectors.forEach(function(selector) {
                        if (node.matches(selector)) {
                            initializeTomSelect(node);
                        }
                        // Also check if new nodes have children that match
                        var childElements = node.querySelectorAll(selector);
                        childElements.forEach(function(childEl) {
                            initializeTomSelect(childEl);
                        });
                    });
                }
            });
        });
    });

    // Configure the observer
    observer.observe(document.body, { childList: true, subtree: true });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/plans/edit-plan.blade.php ENDPATH**/ ?>