

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Edit Page')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <form action="<?php echo e(route('admin.update.page', Request::segment(3))); ?>" method="post"
                        enctype="multipart/form-data" class="card">
                        <?php echo csrf_field(); ?>
                        <div class="card-body">
                            <div class="row">
                                <?php for($i = 0; $i < count($sections); $i++): ?> <div class="col-xl-6">
                                    <div id="section<?php echo e($i); ?>" class="row">
                                        <div class="col-md-12 col-xl-12">
                                            <div class="mb-3">
                                                <label class="form-label required text-capitalize"><?php echo e($sections[$i]->section_title == "desc" ? 'Description' :
                                                    str_replace('_', ' ', $sections[$i]->section_title)); ?></label>
                                                <textarea rows="6" cols="10" class="form-control" name="section<?php echo e($i); ?>"
                                                    placeholder="<?php echo e($sections[$i]->section_title); ?>"
                                                    required><?php echo e($sections[$i]->section_content); ?></textarea>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                            <?php endfor; ?>

                            
                            <?php if(Request::segment(3) != "footer"): ?>
                            <h2 class="mt-3 mb-3 page-title">
                                <?php echo e(__('SEO Configuration')); ?>

                            </h2>

                            
                            <div class="col-md-6 col-xl-6">
                                <div class="mb-3">
                                    <label class="form-label required"><?php echo e(__('Title')); ?></label>
                                    <textarea class="form-control" name="title" rows="3" placeholder="<?php echo e(__('Title')); ?>"
                                        required><?php echo e($sections[0]->title); ?></textarea>
                                </div>
                            </div>

                            
                            <div class="col-md-6 col-xl-6">
                                <div class="mb-3">
                                    <label class="form-label required"><?php echo e(__('Description')); ?></label>
                                    <textarea class="form-control" name="description" rows="3"
                                        placeholder="<?php echo e(__('Description')); ?>"
                                        required><?php echo e($sections[0]->description); ?></textarea>
                                </div>
                            </div>

                            
                            <div class="col-md-12 col-xl-12">
                                <div class="mb-3">
                                    <label class="form-label"><?php echo e(__('Keywords')); ?></label>
                                    <textarea class="form-control required" name="keywords" rows="3"
                                        placeholder="<?php echo e(__('Keywords (Keyword 1, Keyword 2)')); ?>"
                                        required><?php echo e($sections[0]->keywords); ?></textarea>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>

                        <div class="card-footer text-end">
                            <button type="submit" class="btn btn-primary btn-md ms-auto">
                                <?php echo e(__('Save')); ?>

                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/pages/edit.blade.php ENDPATH**/ ?>