

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="container-fluid">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title"> 
                        <?php echo e(__('Blogs')); ?>

                    </h2>
                </div>
                <!-- Add Blog -->
                <div class="col-auto ms-auto d-print-none">
                    <a type="button" href="<?php echo e(route('admin.create.blog')); ?>" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus" width="24"
                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                            stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <?php echo e(__('Create')); ?>

                    </a> 
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">

            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">

                        
                        <div class="table-responsive px-2 py-2">
                            <table class="table table-vcenter card-table" id="blogs-table">
                                <thead>
                                    <tr>
                                        <th width="5%"><?php echo e(__('#')); ?></th>
                                        <th width="12%"><?php echo e(__('Date')); ?></th>
                                        <th width="5%"><?php echo e(__('Category')); ?></th>
                                        <th width="10%"><?php echo e(__('Tags')); ?></th>
                                        <th width="20%"><?php echo e(__('Title')); ?></th>
                                        <th width="23%"><?php echo e(__('Short description')); ?></th>
                                        <th width="10%"><?php echo e(__('Status')); ?></th>
                                        <th width="15%" class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<div class="modal modal-blur fade" id="action-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div id="action_status"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="blogId"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#blogs-table').DataTable({
            processing: false, // Disable processing indicator
            serverSide: true,
            ajax: "<?php echo e(route('admin.blogs')); ?>",
            language: {
                loadingRecords: "Please wait - loading...",
                emptyTable: "No data available in the table" // Message for an empty table
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'created_at', name: 'created_at' },
                { data: 'blogCategory', name: 'blogCategory.blog_category_title' },
                { data: 'tags', name: 'tags', orderable: false, searchable: false },
                { data: 'heading', name: 'heading' },
                { data: 'short_description', name: 'short_description' },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            preDrawCallback: function(settings) {
                // Add placeholder-glow class to the table before rendering
                $('#blogs-table_wrapper').addClass('placeholder-glow');

                // Check if there are rows in the tbody after draw
                if ($('#blogs-table tbody tr').length === 0) {
                    // If there are no rows, add 10 placeholder rows with 8 columns each
                    var placeholderRows = '';
                    for (var i = 0; i < 10; i++) {
                        placeholderRows += '<tr>' + '<td class="text-center"><div class="placeholder placeholder-xs col-12"></div></td>'.repeat(8) + '</tr>';
                    }
                    $('#blogs-table tbody').html(placeholderRows);
                }
            },
            drawCallback: function(settings) {
                // Remove the placeholder-glow class once the table is fully rendered
                $('#blogs-table_wrapper').removeClass('placeholder-glow');

                // clear any existing placeholder rows
                $('#blogs-table tbody tr').each(function() {
                    var actionCell = $(this).find('td').eq(7); // Targeting the 7th column (index 7)
                    if (actionCell.find('span.placeholder').length > 0) {
                        actionCell.empty(); // Clear the placeholder once data is available
                    }
                });
            }
        });
    });
    
    function getBlog(blogId, blogStatus) {
        "use strict";

        $("#action-modal").modal("show");
        var delete_status = document.getElementById("action_status");
        delete_status.innerHTML = "<?php echo __('If you proceed, you will') ?> " + blogStatus + " <?php echo __('this blog.') ?>"
        var actionLink = document.getElementById("blogId");
        actionLink.getAttribute("href");
        actionLink.setAttribute("href", "<?php echo e(route('admin.action.blog')); ?>?id=" + blogId + "&mode=" + blogStatus);
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/blogs/index.blade.php ENDPATH**/ ?>