


<?php $__env->startSection('css'); ?>
<style>
    .ts-control>input {
        display: contents !important;
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center"> 
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Create User')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <form action="<?php echo e(route('admin.save.user')); ?>" method="post" class="card">
                        <?php echo csrf_field(); ?>
                        <div class="card-header">
                            <h4 class="page-title"><?php echo e(__('User Details')); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="row">
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <div class="form-label required"><?php echo e(__('Role')); ?></div>
                                                <select class="form-select role" name="role" required>
                                                    <option value=""><?php echo e(__('Choose a role')); ?></option>
                                                    <option value="3" selected><?php echo e(__('Administrator')); ?></option>
                                                    <option value="4"><?php echo e(__('Manager')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Name')); ?></label>
                                                <input type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>"
                                                    placeholder="<?php echo e(__('Name')); ?>" required>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Email')); ?></label>
                                                <input type="email" class="form-control" name="email"
                                                    placeholder="<?php echo e(__('Email')); ?>" value="<?php echo e(old('email')); ?>" required>

                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-3">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Password')); ?></label>
                                                <input type="password" class="form-control" name="password" value="<?php echo e(old('password')); ?>" placeholder="<?php echo e(__('Password')); ?>" required>
                                            </div>
                                        </div>
                                        
                                        
                                        <h2 class="page-title my-3">
                                            <?php echo e(__('Permissions')); ?>

                                        </h2>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label">
                                                    <?php echo e(__('Themes')); ?> 
                                                </div>
                                                <select class="form-select themes" name="themes">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Plans')); ?></div>
                                                <select class="form-select plans" name="plans">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Customers')); ?></div>
                                                <select class="form-select customers" name="customers">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Payment Methods')); ?></div>
                                                <select class="form-select payment_methods" name="payment_methods">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Coupons')); ?></div>
                                                <select class="form-select coupons" name="coupons">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Transactions')); ?></div>
                                                <select class="form-select transactions" name="transactions">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Pages')); ?></div>
                                                <select class="form-select pages" name="pages">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Blogs')); ?></div>
                                                <select class="form-select blogs" name="blogs">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Users')); ?></div>
                                                <select class="form-select users" name="users">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Custom Domains')); ?></div>
                                                <select class="form-select custom_domain" name="custom_domain">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('General Settings')); ?></div>
                                                <select class="form-select general_settings" name="general_settings">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Translations')); ?></div>
                                                <select class="form-select translations" name="translations">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Generate Sitemap')); ?></div>
                                                <select class="form-select sitemap" name="sitemap">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Invoice & Tax')); ?></div>
                                                <select class="form-select invoice_tax" name="invoice_tax">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        
                                        <div class="col-md-6 col-xl-2">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Software Update')); ?></div>
                                                <select class="form-select software_update" name="software_update">
                                                    <option value="on"><?php echo e(__('Yes')); ?></option>
                                                    <option value="off"><?php echo e(__('No')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
<script>
    // Array of element selectors
    var elementSelectors = ['.role'];

    // Function to initialize TomSelect on an element
    function initializeTomSelect(el) {
        new TomSelect(el, {
            copyClassesToDropdown: false,
            dropdownClass: 'dropdown-menu ts-dropdown',
            optionClass: 'dropdown-item',
            controlInput: '<input>',
            maxOptions: null,
            render: {
                item: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
                option: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
            },
        });
    }

    // Initialize TomSelect on existing elements
    elementSelectors.forEach(function(selector) {
        var elements = document.querySelectorAll(selector);
        elements.forEach(function(el) {
            initializeTomSelect(el);
        });
    });

    // Observe the document for dynamically added elements
    var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            mutation.addedNodes.forEach(function(node) {
                if (node.nodeType === 1) { // Ensure it's an element node
                    elementSelectors.forEach(function(selector) {
                        if (node.matches(selector)) {
                            initializeTomSelect(node);
                        }
                        // Also check if new nodes have children that match
                        var childElements = node.querySelectorAll(selector);
                        childElements.forEach(function(childEl) {
                            initializeTomSelect(childEl);
                        });
                    });
                }
            });
        });
    });

    // Configure the observer
    observer.observe(document.body, { childList: true, subtree: true });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/users/create.blade.php ENDPATH**/ ?>