<?php
    use Illuminate\Support\Facades\DB;

    $config = DB::table('config')->get();
?>

<?php if($paginator->hasPages()): ?>
    <div class="w-full py-8">
        <nav>
            <ul class="inline-flex">
                <!-- Previous Button -->
                <?php if($paginator->onFirstPage()): ?>
                    <li>
                        <a
                            class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700 rounded-l">
                            <?php echo e(__('Previous')); ?>

                        </a>
                    </li>
                <?php else: ?>
                    <li>
                        <a href="<?php echo e($paginator->previousPageUrl()); ?>" rel="prev"
                            class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700 rounded-l"><?php echo e(__('Previous')); ?></a>
                    </li>
                <?php endif; ?>

                <!-- Page Numbers -->
                <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(is_string($element)): ?>
                        <li class="disabled">
                            <?php echo e($element); ?>

                        </li>
                    <?php endif; ?>
                    <?php if(is_array($element)): ?>
                        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page == $paginator->currentPage()): ?>
                                <li>
                                    <a href="#"
                                        class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700 active my-active"><?php echo e($page); ?></a>
                                </li>
                            <?php else: ?>
                                <li>
                                    <a href="<?php echo e($url); ?>"
                                        class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700"><?php echo e($page); ?></a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <!-- Next Button -->
                <?php if($paginator->hasMorePages()): ?>
                    <li>
                        <a href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next"
                            class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700 rounded-r"><?php echo e(__('Next')); ?></a>
                    </li>
                <?php else: ?>
                    <li>
                        <a
                            class="px-3 py-2 bg-<?php echo e($config[11]->config_value); ?>-200 text-<?php echo e($config[11]->config_value); ?>-700 rounded-r">
                            <?php echo e(__('Next')); ?>

                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
<?php endif; ?>
<?php /**PATH /home/betvscaa/public_html/resources/views/vendor/pagination/blog.blade.php ENDPATH**/ ?>