


<?php $__env->startSection('custom-script'); ?>
<?php if($settings->google_adsense_code != 'DISABLE_ADSENSE_ONLY'): ?>

<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>" crossorigin="anonymous"></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div>
    <section class="text-gray-700">
        <div class="container px-5 py-24 mx-auto">
            
            <div class="mb-2">
                <h1 class="text-3xl font-bold font-large title-font text-gray-900 mb-4">
                    <?php echo e(__('IP Address Lookup')); ?>

                </h1>
            </div>

            
            <form action="<?php echo e(route('web.result.ip.lookup')); ?>" method="post">
                <?php echo csrf_field(); ?>

                
                <div class='mb-3 space-y-2 w-full'>
                    <label class='font-bold text-gray-600 py-2'><?php echo e(__('IP Address')); ?> <abbr title='required'>*</abbr></label>
                    <input placeholder='<?php echo e($result['traits']['ip_address'] ?? (old('ip') ?? request()->ip())); ?>' class='appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter rounded-lg h-10 px-4' required='required' type='text' name='ip' id='ip'>
                </div>

                <button type="submit" class="group relative font-heading px-10 py-5 mb-8 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-md"><?php echo e(__('Search')); ?></button>
            </form>

            
            <?php if(!empty($results)): ?>
            <div class='flex flex-wrap lg:w-full sm:mx-auto sm:mb-2 lg:mt-12'>  
                <div class="rounded-xl border p-5 shadow-md w-full bg-white">
                    <div class="flex w-full items-center justify-between border-b pb-3">
                        <div class="flex items-center space-x-3">
                            <div class="text-lg font-bold text-slate-700"><?php echo e(__('Result')); ?></div>
                        </div>
                        <div class="flex items-center space-x-8">
                            <button class="rounded-2xl border bg-neutral-100 px-3 py-1 font-semibold"><?php echo e(__('IP')); ?></button>
                        </div>
                    </div>
                
                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Country Name')); ?></div>
                        <div class="text-lg text-neutral-600"><img width="20" height="20" src="<?php echo e(asset('/images/icons/countries/'. mb_strtolower($results['country']['iso_code'] ?? 'not-found'))); ?>.svg" alt="<?php echo e(__($results['country']['names']['en'] ?? 'Not found')); ?>"><?php echo e(__($results['country']['names']['en'] ?? 'Not found')); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('City Name')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results['city']['names']['en'] ?? 'Not found')); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Postal code')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results['postal']['code'] ?? 'Not found')); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Latitude')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results['location']['latitude'] ?? 'Not found')); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Longtitude')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results['location']['longitude'] ?? 'Not found')); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Timezone')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results['location']['time_zone'] ?? 'Not found')); ?></div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', ['nav' => true, 'banner' => false, 'footer' => true, 'cookie' => true, 'setting' => true,
'title' => __('IP Address Lookup - Web Tools')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/website/pages/web-tools/ip.blade.php ENDPATH**/ ?>