

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Appointment')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">
                
                <?php if(Session::has('failed')): ?>
                    <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                <?php echo e(Session::get('failed')); ?>

                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                <?php endif; ?>

                
                <?php if(Session::has('success')): ?>
                    <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                        <div class="d-flex">
                            <div>
                                <?php echo e(Session::get('success')); ?>

                            </div>
                        </div>
                        <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                    </div>
                <?php endif; ?>

                <div class="row row-deck row-cards">
                    <div class="col-sm-12 col-lg-12">
                        <form action="<?php echo e(route('user.save.appointment', Request::segment(3))); ?>" method="post"
                            class="card">
                            <?php echo csrf_field(); ?>
                            <div class="card">
                                <div class="card-body">
                                    <h4 class="card-title"><?php echo e(__('Set Appointment Timings')); ?></h4>
                                    
                                    <div class="mb-3">
                                        <label class="form-label"><?php echo e(__('Slot duration')); ?></label>
                                        <div class="input-group mb-2">
                                            <input type="number" name="slot_duration" id="slot_duration" class="form-control" placeholder="<?php echo e(__('Slot duration in minutes. Example: 30')); ?>" min="10" step="5" max="60" value="30">
                                            <span class="input-group-text">
                                              <?php echo e(__('minutes')); ?>

                                            </span>
                                        </div>
                                        <small><?php echo e(__('Max duration is 60 minutes.')); ?></small>
                                    </div>

                                    
                                    <div class="mb-3">
                                        <h3><?php echo e(__('Days of the week')); ?></h3>
                                    </div>
                                    <?php $__currentLoopData = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="mb-3">
                                            <div class="form-label"><?php echo e(__($day)); ?></div>
                                            <div class="input-group mb-2">
                                                
                                                <select name="time_slots[<?php echo e($day); ?>][]" class="form-select time-select" multiple>
                                                    <option value="" disabled selected><?php echo e(__('Choose your time slots (multiple)')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    
                                    <div class="mb-3">
                                        <h3><?php echo e(__('Price')); ?></h3>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label required"><?php echo e(__('Fee')); ?></label>
                                        <div class="input-group mb-2">
                                            <input type="number" name="price" id="price" class="form-control" placeholder="<?php echo e(__('Price')); ?>" value="0" min="0" step=".001" required>
                                            <span class="input-group-text">
                                              <?php echo e(__('per slot')); ?>

                                            </span>
                                        </div>
                                        <small><?php echo e(__('Set the price 0 for free')); ?></small>
                                    </div>
                                </div>
                                
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        
                                        <?php if($business_card->type != 'personal'): ?>
                                            <a href="<?php echo e(route('user.contact.form', Request::segment(3))); ?>"
                                                class="btn btn-primary">
                                                <?php echo e(__('Skip')); ?>

                                            </a>
                                        <?php endif; ?>
                                        
                                        <button type="submit" class="btn btn-primary btn-sm"><?php echo e(__('Save Slots')); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('custom-js'); ?>
    <!-- Tomselect JS -->
    <script src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>

    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const slotDurationInput = document.getElementById('slot_duration');
            const timeSelects = document.querySelectorAll('.time-select');
    
            // Initialize TomSelect for each select element and store instances
            const tomSelectInstances = Array.from(timeSelects).map(select => {
                return new TomSelect(select, {
                    copyClassesToDropdown: false,
                    dropdownParent: 'body',
                    controlInput: '<input>',
                    maxOptions: null,
                });
            });
    
            function generateTimeSlots(duration) {
                // Check if the duration is valid
                if (isNaN(duration) || duration <= 0) {
                    return;
                }
    
                tomSelectInstances.forEach(tomSelectInstance => {
                    // Clear existing options
                    tomSelectInstance.clearOptions();
    
                    // Generate new time slots based on the duration
                    for (let i = 0; i < 24 * 60; i += duration) {
                        const start = String(Math.floor(i / 60)).padStart(2, '0') + ':' + String(i % 60).padStart(2, '0');
                        const endMinutes = i + duration;
                        
                        // Stop if end time goes beyond 24:00 (1440 minutes)
                        if (endMinutes > 24 * 60) {
                            break; // Stops adding more options once we exceed 24:00
                        }
                        
                        const end = String(Math.floor(endMinutes / 60)).padStart(2, '0') + ':' + String(endMinutes % 60).padStart(2, '0');

                        tomSelectInstance.addOption({
                            value: `${start} - ${end}`,
                            text: `${start} - ${end}`,
                        });
                    }
    
                    // Refresh the dropdown to display the new options
                    tomSelectInstance.refreshOptions(false);
                });
            }
    
            // Generate initial time slots with the default value.
            generateTimeSlots(Math.min(parseInt(slotDurationInput.value), 60));
    
            // Update time slots whenever the slot duration changes.
            slotDurationInput.addEventListener('change', function() {
                let duration = parseInt(this.value);
                duration = Math.min(duration, 60); // Ensure the duration does not exceed 60 minutes.
                generateTimeSlots(duration);
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php $__env->startSection('css'); ?>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/cards/appointment.blade.php ENDPATH**/ ?>