

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/all.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap-iconpicker.min.css')); ?>" />
    <style>
        .ts-control>input {
            display: contents !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="page-body">
            <div class="container-fluid">
                
                <?php if(Session::has("failed")): ?>
                <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('failed')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                
                <?php if(Session::has("success")): ?>
                <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>
            
                <div class="card">
                    <div class="row g-0">
                        <div class="col-12 col-md-3 border-end">
                            <div class="card-body">
                                <h4 class="subheader"><?php echo e(__('Update Business Card')); ?></h4>
                                <div class="list-group list-group-transparent">
                                    
                                    <?php echo $__env->make('user.pages.edit-cards.includes.nav-link', ['link' => 'links'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-9 d-flex flex-column">
                            <form action="<?php echo e(route('user.update.social.links', Request::segment(3))); ?>" method="post"
                                id="myForm">
                                <?php echo csrf_field(); ?>
                                <div class="card-body">
                                    <h3 class="card-title mb-4"><?php echo e(__('Social Links')); ?></h3>

                                    <div>
                                        
                                        <?php for($i = 0; $i < count($features); $i++): ?>
                                            <div class="row" id="<?php echo e($i); ?>">
                                                <div class='col-lg-2 col-md-2'>
                                                    <div class='mb-3 mt-2'>
                                                        <label class='form-label required'
                                                            for='type'><?php echo e(__('Display type')); ?></label>
                                                        <select class="type<?php echo e($features[$i]->id); ?> defaultType form-select"
                                                            id="type<?php echo e($features[$i]->id); ?>" name="type[]"
                                                            onchange='changeLabel(<?php echo e($features[$i]->id); ?>)' required>
                                                            <optgroup label="<?php echo e(__('Social Links')); ?>">
                                                                <option value='facebook'
                                                                    <?php echo e($features[$i]->type == 'facebook' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Facebook')); ?></option>
                                                                <option value='instagram' <?php echo e($features[$i]->type == 'instagram' ? 'selected' : ''); ?>><?php echo e(__('Instagram')); ?></option>
                                                                <option value='x-twitter'
                                                                    <?php echo e($features[$i]->type == 'x-twitter' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Twitter')); ?></option>
                                                                <option value='linkedin'
                                                                    <?php echo e($features[$i]->type == 'linkedin' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('LinkedIn')); ?></option>
                                                                <option value='pinterest'
                                                                    <?php echo e($features[$i]->type == 'pinterest' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Pinterest')); ?></option>
                                                                <option value='reddit'
                                                                    <?php echo e($features[$i]->type == 'reddit' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Reddit')); ?></option>
                                                                <option value='tiktok'
                                                                    <?php echo e($features[$i]->type == 'tiktok' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Tiktok')); ?></option>
                                                                <option value='threads'
                                                                    <?php echo e($features[$i]->type == 'threads' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Threads')); ?></option>
                                                                <option value='snapchat'
                                                                    <?php echo e($features[$i]->type == 'snapchat' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Snapchat')); ?></option>
                                                                <option value='wechat'
                                                                    <?php echo e($features[$i]->type == 'wechat' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('WeChat')); ?></option>
                                                                <option value='telegram'
                                                                    <?php echo e($features[$i]->type == 'telegram' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Telegram')); ?></option>
                                                                <option value='tumblr'
                                                                    <?php echo e($features[$i]->type == 'tumblr' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Tumblr')); ?></option>
                                                                <option value='qq'
                                                                    <?php echo e($features[$i]->type == 'qq' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('QQ')); ?></option>
                                                                <option value='discord'
                                                                    <?php echo e($features[$i]->type == 'discord' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Discord')); ?></option>
                                                                <option value='quora'
                                                                    <?php echo e($features[$i]->type == 'quora' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Quora')); ?></option>
                                                                <option value='wa'
                                                                    <?php echo e($features[$i]->type == 'wa' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('WhatsApp')); ?></option>
                                                                <option value='address'
                                                                    <?php echo e($features[$i]->type == 'address' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Address')); ?></option>
                                                                <option value='email'
                                                                    <?php echo e($features[$i]->type == 'email' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Email')); ?></option>
                                                                <option value='tel'
                                                                    <?php echo e($features[$i]->type == 'tel' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Phone')); ?></option>
                                                                <option value='url'
                                                                    <?php echo e($features[$i]->type == 'url' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Link')); ?></option>
                                                                <option value='text'
                                                                    <?php echo e($features[$i]->type == 'text' || $features[$i]->type == 'textarea' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Custom Text')); ?></option>
                                                            </optgroup>
                                                            <optgroup label="<?php echo e(__('Sections')); ?>">
                                                                <option value='map'
                                                                    <?php echo e($features[$i]->type == 'map' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Google Map')); ?></option>
                                                                <option value='youtube'
                                                                    <?php echo e($features[$i]->type == 'youtube' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('Youtube')); ?></option>
                                                                <option value='iframe'
                                                                    <?php echo e($features[$i]->type == 'iframe' ? 'selected' : ''); ?>>
                                                                    <?php echo e(__('iframe')); ?></option>
                                                            </optgroup>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class='col-lg-1 col-md-1'>
                                                    <div class='mb-3 mt-2'>
                                                        <label class='form-label required'><?php echo e(__('Icon')); ?></label>
                                                        <button type="button" id='iconpick<?php echo e($features[$i]->id); ?>'
                                                            onclick='openPicker(<?php echo e($features[$i]->id); ?>)'
                                                            class="btn btn-primary btn-icon text-white btn-md"><i
                                                                id="displayIcon<?php echo e($features[$i]->id); ?>"
                                                                class="<?php echo e($features[$i]->icon); ?>"></i></button>
                                                        <input type='hidden'
                                                            class='icon<?php echo e($features[$i]->id); ?> form-control'
                                                            value="<?php echo e($features[$i]->icon); ?>"
                                                            placeholder='<?php echo e(__('Choose Icon')); ?>' name='icon[]' required
                                                            readonly>
                                                    </div>
                                                </div>
                                                <div class='col-lg-3 col-md-3'>
                                                    <div class='mb-3 mt-2'>
                                                        <label class='form-label required'><?php echo e(__('Label')); ?></label>
                                                        <input type='text'
                                                            class='lbl<?php echo e($features[$i]->id); ?> form-control' name='label[]'
                                                            placeholder='<?php echo e(__(' Label')); ?>'
                                                            value="<?php echo e($features[$i]->label); ?>" required>
                                                    </div>
                                                </div>
                                                <div class='col-lg-4 col-md-4'>
                                                    <div class='mb-3 mt-2'>
                                                        <label class='form-label required'><?php echo e(__('Content')); ?></label>
                                                        <input type="<?php echo e($features[$i]->type == 'iframe' ? 'url' : 'text'); ?>"
                                                            class='textlbl<?php echo e($features[$i]->id); ?> form-control'
                                                            name='value[]' placeholder='<?php echo e(__(' Content')); ?>'
                                                            value="<?php echo e($features[$i]->content); ?>" required>
                                                    </div>
                                                </div>
                                                <div class='col-lg-2 col-md-2'>
                                                    <div class='mb-3 pt-1 mt-5'>
                                                        <button type="button" class='btn btn-danger btn-sm'
                                                            onclick='removeFeature(<?php echo e($i); ?>)'>
                                                            <i class='fa fa-times text-white'></i>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endfor; ?>

                                        
                                        <div id="more-features"></div>

                                        
                                        <div class="col-lg-12 mb-5">
                                            <button type="button" onclick="addFeature()" class="btn btn-primary">
                                                <?php echo e(__('Add One More Features')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent mt-auto">
                                    <div class="btn-list justify-content-end">
                                        <a href="<?php echo e(route('user.cards')); ?>" class="btn">
                                            <?php echo e(__('Cancel')); ?>

                                        </a>
                                        <button type="submit" class="btn btn-primary">
                                            <?php echo e(__('Submit')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <?php $__env->startPush('custom-js'); ?>
        <script type="text/javascript" src="<?php echo e(asset('js/fontawesome-iconpicker.min.js')); ?>"></script>
        <script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
        <script>
            var count = <?php echo e(count($features)); ?>;

            function addFeature() {
                "use strict";
                if (count >= <?php echo e($plan_details->no_of_links); ?>) {
                    new swal({
                        title: `<?php echo e(__('Oops!')); ?>`,
                        icon: 'warning',
                        text: `<?php echo e(__('You have reached your current plan limit.')); ?>`,
                        timer: 2000,
                        buttons: false,
                        showConfirmButton: false,
                    });
                } else {
                    count++;
                    var id = getRandomInt();
                    var features = `<div class='row' id=` + id + `>
                                <div class='col-lg-2 col-md-2'>
                                    <div class='mb-3 mt-2'>
                                        <label class='form-label required' for='type'><?php echo e(__('Display type')); ?></label>
                                        <select class="type` + id + ` form-select" id="type` + id +`" name="type[]" onchange='changeLabel(` + id + `)' required>
                                            <optgroup label="<?php echo e(__('Social Links')); ?>">
                                                <option value='facebook'><?php echo e(__('Facebook')); ?></option>
                                                <option value='instagram'><?php echo e(__('Instagram')); ?></option>
                                                <option value='x-twitter'><?php echo e(__('Twitter')); ?></option>
                                                <option value='linkedin'><?php echo e(__('LinkedIn')); ?></option>
                                                <option value='pinterest'><?php echo e(__('Pinterest')); ?></option>
                                                <option value='reddit'><?php echo e(__('Reddit')); ?></option>
                                                <option value='tiktok'><?php echo e(__('Tiktok')); ?></option>
                                                <option value='threads'><?php echo e(__('Threads')); ?></option>
                                                <option value='snapchat'><?php echo e(__('Snapchat')); ?></option>
                                                <option value='wechat'><?php echo e(__('WeChat')); ?></option>
                                                <option value='telegram'><?php echo e(__('Telegram')); ?></option>
                                                <option value='tumblr'><?php echo e(__('Tumblr')); ?></option>
                                                <option value='qq'><?php echo e(__('QQ')); ?></option>
                                                <option value='discord'><?php echo e(__('Discord')); ?></option>
                                                <option value='quora'><?php echo e(__('Quora')); ?></option>
                                                <option value='wa'><?php echo e(__('WhatsApp')); ?></option>
                                                <option value='address'><?php echo e(__('Address')); ?></option>
                                                <option value='email'><?php echo e(__('Email')); ?></option>
                                                <option value='tel'><?php echo e(__('Phone')); ?></option>
                                                <option value='url'><?php echo e(__('Link')); ?></option>
                                                <option value='text'><?php echo e(__('Custom Text')); ?></option>
                                            </optgroup>
                                            <optgroup label="<?php echo e(__('Sections')); ?>">
                                                <option value='map'><?php echo e(__('Google Map')); ?></option>
                                                <option value='youtube'><?php echo e(__('Youtube')); ?></option>
                                                <option value='iframe'><?php echo e(__('iframe')); ?></option>
                                            </optgroup>
                                        </select>
                                    </div>
                                </div>

                                <div class='col-lg-1 col-md-1'>
                                    <div class='mb-3 mt-2'>
                                        <label class='form-label required'><?php echo e(__('Icon')); ?></label>
                                        <button type="button" id='iconpick` + id + `' onclick='openPicker(` + id +`)' class="btn btn-primary btn-icon text-white btn-md"><i id="displayIcon` + id + `" class="fab fa-facebook"></i></button>
                                        <input type='hidden' class='icon` + id + ` form-control' placeholder='<?php echo e(__('Choose Icon')); ?>' value="fab fa-facebook-f" name='icon[]' required readonly>
                                    </div>
                                </div>

                                <div class='col-lg-3 col-md-3'>
                                    <div class='mb-3 mt-2'>
                                        <label class='form-label required'><?php echo e(__('Label / Title')); ?></label>
                                        <input type='text' class='lbl` + id + ` form-control' name='label[]' placeholder='<?php echo e(__('Label')); ?>' required>
                                    </div>
                                </div>

                                <div class='col-lg-4 col-md-4'>
                                    <div class='mb-3 mt-2'>
                                        <label class='form-label required'><?php echo e(__('Content')); ?></label>
                                        <input type='text' class='textlbl` + id +` form-control' name='value[]' placeholder='<?php echo e(__('Type something')); ?>' required>
                                    </div>
                                </div>

                                <div class='col-lg-2 col-md-2'>
                                    <div class='my-3 py-4'>
                                        <button type="button" class='btn btn-danger btn-icon' onclick='removeFeature(` + id + `)'>
                                            <i class='fa fa-times text-white'></i>
                                        </button>
                                    </div>
                                </div>
                            </div>`;
                    $("#more-features").append(features).html();

                    dynamicSelect('type' + id);
                }
            }

            function removeFeature(id) {
                "use strict";
                $("#" + id).remove();
                count--;
            }

            function getRandomInt() {
                min = Math.ceil(0);
                max = Math.floor(9999999999);
                return Math.floor(Math.random() * (max - min) + min); //The maximum is exclusive and the minimum is inclusive
            }

            function openPicker(id) {
                "use strict";
                $("#iconpick" + id).iconpicker({
                    animation: true,
                    hideOnSelect: true,
                    input: "#iconpick" + id + ", .icon" + id + "",
                    placement: "inline",
                    templates: {
                        popover: '<div class="iconpicker-popover popover position-absolute"><div class="arrow"></div>' +
                            '<div class="popover-title"></div><div class="popover-content"></div></div>',
                        iconpickerItem: '<a role="button" class="iconpicker-item"><i></i></a>'
                    }
                });

                $("#iconpick" + id).on('iconpickerSelected', function(event) {
                    $("#displayIcon" + id).attr("class", event.iconpickerValue);
                });
            }





            function changeLabel(id) {
                "use strict";
                var label = `<?php echo e(__('Label')); ?>`;
                var textlabel = `<?php echo e(__('Type something')); ?>`;
                let icon = document.querySelector('.icon' + id);
                let lbl = document.querySelector('.lbl' + id);
                let textlbl = document.querySelector('.textlbl' + id);
                let type = document.querySelector('.type' + id).value;

                if (type == 'address') {
                    label = `<?php echo e(__('Address')); ?>`;
                    textlabel = `<?php echo e(__('For ex: Chennai, Tamilnadu, India')); ?>`;

                    icon.value = "fas fa-home";
                    lbl.value = `<?php echo e(__('Address')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-home");
                    textlbl.type = 'text';

                } else if (type == 'text') {
                    label = `<?php echo e(__('About us')); ?>`;
                    textlabel = `<?php echo e(__('For ex: Lorem Ipsum is simply dummy text of')); ?>`;

                    icon.value = "fas fa-info-circle";
                    lbl.value = `<?php echo e(__('Content')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-info-circle");
                    textlbl.type = 'text';

                } else if (type == 'email') {
                    label = `<?php echo e(__('Email Address')); ?>`;
                    textlabel = `<?php echo e(__('For ex: support@website.com')); ?>`;

                    icon.value = "fas fa-at";
                    lbl.value = `<?php echo e(__('Email')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-at");
                    textlbl.type = 'email';

                } else if (type == 'tel') {
                    label = `<?php echo e(__('Phone Number')); ?>`;
                    textlabel = `<?php echo e(__('For ex: +919876543210')); ?>`;

                    icon.value = "fas fa-phone";
                    lbl.value = `<?php echo e(__('Phone')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-phone");
                    textlbl.type = 'number';

                } else if (type == 'wa') {
                    label = `<?php echo e(__('WhatsApp')); ?>`;
                    textlabel = `<?php echo e(__('For ex: 919876543210')); ?>`;

                    icon.value = "fab fa-whatsapp";
                    lbl.value = `<?php echo e(__('WhatsApp')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-whatsapp");
                    textlbl.type = 'number';

                } else if (type == 'url') {
                    label = `<?php echo e(__('Website')); ?>`;
                    textlabel = `<?php echo e(__('For ex: website.com')); ?>`;

                    icon.value = "fas fa-link";
                    lbl.value = `<?php echo e(__('Website')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-link");
                    textlbl.type = 'url';

                } else if (type == 'youtube') {
                    label = `<?php echo e(__('Video Title')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://www.youtube.com/watch?v=li5ths352')); ?>`;

                    icon.value = "fab fa-youtube";
                    lbl.value = `<?php echo e(__('Youtube')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-youtube");
                    textlbl.type = 'url';

                } else if (type == 'map') {
                    label = `<?php echo e(__('California')); ?>`;
                    textlabel =
                        `<?php echo e(__("For ex: <iframe src='https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d3924.7798234706065!2d77.98194106479716!3d10.359482142605264!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3b00ab9baf4b4101%3A0x9d6d57a812be5cc6!2sCapsimint%20Technologies%20-%20Web%2C%20Mobile%20App%20and%20Software%20Development%20Company!5e0!3m2!1sen!2sin!4v1638283593135!5m2!1sen!2sin'></iframe>")); ?>`;

                    icon.value = "fas fa-location-arrow";
                    lbl.value = `<?php echo e(__('Location')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-location-arrow");
                    textlbl.type = 'text';

                } else if (type == 'facebook') {
                    label = `<?php echo e(__('Facebook')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://facebook.com')); ?>`;

                    icon.value = "fab fa-facebook-f";
                    lbl.value = `<?php echo e(__('Facebook')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-facebook-f");
                    textlbl.type = 'url';

                } else if (type == 'instagram') {
                    label = `<?php echo e(__('Instagram')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://instagram.com')); ?>`;

                    icon.value = "fab fa-instagram";
                    lbl.value = `<?php echo e(__('Instagram')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-instagram");
                    textlbl.type = 'url';

                } else if (type == 'x-twitter') {
                    label = `<?php echo e(__('Twitter')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://twitter.com')); ?>`;

                    icon.value = "fab fa-x-twitter";
                    lbl.value = `<?php echo e(__('Twitter')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-x-twitter");
                    textlbl.type = 'url';

                } else if (type == 'linkedin') {
                    label = `<?php echo e(__('LinkedIn')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://linkedin.com')); ?>`;

                    icon.value = "fab fa-linkedin-in";
                    lbl.value = `<?php echo e(__('LinkedIn')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-linkedin-in");
                    textlbl.type = 'url';

                } else if (type == 'pinterest') {
                    label = `<?php echo e(__('Pinterest')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://pinterest.com')); ?>`;

                    icon.value = "fab fa-pinterest";
                    lbl.value = `<?php echo e(__('Pinterest')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-pinterest");
                    textlbl.type = 'url';

                } else if (type == 'reddit') {
                    label = `<?php echo e(__('Reddit')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://reddit.com')); ?>`;

                    icon.value = "fab fa-reddit";
                    lbl.value = `<?php echo e(__('Reddit')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-reddit");
                    textlbl.type = 'url';

                } else if (type == 'tiktok') {
                    label = `<?php echo e(__('Tiktok')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://tiktok.com')); ?>`;

                    icon.value = "fab fa-tiktok";
                    lbl.value = `<?php echo e(__('Tiktok')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-tiktok");
                    textlbl.type = 'url';

                } else if (type == 'threads') {
                    label = `<?php echo e(__('Threads')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://threads.net')); ?>`;

                    icon.value = "fab fa-threads";
                    lbl.value = `<?php echo e(__('Threads')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-threads");
                    textlbl.type = 'url';

                } else if (type == 'snapchat') {
                    label = `<?php echo e(__('Snapchat')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://snapchat.com')); ?>`;

                    icon.value = "fab fa-snapchat";
                    lbl.value = `<?php echo e(__('Snapchat')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-snapchat");
                    textlbl.type = 'url';

                } else if (type == 'wechat') {
                    label = `<?php echo e(__('WeChat')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://wechat.com')); ?>`;

                    icon.value = "fab fa-weixin";
                    lbl.value = `<?php echo e(__('WeChat')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-weixin");
                    textlbl.type = 'url';

                } else if (type == 'telegram') {
                    label = `<?php echo e(__('Telegram')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://telegram.org')); ?>`;

                    icon.value = "fab fa-telegram";
                    lbl.value = `<?php echo e(__('Telegram')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-telegram");
                    textlbl.type = 'url';

                } else if (type == 'tumblr') {
                    label = `<?php echo e(__('Tumblr')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://tumblr.com')); ?>`;

                    icon.value = "fab fa-tumblr";
                    lbl.value = `<?php echo e(__('Tumblr')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-tumblr");
                    textlbl.type = 'url';

                } else if (type == 'qq') {
                    label = `<?php echo e(__('QQ')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://qq.com')); ?>`;

                    icon.value = "fab fa-qq";
                    lbl.value = `<?php echo e(__('QQ')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-qq");
                    textlbl.type = 'url';

                } else if (type == 'discord') {
                    label = `<?php echo e(__('Discord')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://discord.com')); ?>`;

                    icon.value = "fab fa-discord";
                    lbl.value = `<?php echo e(__('Discord')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-discord");
                    textlbl.type = 'url';

                } else if (type == 'quora') {
                    label = `<?php echo e(__('Quora')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://quora.com')); ?>`;

                    icon.value = "fab fa-quora";
                    lbl.value = `<?php echo e(__('Quora')); ?>`;
                    $("#displayIcon" + id).attr("class", "fab fa-quora");
                    textlbl.type = 'url';

                } else if (type == 'iframe') {
                    label = `<?php echo e(__('src Link')); ?>`;
                    textlabel = `<?php echo e(__('For ex: https://domain.com?feed=152856')); ?>`;

                    icon.value = "fas fa-rss";
                    lbl.value = `<?php echo e(__('iframe')); ?>`;
                    $("#displayIcon" + id).attr("class", "fas fa-rss");
                    textlbl.type = 'url';
                }

                lbl.placeholder = label;
                textlbl.placeholder = textlabel;
            }

            document.getElementById("myForm").onkeypress = function(e) {
                var key = e.charCode || e.keyCode || 0;
                if (key == 13) {
                    e.preventDefault();
                }
            }

            // Call the function on all elements with the class 'form-select' when the page loads
            $(document).ready(function() {
                // Select all elements with the class 'form-select'
                $('.defaultType').each(function() {
                    // Assuming you want to call the function 'yourFunction' on each element
                    var id = $(this).attr('id');
                    dynamicSelect(id);
                });
            });

            function dynamicSelect(id) {
                "use strict";
                var el;
                window.TomSelect && (new TomSelect(el = document.getElementById(id), {
                    copyClassesToDropdown: false,
                    dropdownClass: 'dropdown-menu ts-dropdown',
                    optionClass: 'dropdown-item',
                    controlInput: '<input>',
                    maxOptions: null,
                    render: {
                        item: function(data, escape) {
                            if (data.customProperties) {
                                return '<div><span class="dropdown-item-indicator">' + data.customProperties +
                                    '</span>' + escape(data.text) + '</div>';
                            }
                            return '<div>' + escape(data.text) + '</div>';
                        },
                        option: function(data, escape) {
                            if (data.customProperties) {
                                return '<div><span class="dropdown-item-indicator">' + data.customProperties +
                                    '</span>' + escape(data.text) + '</div>';
                            }
                            return '<div>' + escape(data.text) + '</div>';
                        },
                    },
                }));
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/edit-social-links.blade.php ENDPATH**/ ?>