

<?php $__env->startSection('body'); ?>

<?php if(count($languages)): ?>
<div class="page-wrapper">
    <div class="container-xl">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="row align-items-center">
                <?php echo $__env->make('translation::notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('translation::translation.languages')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">

                    <div class="btn-list">
                        <span class="d-none d-sm-inline">
                            <a href="<?php echo e(route('languages.index')); ?>" class="btn">
                                <?php echo e(__('translation::translation.languages')); ?>

                            </a>
                        </span>
                        <a href="<?php echo e(route('languages.create')); ?>" class="btn btn-primary d-none d-sm-inline-block">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M12 5l0 14"></path>
                                <path d="M5 12l14 0"></path>
                            </svg>
                            <?php echo e(__('Add')); ?>

                        </a>
                        <a href="<?php echo e(route('languages.translations.index', config('app.locale'))); ?>"
                            class="btn btn-primary d-none d-sm-inline-block">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-language"
                                width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                <path d="M4 5h7"></path>
                                <path d="M9 3v2c0 4.418 -2.239 8 -5 8"></path>
                                <path d="M5 9c0 2.144 2.952 3.908 6.7 4"></path>
                                <path d="M12 20l4 -9l4 9"></path>
                                <path d="M19.1 18h-6.2"></path>
                            </svg>
                            <?php echo e(__('translation::translation.translations')); ?>

                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table card-table table-vcenter text-nowrap datatable" id="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('translation::translation.language_name')); ?></th>
                                        <th><?php echo e(__('translation::translation.locale')); ?></th>
                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <?php echo e($name); ?>

                                        </td>
                                        <td>
                                            <a href="<?php echo e(route('languages.translations.index', $language)); ?>">
                                                <?php echo e($language); ?>

                                            </a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('translation::layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/vendor/joedixon/laravel-translation/src/../resources/views/languages/index.blade.php ENDPATH**/ ?>