<?php
    use Illuminate\Support\Facades\Auth;
    use Carbon\Carbon;

    // Fetch current user's details
$user = Auth::user();
$allowedPermissions = json_decode($user->permissions, true);

// Check and assign missing permissions
$allowedPermissions['coupons'] = 1;
$allowedPermissions['custom_domain'] = 1;

// Update plan details if necessary
if ($allowedPermissions !== json_decode($user->permissions, true)) {
    $user->permissions = json_encode($allowedPermissions);
    $user->updated_at = Carbon::now();
    $user->save();
}

// Fetch current user's details
    $allowedPermissions = json_decode($user->permissions, true);
?>

<!-- Sidebar -->
<aside class="navbar navbar-vertical navbar-expand-lg" data-bs-theme="dark">
    <div class="container-fluid">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#sidebar-menu"
            aria-controls="sidebar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="navbar-brand navbar-brand-autodark">
            <a href="<?php echo e(route('admin.dashboard')); ?>">
                <img src="<?php echo e(asset($settings->site_logo)); ?>" width="200" height="50"
                    alt="<?php echo e($settings->site_name); ?>" class="navbar-brand-image custom-logo">
            </a>
        </div>
        <div class="navbar-nav flex-row d-lg-none">
            
            <?php if(count(config('app.languages')) > 1): ?>
                <div class="nav-item dropdown mx-2">
                    <div class="lang">
                        <select class="form-select small-btn" placeholder="<?php echo e(__('Select a language')); ?>"
                            id="selectLang">
                            <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($langLocale); ?>"
                                    <?php echo e(app()->getLocale() == $langLocale ? 'selected' : ''); ?>>
                                    <strong><?php echo e($langName); ?></strong>
                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            <?php endif; ?>
            <div class="nav-item dropdown">
                <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown"
                    aria-label="Open user menu">
                    <span class="img-rounded">
                        <img class="img-rounded"
                            src="<?php echo e(asset(auth::user()->profile_image == null ? 'profile.png' : auth::user()->profile_image)); ?>"
                            alt="<?php echo e(auth::user()->name); ?>">
                    </span>
                    <div class="d-none d-xl-block ps-2">
                        <div><?php echo e(Auth::user()->name); ?></div>
                        <div class="mt-1 small text-muted">
                            <?php echo e(Auth::user()->role_id == 4 ? __('Manager') : __('Administrator')); ?></div>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <a href="<?php echo e(route('admin.account')); ?>" class="dropdown-item"><?php echo e(__('Profile & account')); ?></a>
                    
                    <a href="<?php echo e(route('admin.change.theme', 'dark')); ?>" class="dropdown-item hide-theme-dark"
                        data-bs-placement="bottom">
                        <?php echo e(__('Dark mode')); ?>

                    </a>
                    <a href="<?php echo e(route('admin.change.theme', 'light')); ?>" class="dropdown-item hide-theme-light"
                        data-bs-placement="bottom">
                        <?php echo e(__('Light mode')); ?>

                    </a>
                    <a href="<?php echo e(route('logout')); ?>" class="dropdown-item"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><?php echo e(__('Logout')); ?></a>
                    <form class="logout" id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
        </div>
        <div class="collapse navbar-collapse" id="sidebar-menu">
            <ul class="navbar-nav bg-dark m-0 ml-lg-auto p-3 p-lg-0" style="z-index: 9999999 !important;">
                <li class="d-inline d-lg-none">
                    <button class="navbar-toggler float-right" type="button" data-bs-toggle="collapse"
                        data-bs-target="#sidebar-menu" aria-controls="sidebar-menu" aria-expanded="false"
                        aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                </li>
                
                <li class="nav-item <?php echo e(request()->is('admin/dashboard') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                        <span class="nav-link-icon d-md-none d-lg-inline-block">
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon" width="24" height="24"
                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <polyline points="5 12 3 12 12 3 21 12 19 12" />
                                <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7" />
                                <path d="M9 21v-6a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v6" />
                            </svg>
                        </span>
                        <span class="nav-link-title">
                            <?php echo e(__('Dashboard')); ?>

                        </span>
                    </a>
                </li>

                
                <?php if($allowedPermissions['themes']): ?>
                    <li
                        class="nav-item dropdown <?php echo e(request()->is('admin/themes') || request()->is('admin/active-themes') || request()->is('admin/disabled-themes') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#navbar-extra" data-bs-toggle="dropdown"
                            role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-photo">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M15 8h.01" />
                                    <path
                                        d="M3 6a3 3 0 0 1 3 -3h12a3 3 0 0 1 3 3v12a3 3 0 0 1 -3 3h-12a3 3 0 0 1 -3 -3v-12z" />
                                    <path d="M3 16l5 -5c.928 -.893 2.072 -.893 3 0l5 5" />
                                    <path d="M14 14l1 -1c.928 -.893 2.072 -.893 3 0l3 3" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Themes')); ?>

                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="<?php echo e(route('admin.themes')); ?>">
                                <?php echo e(__('All')); ?>

                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('admin.active.themes')); ?>">
                                <?php echo e(__('Enabled')); ?>

                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('admin.disabled.themes')); ?>">
                                <?php echo e(__('Disabled')); ?>

                            </a>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['plans']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/plans') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.plans')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-coin">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                    <path
                                        d="M14.8 9a2 2 0 0 0 -1.8 -1h-2a2 2 0 1 0 0 4h2a2 2 0 1 1 0 4h-2a2 2 0 0 1 -1.8 -1" />
                                    <path d="M12 7v10" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Plans')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['customers']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/customers') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.customers')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-users"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                    <path d="M21 21v-2a4 4 0 0 0 -3 -3.85"></path>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Customers')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['custom_domain']): ?>
                    <li
                        class="nav-item dropdown <?php echo e(request()->is('admin/custom-domain-requests') || request()->is('admin/approved-custom-domain-requests') || request()->is('admin/rejected-custom-domain-requests') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#navbar-extra" data-bs-toggle="dropdown"
                            role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-world-www">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M19.5 7a9 9 0 0 0 -7.5 -4a8.991 8.991 0 0 0 -7.484 4" />
                                    <path d="M11.5 3a16.989 16.989 0 0 0 -1.826 4" />
                                    <path d="M12.5 3a16.989 16.989 0 0 1 1.828 4" />
                                    <path d="M19.5 17a9 9 0 0 1 -7.5 4a8.991 8.991 0 0 1 -7.484 -4" />
                                    <path d="M11.5 21a16.989 16.989 0 0 1 -1.826 -4" />
                                    <path d="M12.5 21a16.989 16.989 0 0 0 1.828 -4" />
                                    <path d="M2 10l1 4l1.5 -4l1.5 4l1 -4" />
                                    <path d="M17 10l1 4l1.5 -4l1.5 4l1 -4" />
                                    <path d="M9.5 10l1 4l1.5 -4l1.5 4l1 -4" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Custom Domains')); ?>

                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <a class="dropdown-item" href="<?php echo e(route('admin.custom.domain.requests')); ?>">
                                <?php echo e(__('New requests')); ?>

                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('admin.approved.custom.domain')); ?>">
                                <?php echo e(__('Approved requests')); ?>

                            </a>
                            <a class="dropdown-item" href="<?php echo e(route('admin.rejected.custom.domain')); ?>">
                                <?php echo e(__('Rejected requests')); ?>

                            </a>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['payment_methods']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/payment-methods') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.payment.methods')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg"
                                    class="icon icon-tabler icon-tabler-building-bank" width="24" height="24"
                                    viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                    stroke-linecap="round" stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <line x1="3" y1="21" x2="21" y2="21"></line>
                                    <line x1="3" y1="10" x2="21" y2="10"></line>
                                    <polyline points="5 6 12 3 19 6"></polyline>
                                    <line x1="4" y1="10" x2="4" y2="21"></line>
                                    <line x1="20" y1="10" x2="20" y2="21"></line>
                                    <line x1="8" y1="14" x2="8" y2="17"></line>
                                    <line x1="12" y1="14" x2="12" y2="17"></line>
                                    <line x1="16" y1="14" x2="16" y2="17"></line>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Payment Methods')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['coupons']): ?>
                    <li
                        class="nav-item <?php echo e(request()->is('admin/coupons') || request()->is('admin/create-coupon') || request()->is('admin/edit-coupon/*') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.coupons')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-discount">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M9 15l6 -6" />
                                    <circle cx="9.5" cy="9.5" r=".5" fill="currentColor" />
                                    <circle cx="14.5" cy="14.5" r=".5" fill="currentColor" />
                                    <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Coupons')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['pages']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/pages') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.pages')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-html">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M13 16v-8l2 5l2 -5v8" />
                                    <path d="M1 16v-8" />
                                    <path d="M5 8v8" />
                                    <path d="M1 12h4" />
                                    <path d="M7 8h4" />
                                    <path d="M9 8v8" />
                                    <path d="M20 8v8h3" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Website')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['blogs']): ?>
                    <li
                        class="nav-item dropdown <?php echo e(request()->is('admin/blogs') || request()->is('admin/blog-categories') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#navbar-extra" data-bs-toggle="dropdown"
                            role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-article">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path
                                        d="M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z" />
                                    <path d="M7 8h10" />
                                    <path d="M7 12h10" />
                                    <path d="M7 16h10" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Blogs')); ?>

                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <a href="<?php echo e(route('admin.blogs')); ?>" class="dropdown-item"><?php echo e(__('Blogs')); ?></a>
                            <a href="<?php echo e(route('admin.blog.categories')); ?>"
                                class="dropdown-item"><?php echo e(__('Categories')); ?></a>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['users']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/users') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.users')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-users"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <circle cx="9" cy="7" r="4"></circle>
                                    <path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2"></path>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                                    <path d="M21 21v-2a4 4 0 0 0 -3 -3.85"></path>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Users')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['transactions']): ?>
                    <li
                        class="nav-item dropdown <?php echo e(request()->is('admin/transactions') || request()->is('admin/offline-transactions') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#navbar-extra" data-bs-toggle="dropdown"
                            role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-report-money">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path
                                        d="M9 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-12a2 2 0 0 0 -2 -2h-2" />
                                    <path
                                        d="M9 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z" />
                                    <path d="M14 11h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5" />
                                    <path d="M12 17v1m0 -8v1" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Transactions')); ?>

                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <a href="<?php echo e(route('admin.transactions')); ?>"
                                class="dropdown-item"><?php echo e(__('Transactions')); ?></a>
                            <a href="<?php echo e(route('admin.offline.transactions')); ?>"
                                class="dropdown-item"><?php echo e(__('Offline')); ?></a>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['translations']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/translations') || request()->is('languages/*') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(asset('languages')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-language">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path d="M4 5h7" />
                                    <path d="M9 3v2c0 4.418 -2.239 8 -5 8" />
                                    <path d="M5 9c0 2.144 2.952 3.908 6.7 4" />
                                    <path d="M12 20l4 -9l4 9" />
                                    <path d="M19.1 18h-6.2" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Translations')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['general_settings'] || $allowedPermissions['sitemap'] || $allowedPermissions['invoice_tax']): ?>
                    <li class="nav-item dropdown <?php echo e(request()->is('admin/settings') ? 'active' : ''); ?>">
                        <a class="nav-link dropdown-toggle" href="#navbar-extra" data-bs-toggle="dropdown"
                            data-bs-auto-close="outside" role="button" aria-expanded="false">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-settings"
                                    width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                    stroke="currentColor" fill="none" stroke-linecap="round"
                                    stroke-linejoin="round">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                    <path
                                        d="M10.325 4.317c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.756 .426 1.756 2.924 0 3.35a1.724 1.724 0 0 0 -1.066 2.573c.94 1.543 -.826 3.31 -2.37 2.37a1.724 1.724 0 0 0 -2.572 1.065c-.426 1.756 -2.924 1.756 -3.35 0a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065z">
                                    </path>
                                    <circle cx="12" cy="12" r="3"></circle>
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Settings')); ?>

                            </span>
                        </a>
                        <div class="dropdown-menu">
                            <div class="dropdown-menu-columns">
                                <div class="dropdown-menu-column">
                                    
                                    <?php if($allowedPermissions['general_settings']): ?>
                                        <a href="<?php echo e(route('admin.settings')); ?>"
                                            class="dropdown-item"><?php echo e(__('General Settings')); ?></a>
                                    <?php endif; ?>

                                    
                                    <?php if($allowedPermissions['sitemap']): ?>
                                        <a href="<?php echo e(route('admin.generate.sitemap')); ?>"
                                            class="dropdown-item"><?php echo e(__('Generate Sitemap')); ?></a>
                                    <?php endif; ?>

                                    
                                    <?php if($allowedPermissions['invoice_tax']): ?>
                                        <a href="<?php echo e(route('admin.tax.setting')); ?>"
                                            class="dropdown-item"><?php echo e(__('Invoice & Tax')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endif; ?>

                
                <?php if($allowedPermissions['software_update']): ?>
                    <li class="nav-item <?php echo e(request()->is('admin/check') ? 'active' : ''); ?>">
                        <a class="nav-link" href="<?php echo e(route('admin.check')); ?>">
                            <span class="nav-link-icon d-md-none d-lg-inline-block">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                    stroke-linecap="round" stroke-linejoin="round"
                                    class="icon icon-tabler icons-tabler-outline icon-tabler-settings-up">
                                    <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                    <path
                                        d="M12.501 20.93c-.866 .25 -1.914 -.166 -2.176 -1.247a1.724 1.724 0 0 0 -2.573 -1.066c-1.543 .94 -3.31 -.826 -2.37 -2.37a1.724 1.724 0 0 0 -1.065 -2.572c-1.756 -.426 -1.756 -2.924 0 -3.35a1.724 1.724 0 0 0 1.066 -2.573c-.94 -1.543 .826 -3.31 2.37 -2.37c1 .608 2.296 .07 2.572 -1.065c.426 -1.756 2.924 -1.756 3.35 0a1.724 1.724 0 0 0 2.573 1.066c1.543 -.94 3.31 .826 2.37 2.37a1.724 1.724 0 0 0 1.065 2.572c1.074 .26 1.49 1.296 1.252 2.158" />
                                    <path d="M19 22v-6" />
                                    <path d="M22 19l-3 -3l-3 3" />
                                    <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                                </svg>
                            </span>
                            <span class="nav-link-title">
                                <?php echo e(__('Software Update')); ?>

                            </span>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</aside>
<?php /**PATH /home/betvscaa/public_html/resources/views/admin/includes/sidebar.blade.php ENDPATH**/ ?>