<?php
use Illuminate\Support\Str;

if (app()->getLocale() == null) {
    Session::put('locale', $business_card_details->card_lang);
    app()->setLocale(Session::get('locale'));
}
?>

<div class="fixed top-0 right-0 m-4 absolute">
    <select id="language" name="language" class="block w-full bg-white border border-gray-300 text-gray-700 py-1 px-1 pr-1 rounded-md shadow-sm focus:outline-none sm:text-sm">
        <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($langLocale); ?>" <?php echo e(app()->getLocale() == $langLocale ? 'selected' : ''); ?>><strong><?php echo e(Str::upper($langLocale)); ?></strong></option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</div>


<?php $__env->startSection('custom-js'); ?>
<script>
// Language switcher
$(document).ready(function() {
    "use strict";
    // Language switcher
    $('#language').change(function() {
        var selectedLocale = $(this).val();

        $.ajax({
            url: "<?php echo e(route('set.locale')); ?>",  // Use the route name defined earlier
            type: "POST",
            data: {
                locale: selectedLocale,
                _token: '<?php echo e(csrf_token()); ?>' // Include CSRF token
            },
            success: function(response) {
                console.log(response.message); // Log success message
                // Redirect page
                window.location = ``;
            },
            error: function(xhr) {
                console.error(xhr.responseText); // Log error message
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/templates/includes/language-switcher.blade.php ENDPATH**/ ?>