

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="card">
                <div class="row g-0">
                    <div class="col-12 col-md-3 border-end">
                        <div class="card-body">
                            <h4 class="subheader"><?php echo e(__('Update Business Card')); ?></h4>
                            <div class="list-group list-group-transparent">
                                
                                <?php echo $__env->make('user.pages.edit-cards.includes.nav-link', ['link' => 'hours'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-9 d-flex flex-column">
                        <form action="<?php echo e(route('user.update.business.hours', Request::segment(3))); ?>" method="post" enctype="multipart/form-data" id="myForm">
                            <?php echo csrf_field(); ?>
                            
                            <div class="card-body">
                                <h3 class="card-title mb-4"><?php echo e(__('Business Hours')); ?></h3>
                                
                                <div class="row">
                                    <h2 class="page-title my-3"><?php echo e(__('Always Open')); ?></h2>
                                
                                    <div class="row">
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('24 Hours')); ?></div>
                                                <label class="form-check form-switch">
                                                    <input id="always-open" class="form-check-input" type="checkbox" name="always_open" 
                                                        <?php echo e($business_hrs['alwaysOpen'] == "Opening" ? 'checked' : ''); ?>>
                                                </label>
                                            </div>
                                        </div>
                                
                                        <div class="col-md-3 col-xl-3">
                                            <div class="mb-3">
                                                <div class="form-label"><?php echo e(__('Hide Business Hours')); ?></div>
                                                <label class="form-check form-switch">
                                                    <input id="display-hrs" class="form-check-input" type="checkbox" 
                                                        onchange="toggleDisplay('is_display', '#business-hrs')" name="is_display" 
                                                        <?php echo e($business_hrs['isDisplay'] == 0 ? 'checked' : ''); ?>>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                
                                    <div id="business-hrs" class="row">
                                        <?php $__currentLoopData = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-md-3 col-xl-3">
                                                <div class="mb-3">
                                                    <h2 class="page-title my-3"><?php echo e(__(ucfirst($day))); ?></h2>
                                                    <div class="mb-3">
                                                        <div class="form-label"><?php echo e(__('Closed')); ?></div>
                                                        <label class="form-check form-switch">
                                                            <input class="form-check-input" type="checkbox" onload="toggleDisplay('<?php echo e($day); ?>_closed', '#<?php echo e($day); ?>-business')" onchange="toggleDisplay('<?php echo e($day); ?>_closed', '#<?php echo e($day); ?>-business')" 
                                                                name="<?php echo e($day); ?>_closed" <?php echo e($business_hrs[$day . '_status'] == "Closed" ? 'checked' : ''); ?>>
                                                        </label>
                                                    </div>
                                                </div>
                                                <div id="<?php echo e($day); ?>-business">
                                                    <div class="mb-3">
                                                        <input type="time" class="form-control" name="<?php echo e($day); ?>_open" 
                                                            placeholder="<?php echo e(__('Opening Time')); ?>" 
                                                            value="<?php echo e($business_hrs[$day . '_open']); ?>">
                                                    </div>
                                                    <div class="mb-3">
                                                        <input type="time" class="form-control" name="<?php echo e($day); ?>_closing" 
                                                            placeholder="<?php echo e(__('Closing Time')); ?>" 
                                                            value="<?php echo e($business_hrs[$day . '_close']); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>

                            <div class="card-footer bg-transparent mt-auto">
                                <div class="btn-list justify-content-end">
                                    <a href="<?php echo e(route('user.cards')); ?>" class="btn">
                                        <?php echo e(__('Cancel')); ?>

                                    </a>

                                    
                                    <?php
                                    $route = route('user.cards');

                                    // Check business hours is "ENABLED"
                                    if ($plan_details->appointment == 1) {
                                        $route = route('user.edit.appointment', Request::segment(3));
                                    } elseif ($plan_details->contact_form == 1) {
                                        $route = route('user.edit.contact.form', Request::segment(3));
                                    } elseif ($plan_details->password_protected == 1 || $plan_details->advanced_settings == 1) {
                                        $route = route('user.edit.advanced.setting', Request::segment(3));
                                    }
                                    ?>

                                    <a href="<?php echo e($route); ?>" class="btn btn-primary">
                                        <?php echo e(__('Skip')); ?>

                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Submit')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startPush('custom-js'); ?>
<script>
    // Function to trigger toggleDisplay on page load
    window.onload = function() {
        "use strict";

        var days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
        days.forEach(function(day) {
            toggleDisplay(day + '_closed', '#' + day + '-business');
        });
    };

    // Check if business hours should be hidden
    <?php if($business_hrs['isDisplay'] === 0 || $business_hrs['alwaysOpen'] === "Opening"): ?>
        // Get the business hours element
        var businessHours = document.getElementById('business-hrs');
        
        // Hide the business hours element
        businessHours.style.display = 'none';
    <?php endif; ?>

    document.addEventListener('DOMContentLoaded', function () {
        "use strict";
        
        const alwaysOpenCheckbox = document.getElementById('always-open');
        const displayHrsCheckbox = document.getElementById('display-hrs');

        alwaysOpenCheckbox.addEventListener('change', function () {
            if (alwaysOpenCheckbox.checked) {
                displayHrsCheckbox.checked = false;

                // Get the business hours element
                var businessHours = document.getElementById('business-hrs');
                
                // Hide the business hours element
                businessHours.style.display = 'none';
            } else {
                // Get the business hours element
                var businessHours = document.getElementById('business-hrs');
                
                // Hide the business hours element
                businessHours.style.display = 'flex';
            }
        });

        displayHrsCheckbox.addEventListener('change', function () {
            if (displayHrsCheckbox.checked) {
                alwaysOpenCheckbox.checked = false;
            }
        });
    });

    function toggleDisplay(inputName, elementId) {
        "use strict";
        var isChecked = $('input[name="' + inputName + '"]:checked').length;
        if (isChecked == 0) {
            $(elementId).show();
        } else {
            $(elementId).hide();
        }
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/edit-business-hours.blade.php ENDPATH**/ ?>