

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid"> 
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">

            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            <div class="row row-deck row-cards">
                <div class="col">
                    <h2 class="page-title">
                        <?php echo e(__('Static Pages')); ?>

                    </h2>
                </div>
                <span class="text-muted font-weight-bold"><?php echo e(__("Note: Static pages are doesn't have HTML editor. You can able to change the contents only.")); ?></span>

                
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table" id="pages-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('#')); ?></th>
                                        <th><?php echo e(__('Page')); ?></th>
                                        <th><?php echo e(__('Slug')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>

                
                <div class="col mt-4">
                    <h2 class="page-title">
                        <?php echo e(__('Custom Pages')); ?>

                    </h2>
                </div>
                <!-- Add page -->
                <div class="col-auto ms-auto d-print-none mt-4">
                    <a type="button" href="<?php echo e(route('admin.add.page')); ?>" class="btn btn-primary">
                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus" width="24"
                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                            stroke-linecap="round" stroke-linejoin="round">
                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                            <line x1="12" y1="5" x2="12" y2="19"></line>
                            <line x1="5" y1="12" x2="19" y2="12"></line>
                        </svg>
                        <?php echo e(__('Add New Page')); ?>

                    </a>
                </div>
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table" id="custom-pages-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('#')); ?></th>
                                        <th><?php echo e(__('Page')); ?></th>
                                        <th><?php echo e(__('Slug')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<div class="modal modal-blur fade" id="status-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div><?php echo e(__('If you proceed, you will enable/disable this page.')); ?></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="page_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div id="delete_status"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="delete_qr_code_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>

<script type="text/javascript">
    $(document).ready(function() {
        $('#pages-table').DataTable({
            processing: false,
            serverSide: true,
            ajax: "<?php echo e(route('admin.pages')); ?>",
            language: {
                loadingRecords: "Please wait - loading...",
                emptyTable: "No data available in the table" // Message for an empty table
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'page_name', name: 'page_name' },
                { data: 'url', name: 'url', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            preDrawCallback: function(settings) {
                // Add placeholder-glow class to the table before rendering
                $('#pages-table_wrapper').addClass('placeholder-glow');

                // Check if there are rows in the tbody after draw
                if ($('#pages-table tbody tr').length === 0) {
                    // If there are no rows, add 10 placeholder rows with 5 columns each
                    var placeholderRows = '';
                    for (var i = 0; i < 10; i++) {
                        placeholderRows += '<tr>' + '<td class="text-center"><div class="placeholder placeholder-xs col-12"></div></td>'.repeat(5) + '</tr>';
                    }
                    $('#pages-table tbody').html(placeholderRows);
                }
            },
            drawCallback: function(settings) {
                // Remove the placeholder-glow class once the table is fully rendered
                $('#pages-table_wrapper').removeClass('placeholder-glow');

                // clear any existing placeholder rows
                $('#pages-table tbody tr').each(function() {
                    var actionCell = $(this).find('td').eq(4); // Targeting the 4th column (index 4)
                    if (actionCell.find('span.placeholder').length > 0) {
                        actionCell.empty(); // Clear the placeholder once data is available
                    }
                });
            }
        });
    });
    
    function getDisablePage(pageName) {
        "use strict";

        $("#status-modal").modal("show");
        var link = document.getElementById("page_id");
        link.getAttribute("href");
        link.setAttribute("href", "<?php echo e(route('admin.disable.page')); ?>?id=" + pageName);
    }
</script>


<script type="text/javascript">
    $(document).ready(function() {
        $('#custom-pages-table').DataTable({
            processing: false,
            serverSide: true,
            ajax: "<?php echo e(route('admin.custom.pages')); ?>",
            language: {
                loadingRecords: "Please wait - loading...",
                emptyTable: "No data available in the table" // Message for an empty table
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'section_name', name: 'section_name' },
                { data: 'url', name: 'url', orderable: false, searchable: false },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            preDrawCallback: function(settings) {
                // Add placeholder-glow class to the table before rendering
                $('#custom-pages-table_wrapper').addClass('placeholder-glow');

                // Check if there are rows in the tbody after draw
                if ($('#custom-pages-table tbody tr').length === 0) {
                    // If there are no rows, add 5 placeholder rows with 5 columns each
                    var placeholderRows = '';
                    for (var i = 0; i < 5; i++) {
                        placeholderRows += '<tr>' + '<td class="text-center"><div class="placeholder placeholder-xs col-12"></div></td>'.repeat(5) + '</tr>';
                    }
                    $('#custom-pages-table tbody').html(placeholderRows);
                }
            },
            drawCallback: function(settings) {
                // Remove the placeholder-glow class once the table is fully rendered
                $('#custom-pages-table_wrapper').removeClass('placeholder-glow');

                // clear any existing placeholder rows
                $('#custom-pages-table tbody tr').each(function() {
                    var actionCell = $(this).find('td').eq(4); // Targeting the 4th column (index 4)
                    if (actionCell.find('span.placeholder').length > 0) {
                        actionCell.empty(); // Clear the placeholder once data is available
                    }
                });
            }
        });
    });
    
    function getPage(pageId) {
        "use strict";

        $("#status-modal").modal("show");
        var link = document.getElementById("page_id");
        link.getAttribute("href");
        link.setAttribute("href", "<?php echo e(route('admin.status.page')); ?>?id=" + pageId);
    }
    
    function deletePage(pageId, action) {
        "use strict";

        $("#delete-modal").modal("show");
        var delete_status = document.getElementById("delete_status");
        delete_status.innerHTML = "<?php echo __('If you proceed, you will') ?> " + action + " <?php echo __('this page.') ?>"
        var delete_link = document.getElementById("delete_qr_code_id");
        delete_link.getAttribute("href");
        delete_link.setAttribute("href", "<?php echo e(route('admin.delete.page')); ?>?id=" + pageId);
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/pages/index.blade.php ENDPATH**/ ?>