


<?php $__env->startSection('custom-script'); ?>
<?php if($settings->google_adsense_code != 'DISABLE_ADSENSE_ONLY'): ?>

<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>" crossorigin="anonymous"></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div>
    <section class="text-gray-700">
        <div class="container px-5 py-12 mx-auto">
            
            <div class="mb-2">
                <h1 class="text-3xl font-bold font-large title-font text-gray-900 mb-4">
                    <?php echo e(__('DNS Lookup')); ?>

                </h1>
            </div>

            
            <form action="<?php echo e(route('web.result.dns.lookup')); ?>" method="post">
                <?php echo csrf_field(); ?>

                
                <div class='mb-3 space-y-2 w-full'>
                    <label class='font-bold text-gray-600 py-2'><?php echo e(__('Domain URL')); ?> <abbr title='required'>*</abbr></label>
                    <input placeholder='<?php echo e(__('Eg: https://domain.com')); ?>' class='appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter rounded-lg h-10 px-4' required='required' value='<?php echo e($domain ?? (old('domain') ?? '')); ?>' type='text' name='domain' id='domain'>
                </div>

                <button type="submit" class="group relative font-heading px-10 py-5 mb-8 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-md"><?php echo e(__('Search')); ?></button>
            </form>

            
            <?php if(isset($results)): ?>
                <div class='flex flex-wrap lg:w-full sm:mx-auto sm:mb-2 lg:mt-12'>  
                    <div class="rounded-xl border p-5 shadow-md w-full bg-white">
                        <div class="flex w-full items-center justify-between border-b pb-3">
                            <div class="flex items-center space-x-3">
                                <div class="text-lg font-bold text-slate-700"><?php echo e(__('Result')); ?></div>
                            </div>
                            <div class="flex items-center space-x-8">
                                <button class="rounded-2xl border bg-neutral-100 px-3 py-1 font-semibold"><?php echo e(__('DNS')); ?></button>
                            </div>
                        </div>
                    
                        <?php if(empty($results)): ?>
                            <?php echo e(__('No results found.')); ?>

                        <?php else: ?>
                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('A Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'a'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('IP')); ?> : <?php echo e($result['ip']); ?></div>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('AAAA Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'aaaa'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('IPv6')); ?> : <?php echo e($result['ipv6']); ?></div>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('CNAME Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'cname'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Target')); ?> : <?php echo e($result['target']); ?></div>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('MX Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'mx'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Target')); ?> : <?php echo e($result['target']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Priority')); ?> : <?php echo e($result['pri']); ?></div>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('TXT Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'txt'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <?php $__currentLoopData = $result['entries']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="text-lg text-neutral-600 <?php echo e(!$loop->first ? 'mt-1' : ''); ?>"><?php echo e(__('Entries')); ?> : <?php echo e($entry); ?></div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                            
                            <div class="mt-4 mb-2">
                                <div class="mb-3 text-xl font-bold"><?php echo e(__('NS Record')); ?></div>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if(strtolower($result['type']) == 'ns'): ?>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Type')); ?> : <?php echo e($result['type']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Hostname')); ?> : <?php echo e($result['host']); ?></div>
                                <div class="text-lg text-neutral-600"><?php echo e(__('Target')); ?> : <?php echo e($result['target']); ?></div>
                                <div class="text-lg text-neutral-600 mb-3"><?php echo e(__('TTL')); ?> : <?php echo e($result['ttl']); ?></div>
                                <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', ['nav' => true, 'banner' => false, 'footer' => true, 'cookie' => true, 'setting' => true,
'title' => __('DNS Lookup - Web Tools')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/website/pages/web-tools/dns.blade.php ENDPATH**/ ?>