<?php
    // Settings
    use App\Setting;
    use App\Page;
    $setting = Setting::where('status', 1)->first();
    $pages = Page::get();
?>

<section class="relative py-12 lg:px-24 overflow-hidden">
    <img class="absolute bottom-0 left-0" src="<?php echo e(asset('app/assets/elements/footers/radial.svg')); ?>" alt="">
    <div class="relative z-10 container mx-auto px-4">
        <div class="flex flex-wrap -m-6">
            <div class="w-full md:w-1/2 lg:w-5/12 p-6">
                <div class="flex flex-col justify-between h-full">
                    <div>
                        <img class="mb-4" src="<?php echo e(asset($settings->site_logo)); ?>" alt="<?php echo e($settings->site_name); ?>"
                            width="200">
                    </div>
                    <div>
                        <p class="text-gray-600 text-sm">© <?php echo e(__('Copyright')); ?>

                            <?php echo e(Carbon\Carbon::now()->format('Y')); ?>. <?php echo e(__('All Rights Reserved by')); ?> <?php echo e(config('app.name')); ?>.</p>
                    </div>
                </div>
            </div>
            <div
                class="w-full <?php echo e($supportPage[0]->section_content || $supportPage[1]->section_content || $supportPage[2]->section_content || $supportPage[3]->section_content || $supportPage[4]->section_content != '' ? 'md:w-1/2 lg:w-2/12' : 'md:w-1/2 lg:w-2/12'); ?> p-6">
                <div class="h-full">
                    <h3 class="mb-9 font-heading font-semibold text-xs text-gray-500 uppercase tracking-px">
                        <?php echo e(__('Getting Started')); ?></h3>
                    <ul>
                        <li class="mb-4"><a
                                class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                href="<?php echo e(route('home-locale')); ?>#how-it-works"><?php echo e(__('How it works?')); ?></a></li>
                        <li class="mb-4"><a
                                class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                href="<?php echo e(route('home-locale')); ?>#features"><?php echo e(__('Features')); ?></a></li>
                        <li class="mb-4"><a
                                class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                href="<?php echo e(route('home-locale')); ?>#pricing"><?php echo e(__('Pricing')); ?></a></li>
                        <li class="mb-4"><a
                            class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                            href="<?php echo e(route('blogs')); ?>"><?php echo e(__('Blogs')); ?></a></li>
                    </ul>
                </div>
            </div>
            <div
                class="w-full <?php echo e($supportPage[0]->section_content || $supportPage[1]->section_content || $supportPage[2]->section_content || $supportPage[3]->section_content != '' || $supportPage[4]->section_content != '' ? 'md:w-1/2 lg:w-2/12' : 'md:w-1/2 lg:w-2/12'); ?> p-6">
                <div class="h-full">
                    <h3 class="mb-9 font-heading font-semibold text-xs text-gray-500 uppercase tracking-px">
                        <?php echo e(__('My Account')); ?></h3>
                    <ul>
                        <li class="mb-4"><a
                                class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                href="<?php echo e(route('login')); ?>"><?php echo e(__('Login')); ?></a></li>

                        <?php if(Route::has('register')): ?>
                            <li class="mb-4"><a
                                    class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('register')); ?>"><?php echo e(__('Register')); ?></a></li>
                        <?php endif; ?>

                        <?php if($pages[195]->page_name == 'contact' && $pages[195]->status == 'active'): ?>
                            <li class="mb-4"><a
                                    class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('contact')); ?>"><?php echo e(__('Contact Us')); ?></a></li>
                        <?php endif; ?>

                        <li><a class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                href="mailto:<?php echo e($supportPage[10]->section_content); ?>"><?php echo e(__('Customer Support')); ?></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="w-full md:w-1/2 lg:w-3/12 p-6">
                <div class="h-full">
                    <h3 class="mb-9 font-heading font-semibold text-xs text-gray-500 uppercase tracking-px"><?php echo e(__('Legals')); ?></h3>
                    <ul>
                        <?php if($pages[49]->page_name == 'faq' && $pages[49]->status == 'active'): ?>
                            <li class="mb-4"><a class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('faq')); ?>"><?php echo e(__('FAQs')); ?></a></li>
                        <?php endif; ?>
                        <?php if($pages[108]->page_name == 'terms' && $pages[108]->status == 'active'): ?>
                            <li class="mb-4"><a
                                    class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('terms.and.conditions')); ?>"><?php echo e(__('Terms and Conditions')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if($pages[64]->page_name == 'privacy' && $pages[64]->status == 'active'): ?>
                            <li class="mb-4"><a
                                    class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('privacy.policy')); ?>"><?php echo e(__('Privacy Policy')); ?></a></li>
                        <?php endif; ?>
                        <?php if($pages[156]->page_name == 'refund' && $pages[156]->status == 'active'): ?>
                            <li><a class="font-heading font-medium text-base text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('refund.policy')); ?>"><?php echo e(__('Refund Policy')); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/betvscaa/public_html/resources/views/website/includes/footer.blade.php ENDPATH**/ ?>