<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>
        <?php echo e(__('NativeCode Installer')); ?>

    </title>
    <link rel="icon" type="image/png" href="<?php echo e(asset('installer/img/favicon/favicon-96x96.png')); ?>" sizes="96x96" />

    <!-- CSS files -->
    <link href="../../css/tabler.min.css" rel="stylesheet" />
    <link href="../../css/tabler-flags.min.css" rel="stylesheet" />
    <link href="../../css/tabler-payments.min.css" rel="stylesheet" />
    <link href="../../css/tabler-vendors.min.css" rel="stylesheet" />
    <link href="../../css/demo.min.css" rel="stylesheet" />
    <link href="../../css/styles.css" rel="stylesheet" />
    <link rel="stylesheet" href="../../css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="../../css/custom.css">
    <script type="text/javascript" src="../../js/jquery.min.js"></script>
    <script>
        window.Laravel = <?php echo json_encode(['csrfToken' => csrf_token()]); ?>
    </script>
</head>

<body class="antialiased border-top-wide border-primary d-flex flex-column">
    <div class="page">
        <div class="container container-tight py-4">
            <div class="card card-md">
                <div class="card-body text-center py-4 p-sm-5">
                    <div class="text-center mb-1">
                        <a href="#"><img src="<?php echo e(asset('installer/img/logo.png')); ?>" height="45" alt="NativeCode"></a>
                    </div>
                    <div class="hr-text hr-text-center mb-0 mt-4 hr-text-spaceless"><?php echo $__env->yieldContent('title'); ?></div>
                </div>
                <?php if(session('message')): ?>
                    <div class="m-3">
                        <div class="alert alert-info">
                            <strong>
                                <?php if(is_array(session('message'))): ?>
                                    <?php echo e(session('message')['message']); ?>

                                <?php else: ?>
                                    <?php echo e(session('message')); ?>

                                <?php endif; ?>
                            </strong>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if(session()->has('errors')): ?>
                    <div class="alert alert-danger">
                        <h4>
                            <?php echo e(trans('installer_messages.forms.errorTitle')); ?>

                        </h4>
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <div class="align-items-center">
                    <div class="col-12">



                        <div class="card-body">


                            <?php echo $__env->yieldContent('container'); ?>


                        </div>

                        <div class="hr-text hr-text-center mb-4 mt-4 hr-text-spaceless">Installation Progress</div>

                        <div class="row item-align-center">

                            <div class="col-3">&nbsp;</div>
                            <div class="col-6 pb-4 pt-4">

                                <div class="progress">

                                    <?php if(Request::is('install')): ?>
                                        <div class="progress-bar" style="width: 0%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">0% Complete</span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(Request::is('install/requirements')): ?>
                                        <div class="progress-bar" style="width: 10%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">10% Complete</span>
                                        </div>
                                    <?php endif; ?>


                                    <?php if(Request::is('install/permissions')): ?>
                                        <div class="progress-bar" style="width: 20%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">20% Complete</span>
                                        </div>
                                    <?php endif; ?>


                                    <?php if(Request::is('install/environment')): ?>
                                        <div class="progress-bar" style="width: 40%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">40% Complete</span>
                                        </div>
                                    <?php endif; ?>


                                    <?php if(Request::is('install/environment/wizard') || Request::is('install/environment/classic')): ?>
                                        <div class="progress-bar" style="width: 70%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">70% Complete</span>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(Request::is('install/final')): ?>
                                        <div class="progress-bar" style="width: 100%" role="progressbar"
                                            aria-valuenow="25" aria-valuemin="0" aria-valuemax="100">
                                            <span class="visually-hidden">100% Complete</span>
                                        </div>
                                    <?php endif; ?>

                                </div>
                            </div>
                            <div class="col-3">&nbsp;</div>


                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('scripts'); ?>
    <script type="text/javascript">
        var x = document.getElementById('error_alert');
        var y = document.getElementById('close_alert');
        y.onclick = function() {
            x.style.display = "none";
        };
    </script>
</body>

</html>
<?php /**PATH /home/betvscaa/public_html/resources/views/vendor/installer/layouts/installation.blade.php ENDPATH**/ ?>