<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(config('app.name')); ?></title>
    <!-- CSS files -->
    <link href="<?php echo e(asset('css/tabler.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/tabler-flags.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/tabler-payments.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/tabler-vendors.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/demo.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables.bootstrap4.min.css')); ?>">
</head>

<body class="antialiased" data-bs-theme="<?php echo e(Auth::user()->choosed_theme == 'light' ? 'light' : 'dark'); ?>"
    dir="<?php echo e((App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he') ? 'rtl' : 'ltr')); ?>">

    <?php
    use App\Setting;
    $settings = Setting::where('status', 1)->first();
    ?>

    
    <div class="page page-center preloader-wrapper">
        <div class="container container-slim py-4">
            <div class="text-center">
                <div class="mb-3">
                    <a href="." class="navbar-brand navbar-brand-autodark"><img src="<?php echo e(asset($settings->favicon)); ?>"
                            height="36" alt="<?php echo e($settings->site_name); ?>"></a>
                </div>
                <div class="text-secondary mb-3"><?php echo e(__('Loading')); ?></div>
                <div class="progress progress-sm">
                    <div class="progress-bar progress-bar-indeterminate"></div>
                </div>
            </div>
        </div>
    </div>

    <div id="app">
        <?php echo $__env->make('admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.includes.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->yieldContent('body'); ?>
    </div>

    <script src="<?php echo e(asset('/vendor/translation/js/app.js')); ?>"></script>

    <!-- Tabler Core -->
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/tabler.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/datatable.js')); ?>"></script>
    
    <script>
        $(document).ready(function() {
            "use strict";
            $('.preloader-wrapper').fadeOut();
        });
        // Choose langages
        $('#chooseLang').change(function () {
            "use strict";
            // set the window's location property to the value of the option the user has selected
            window.location = `?change_language=` + $(this).val();
        });
    </script>
</body>

</html><?php /**PATH /home/betvscaa/public_html/vendor/joedixon/laravel-translation/src/../resources/views/layout.blade.php ENDPATH**/ ?>