


<?php $__env->startSection('css'); ?>
    <style>
        .icon-color {
            color: forestgreen;
            font-size: 20px;
            display: inline;
        }

        .ti {
            font-size: 16px !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Plans')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>

        <div class="page-body">
            <div class="container-fluid">
                
                <?php if(Session::has("failed")): ?>
                <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('failed')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                
                <?php if(Session::has("success")): ?>
                <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>
            
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h3 class="card-title"><?php echo e(__('My plan')); ?></h3>

                            <?php if(isset($active_plan)): ?>

                                <?php if($active_plan->plan_price == 0): ?>
                                    <p class="text-uppercase"><b><?php echo e(__($active_plan->plan_name)); ?></b></p>
                                    <p><?php echo e(__('FREE PLAN')); ?></p>
                                <?php else: ?>
                                    <p class="text-uppercase"><b><?php echo e(__($active_plan->plan_name)); ?></b></p>
                                    <?php if($active_plan->validity == 9999): ?>
                                        <p><?php echo e(__('Lifetime')); ?></p>
                                    <?php else: ?>
                                        <p><?php echo e($remaining_days > 0 ? __('Remaining Days') . ' : ' . $remaining_days : __('Plan Expired!')); ?>

                                        </p>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <div class="card-text">
                                    <?php if($free_plan == 0 || $active_plan->plan_price != 0): ?>
                                        <a href="<?php echo e(route('user.checkout', $active_plan->plan_id)); ?>" class="btn">
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                class="icon icon-tabler icon-tabler-rotate" width="24" height="24"
                                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                                stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                                <path d="M19.95 11a8 8 0 1 0 -.5 4m.5 5v-5h-5"></path>
                                            </svg>
                                            <?php echo e(__('Renew')); ?>

                                        </a>
                                    <?php endif; ?>
                                    <a href="#plans" class="btn btn-primary">
                                        <svg xmlns="http://www.w3.org/2000/svg"
                                            class="icon icon-tabler icon-tabler-circle-arrow-up-filled" width="24"
                                            height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                            fill="none" stroke-linecap="round" stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <path
                                                d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-4.98 3.66l-.163 .01l-.086 .016l-.142 .045l-.113 .054l-.07 .043l-.095 .071l-.058 .054l-4 4l-.083 .094a1 1 0 0 0 1.497 1.32l2.293 -2.293v5.586l.007 .117a1 1 0 0 0 1.993 -.117v-5.585l2.293 2.292l.094 .083a1 1 0 0 0 1.32 -1.497l-4 -4l-.082 -.073l-.089 -.064l-.113 -.062l-.081 -.034l-.113 -.034l-.112 -.02l-.098 -.006z"
                                                stroke-width="0" fill="currentColor"></path>
                                        </svg>
                                        <?php echo e(__('Upgrade')); ?>

                                    </a>
                                </div>
                            <?php else: ?>
                                <p><?php echo e(__('No active plans!')); ?></p>

                                <div class="card-text">
                                    <a href="#plans" class="btn btn-primary"><?php echo e(__('Choose plan')); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div id="plans" class="page-body">
                <div class="container-fluid">

                    <div class="row">

                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-sm-6 col-lg-4 mb-3">
                                <div class="card card-md">

                                    <?php if($plan->recommended == '1'): ?>
                                        <div class="ribbon ribbon-top ribbon-bookmark bg-green">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-filled" width="24"
                                                height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor"
                                                fill="none" stroke-linecap="round" stroke-linejoin="round">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M12 17.75l-6.172 3.245l1.179 -6.873l-5 -4.867l6.9 -1l3.086 -6.253l3.086 6.253l6.9 1l-5 4.867l1.179 6.873z" />
                                            </svg>
                                        </div>
                                    <?php endif; ?>

                                    <div class="card-body">
                                        <span
                                            class="badge bg-primary text-white"><?php echo e(__($plan->plan_type == 'BOTH' ? 'VCARD & STORE' : $plan->plan_type)); ?></span>
                                        <div class="text-capitalize font-weight-bold h2"><?php echo e(__($plan->plan_name)); ?></div>
                                        <div class="my-3">
                                            <h3 class="display-4">
                                                <strong>
                                                    <?php echo e($plan->plan_price == '0' ? '' : $currency->symbol); ?><?php echo e($plan->plan_price == '0' ? __('FREE') : formatCurrency($plan->plan_price)); ?>

                                                </strong>
                                            </h3>

                                            <small class="text-capitalize">
                                                <?php if($plan->validity == '9999'): ?>
                                                    <?php echo e(__('Per')); ?> <?php echo e(__('Forever')); ?>

                                                <?php endif; ?>
                                                <?php if($plan->validity == '31'): ?>
                                                    <?php echo e(__('Per')); ?> <?php echo e(__('Month')); ?></span>
                                                <?php endif; ?>
                                                <?php if($plan->validity == '366'): ?>
                                                    <?php echo e(__('Per')); ?> <?php echo e(__('Year')); ?></span>
                                                <?php endif; ?>
                                                <?php if($plan->validity > '1' && $plan->validity != '31' && $plan->validity != '366' && $plan->validity != '9999'): ?>
                                                    <?php echo e(__('Per') . ' ' . $plan->validity . ' ' . __('Days')); ?>

                                                <?php endif; ?>
                                            </small>
                                        </div>
                                        <hr>
                                        <p class="mt-3"><?php echo e(__($plan->plan_description)); ?></p>
                                        <ul class="list-unstyled lh-lg">
                                            
                                            <?php if($plan->plan_type == 'BOTH' || $plan->plan_type == 'VCARD'): ?>
                                                <h4 class="mb-3 text-primary"><?php echo e(__('vCard Features')); ?></h4>

                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_vcards > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_vcards == 999 ? __('Unlimited') : $plan->no_of_vcards); ?>

                                                        <?php echo e(__('vCards')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_services > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_services == 999 ? __('Unlimited') : $plan->no_of_services); ?>

                                                        <?php echo e(__('Services')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_vcard_products > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_vcard_products == 999 ? __('Unlimited') : $plan->no_of_vcard_products); ?>

                                                        <?php echo e(__('Products')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_links > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_links == 999 ? __('Unlimited') : $plan->no_of_links); ?>

                                                        <?php echo e(__('Links')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_payments > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_payments == 999 ? __('Unlimited') : $plan->no_of_payments); ?>

                                                        <?php echo e(__('Payment Listed')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_galleries > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_galleries == 999 ? __('Unlimited') : $plan->no_of_galleries); ?>

                                                        <?php echo e(__('Galleries')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_testimonials > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_testimonials == 999 ? __('Unlimited') : $plan->no_testimonials); ?>

                                                        <?php echo e(__('Testimonials')); ?></strong></li>
                                                <li><i
                                                        class="ti ti-<?php echo e(__($plan->business_hours == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->business_hours == 1 ? 'green' : 'red'); ?>"></i>
                                                    <strong><?php echo e(__('Business Hours')); ?></strong></li>
                                                <li><i
                                                        class="ti ti-<?php echo e(__($plan->appointment == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->appointment == 1 ? 'green' : 'red'); ?>"></i>
                                                    <strong><?php echo e(__('Appointments')); ?></strong><span class="badge bg-green text-green-fg mx-1"><?php echo e(__('New')); ?></span></li>
                                                <li><i
                                                        class="ti ti-<?php echo e(__($plan->contact_form == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->contact_form == 1 ? 'green' : 'red'); ?>"></i>
                                                    <strong><?php echo e(__('Contact Form')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_enquires > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_enquires == 999 ? __('Unlimited') : $plan->no_of_enquires); ?>

                                                        <strong><?php echo e(__('Enquiries')); ?></strong></li>
                                                <li><i
                                                        class="ti ti-<?php echo e(__($plan->password_protected == 1 ? 'check text-green' : 'x text-red')); ?>"></i>
                                                    <?php echo e(__('Password Protected')); ?></strong></li>
                                            <?php endif; ?>

                                            
                                            <?php if($plan->plan_type == 'BOTH' || $plan->plan_type == 'STORE'): ?>
                                                <h4 class="mt-3 mb-3 text-primary"><?php echo e(__('Store Features')); ?></h4>

                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_stores > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_stores == '999' ? __('Unlimited') : $plan->no_of_stores); ?>

                                                        <?php echo e(__('Stores')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_categories > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_categories == '999' ? __('Unlimited') : $plan->no_of_categories); ?>

                                                        <?php echo e(__('Categories')); ?></strong></li>
                                                <li><i class="ti ti-<?php echo e(__($plan->no_of_store_products > 0 ? 'check text-green' : 'x text-red')); ?> me-1"></i><strong><?php echo e($plan->no_of_store_products == '999' ? __('Unlimited') : $plan->no_of_store_products); ?>

                                                        <?php echo e(__('Products')); ?></strong></li>
                                            <?php endif; ?>

                                            
                                            <h4 class="mt-3 mb-3 text-primary"><?php echo e(__('Additional Features')); ?></h4>
                                            <li><i
                                                class="ti ti-<?php echo e(__($plan->custom_domain == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->custom_domain == 1 ? 'green' : 'red'); ?>"></i>
                                            <strong><?php echo e(__('Custom Domain')); ?></strong><span class="badge bg-green text-green-fg mx-1"><?php echo e(__('New')); ?></span></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->advanced_settings == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->advanced_settings == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Advanced Settings')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->pwa == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->pwa == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Progressive Web App (PWA)')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->personalized_link == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->personalized_link == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Personalized Link')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->additional_tools == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->additional_tools == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Additional Tools')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->hide_branding == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->hide_branding == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Hide Branding')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->free_setup == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->free_setup == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Free Setup')); ?></strong></li>
                                            <li><i
                                                    class="ti ti-<?php echo e(__($plan->free_support == 1 ? 'check' : 'x')); ?> text-<?php echo e($plan->free_support == 1 ? 'green' : 'red'); ?>"></i>
                                                <strong><?php echo e(__('Free Support')); ?></strong></li>
                                        </ul>
                                        <div class="text-center mt-4">
                                            <?php if($free_plan == 0 || $plan->plan_price != '0'): ?>
                                                <a class="open-plan-model btn btn-outline-primary w-100"
                                                    data-id="<?php echo e($plan->plan_id); ?>"
                                                    href="#openPlanModel"><?php echo e(__('Choose plan')); ?></a>
                                            <?php else: ?>
                                                <a class="down-plan-model btn btn-outline-primary w-100"
                                                    data-id="<?php echo e($plan->plan_id); ?>"
                                                    href="#downPlanModel"><?php echo e(__('Choose plan')); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>
        </div>
        <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <div class="modal modal-blur fade" id="planModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                    <div>
                        <?php echo e(__('If you upgrade or downgrade from your current plan, It will temporarily disable your old cards. You need to enable it manually.')); ?>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-outline-primary me-auto"
                        data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                    <a class="btn btn-danger" id="plan_id"><?php echo e(__('Yes, proceed')); ?></a>
                </div>
            </div>
        </div>
    </div>

    <div class="modal modal-blur fade" id="downPlanModel" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="modal-title text-muted"><?php echo e(__('UNABLE TO DOWNGRADE')); ?></div>
                    <div class="mb-2"><?php echo e(__("Because you are already activated the 'Free' plan.")); ?></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger me-auto"
                        data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/plans/plans.blade.php ENDPATH**/ ?>