

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Change Plan in Customer')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <form action="<?php echo e(route('admin.update.customer.plan')); ?>" method="post" class="card">
                        <?php echo csrf_field(); ?>
                        <div class="card-header">
                            <h4 class="page-title"><?php echo e(__('Change Plan')); ?></h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="row">
                                        <input type="hidden" class="form-control" name="user_id"
                                            placeholder="<?php echo e(__('User ID')); ?>" value="<?php echo e($user_details->user_id); ?>"
                                            readonly>
                                        <div class="col-md-6 col-xl-4">
                                            <div class="mb-3">
                                                <label class="form-label required" for="plan_id"><?php echo e(__('Plans')); ?></label>
                                                <select name="plan_id" id="plan_id" class="form-control" required>
                                                    <option value='' disabled selected><?php echo e(__('Choose a plan')); ?></option>
                                                    <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($plan->plan_id); ?>" <?php echo e($plan->plan_id == $user_details->plan_id ? 'selected' : ''); ?>>
                                                        <?php if($plan->plan_price == '0'): ?>
                                                            <?php echo e(__($plan->plan_name)); ?> (<?php echo e(__('Free')); ?>)
                                                        <?php else: ?>
                                                            <?php echo e(__($plan->plan_name)); ?> (<?php echo e($config[1]->config_value); ?> <?php echo e(formatCurrency($plan->plan_price)); ?>)
                                                        <?php endif; ?>
                                                    </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/customers/change-plan.blade.php ENDPATH**/ ?>