


<?php $__env->startSection('custom-script'); ?>
    
    <?php if($settings->adsense_code != 'DISABLE'): ?>
        
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>"
            crossorigin="anonymous"></script>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    
    <section class="py-10 overflow-hidden">
        <div class="container px-4 mx-auto">
            <div class="max-w-xs md:max-w-2xl xl:max-w-7xl mx-auto">
                <div class="md:max-w-full mb-10 md:mb-10">
                    <h2 class="mb-5 font-heading font-semibold text-6xl sm:text-7xl text-gray-900"><?php echo e(__('Blogs')); ?></h2>
                    <p class="text-gray-600 text-md"><?php echo e(__('Discover the All-in-One Solution to Manage Contacts, Share Business Info, and Boost Sales - Start Growing Your Business Today!')); ?></p>
                </div>
                <div class="flex flex-wrap -mx-4 -mb-12">
                    
                    <?php if(count($blogs) > 0): ?>
                        <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="w-full md:w-1/2 xl:w-1/3 p-4 mb-12 border-r border-gray-100 shadow shadow-lg rounded-lg">
                                <a class="block group" href="<?php echo e(route('view.blog', $blog->slug)); ?>">
                                    <img class="block w-full h-50 mb-4" src="<?php echo e(asset($blog->cover_image)); ?>"
                                        alt="<?php echo e($blog->heading); ?>">
                                    <div class="flex inline">
                                        <span
                                            class="block text-gray-500 mb-2"><?php echo e(Carbon\Carbon::parse($blog->created_at)->format('d M Y')); ?></span>
                                    </div>
                                    <h4 class="text-xl font-semibold text-gray-900 group-hover:text-orange-900 mb-4">
                                        <?php echo e($blog->heading); ?></h4>
                                    <p class="text-gray-500"><?php echo e($blog->short_description); ?></p>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div class="w-full px-4 py-12">
                            <h3
                                class="mb-4 text-3xl md:text-4xl leading-tight text-darkCoolGray-900 font-bold tracking-tighter">
                                <?php echo e(__('No blog posts found!')); ?></h3>
                        </div>
                    <?php endif; ?>
                </div>

                
                <div class="text-center">
                    <?php echo e($blogs->links('vendor.pagination.blog')); ?>

                </div>
            </div>
        </div>
    </section>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.index', ['nav' => true, 'banner' => false, 'footer' => true, 'cookie' => true, 'setting' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/website/pages/blogs/index.blade.php ENDPATH**/ ?>