

<?php $__env->startSection('css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/all.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(asset('css/bootstrap-iconpicker.min.css')); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="card">
                <div class="row g-0">
                    <div class="col-12 col-md-3 border-end">
                        <div class="card-body">
                            <h4 class="subheader"><?php echo e(__('Update Business Card')); ?></h4>
                            <div class="list-group list-group-transparent">
                                
                                <?php echo $__env->make('user.pages.edit-cards.includes.nav-link', ['link' => 'payments'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-9 d-flex flex-column">
                        <form action="<?php echo e(route('user.update.payment.links', Request::segment(3))); ?>" method="post" id="myForm">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <h3 class="card-title mb-4"><?php echo e(__('Payment Links')); ?></h3>

                                <div class="row">
                                    
                                    <?php for($i = 0; $i < count($payments); $i++): ?> 
                                    <div class="row" id="<?php echo e($i); ?>">
                                        <div class='col-lg-6 col-md-6'>
                                            <div class='mb-3 mt-2'>
                                                <label class='form-label required'><?php echo e(__('Icon')); ?></label>
                                                <div class='input-group'>
                                                    <input type='text' class='form-control'
                                                        placeholder='<?php echo e(__('Choose Icon')); ?>' id='iconpick<?php echo e($i); ?>'
                                                        onclick='openPicker(<?php echo e($i); ?>)' name='icon[]'
                                                        value="<?php echo e($payments[$i]->icon); ?>" readonly required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class='col-lg-6 col-md-6'>
                                            <div class='mb-3 mt-2'>
                                                <label class='form-label required'
                                                    for='type'><?php echo e(__('Display type')); ?></label>
                                                <select name='type[]' id='type'
                                                    class='type<?php echo e($payments[$i]->id); ?> form-control type'
                                                    onchange='changeLabel(<?php echo e($payments[$i]->id); ?>)' required>
                                                    <option value='' disabled selected><?php echo e(__('Choose Type')); ?>

                                                    </option>
                                                    <option value='text'
                                                        <?php echo e($payments[$i]->type == 'text' || $payments[$i]->type == 'textarea' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Default')); ?></option>
                                                    <option value='upi'
                                                        <?php echo e($payments[$i]->type == 'upi' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('UPI')); ?></option>
                                                    <option value='url'
                                                        <?php echo e($payments[$i]->type == 'url' ? 'selected' : ''); ?>>
                                                        <?php echo e(__('Link')); ?></option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class='col-lg-6 col-md-6'>
                                            <div class='mb-3 mt-2'>
                                                <label class='form-label required'><?php echo e(__('Label')); ?></label>
                                                <input type='text' class='lbl<?php echo e($payments[$i]->id); ?> form-control'
                                                    name='label[]' placeholder='<?php echo e(__('Label')); ?>'
                                                    value="<?php echo e($payments[$i]->label); ?>" required>
                                            </div>
                                        </div>
                                        <div class='col-lg-5 col-md-5'>
                                            <div class='mb-3 mt-2'>
                                                <label class='form-label required'><?php echo e(__('Content')); ?></label>
                                                <textarea type="text"
                                                    class='textlbl<?php echo e($payments[$i]->id); ?> form-control'
                                                    name='value[]' placeholder='<?php echo e(__('Type something')); ?>' cols="30" rows="2" required><?php echo e($payments[$i]->content); ?></textarea>
                                            </div>
                                        </div>
                                        <div class='col-lg-1 col-md-1'>
                                            <div class='mb-3 pt-1 mt-5'>
                                                <button class='btn btn-danger btn-sm'
                                                    onclick='removePayment(<?php echo e($i); ?>)'>
                                                    <i class='fa fa-times text-whte'></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endfor; ?>

                                    
                                    <div id="more-payments" class="row"></div>

                                    
                                    <div class="col-lg-12 mb-5">
                                        <button type="button" onclick="addPayment()" class="btn btn-primary">
                                            <?php echo e(__('Add One More Payments')); ?>

                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent mt-auto">
                                <div class="btn-list justify-content-end">
                                    <a href="<?php echo e(route('user.cards')); ?>" class="btn">
                                        <?php echo e(__('Cancel')); ?>

                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Submit')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startPush('custom-js'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
<script type="text/javascript" src="<?php echo e(asset('js/fontawesome-iconpicker.min.js')); ?>"></script>
<script>
    var count = <?php echo e(count($payments)); ?>;

    function addPayment() {
	"use strict";
    if (count>=<?php echo e($plan_details->no_of_payments); ?>) {
         new swal({
            title: `<?php echo e(__('Oops!')); ?>`,
            icon: 'warning',
            text: `<?php echo e(__('You have reached your current plan limit.')); ?>`,
            timer: 2000,
            buttons: false,
            showConfirmButton: false,
        });
    }
    else {
        count++;
        var id = getRandomInt();
        var payments = `
        <div class='row' id="${id}">
            <div class='col-lg-6 col-md-6'>
                <div class='mb-3 mt-2'>
                    <label class='form-label required'><?php echo e(__('Icon')); ?></label>
                    <div class='input-group'>
                        <input type='text' class='form-control' placeholder='<?php echo e(__('Choose Icon')); ?>' id='iconpick${id}' onclick='openPicker(${id})' name='icon[]' required readonly>
                    </div>
                </div>
            </div>
            <div class='col-lg-6 col-md-6'>
                <div class='mb-3 mt-2'>
                    <label class='form-label required' for='type'><?php echo e(__('Display type')); ?></label>
                    <select name='type[]' id='type' class='type${id} form-control type' onchange='changeLabel(${id})' required>
                        <option value='' disabled selected><?php echo e(__('Choose Type')); ?></option>
                        <option value='text'><?php echo e(__('Default')); ?></option>
                        <option value='upi'><?php echo e(__('UPI')); ?></option>
                        <option value='url'><?php echo e(__('Link')); ?></option>
                    </select>
                </div>
            </div>
            <div class='col-lg-6 col-md-6'>
                <div class='mb-3 mt-2'>
                    <label class='form-label required'><?php echo e(__('Label')); ?></label>
                    <input type='text' class='lbl${id} form-control' name='label[]' placeholder='<?php echo e(__('Label')); ?>' required>
                </div>
            </div>
            <div class='col-md-5 mt-1 col-lg-5'>
                <div class='mb-3'>
                    <label class='form-label required'><?php echo e(__('Content')); ?></label>
                    <textarea class='textlbl${id} form-control' name='value[]' cols='30' rows='2' placeholder='<?php echo e(__('Type something')); ?>' required></textarea>
                </div>
            </div>
            <div class='col-lg-1 col-md-1'>
                <div class='mb-2 pt-1 mt-5'>
                    <button class='btn btn-danger btn-sm' onclick='removePayment(${id})'>
                        <i class='fa fa-times text-white'></i>
                    </button>
                </div>
            </div>
        </div>`;
        $("#more-payments").append(payments).html();
    }
    }

    function removePayment(id) {
	"use strict";
        $("#"+id).remove();
        count--;
    }

    function getRandomInt() {
        min = Math.ceil(0);
        max = Math.floor(9999999999);
        return Math.floor(Math.random() * (max - min) + min); //The maximum is exclusive and the minimum is inclusive
    }

    function openPicker(id){
        "use strict";
        $("#iconpick"+id).iconpicker({ animation:true,hideOnSelect:true, placement: "inline",  templates: {    popover: '<div class="iconpicker-popover popover position-absolute"><div class="arrow"></div>' +
            '<div class="popover-title"></div><div class="popover-content"></div></div>', iconpickerItem: '<a role="button" class="iconpicker-item"><i></i></a>' } });
    }

    function changeLabel(id) {
        "use strict";
        var label = 'Label';
        var textlabel = 'Type Something';
        let lbl = document.querySelector('.lbl'+id);
        let textlbl = document.querySelector('.textlbl'+id);
        let type = document.querySelector('.type'+id).value;
        console.log(type);
        if(type == 'text') {
            label = `<?php echo e(__('Bank')); ?>`;
            textlabel = `<?php echo e(__('Your bank account details')); ?>`;
        } else if(type == 'upi') {
            label = `<?php echo e(__('UPI')); ?>`;
            textlabel = `<?php echo e(__('For ex: YOUR UPI ID')); ?>`;
        } else if(type == 'url') {
            label = `<?php echo e(__('Payment Link')); ?>`;
            textlabel = `<?php echo e(__('For ex: https://rzp.io/i/nxrHnLJ')); ?>`;
        }

        lbl.placeholder = label;
        textlbl.placeholder = textlabel;
    }

    document.getElementById("myForm").onkeypress = function(e) {
        var key = e.charCode || e.keyCode || 0;     
        if (key == 13) {
        e.preventDefault();
        }
    }
</script>
<script>
    // Array of element selectors
    var elementSelectors = ['.type'];

    // Function to initialize TomSelect on an element
    function initializeTomSelect(el) {
        new TomSelect(el, {
            copyClassesToDropdown: false,
            dropdownClass: 'dropdown-menu ts-dropdown',
            optionClass: 'dropdown-item',
            controlInput: '<input>',
            maxOptions: null,
            render: {
                item: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
                option: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
            },
        });
    }

    // Initialize TomSelect on existing elements
    elementSelectors.forEach(function(selector) {
        var elements = document.querySelectorAll(selector);
        elements.forEach(function(el) {
            initializeTomSelect(el);
        });
    });

    // Observe the document for dynamically added elements
    var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            mutation.addedNodes.forEach(function(node) {
                if (node.nodeType === 1) { // Ensure it's an element node
                    elementSelectors.forEach(function(selector) {
                        if (node.matches(selector)) {
                            initializeTomSelect(node);
                        }
                        // Also check if new nodes have children that match
                        var childElements = node.querySelectorAll(selector);
                        childElements.forEach(function(childEl) {
                            initializeTomSelect(childEl);
                        });
                    });
                }
            });
        });
    });

    // Configure the observer
    observer.observe(document.body, { childList: true, subtree: true });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/edit-payment-links.blade.php ENDPATH**/ ?>