

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('My Account')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="card">
                            <div class="card-body p-4 text-center">
                                <span class="avatar avatar-xl mb-3 bg-white">
                                    <img src="<?php echo e(asset(auth()->user()->profile_image == null ? 'img/favicon.png' : auth()->user()->profile_image)); ?>"
                                        alt="<?php echo e(auth()->user()->name); ?>">
                                </span>
                                <h3 class="m-0 mb-1"><?php echo e(__($account_details->name)); ?></h3>
                                <div>
                                    <?php echo e($account_details->email == '' ? __('Not Available') : $account_details->email); ?>

                                </div>
                                <div class="mt-3">
                                    <span class="badge bg-green text-white"><?php echo e($account_details->role_id == 4 ? __('Manager') : __('Administrator')); ?></span>
                                </div>
                            </div>
                            <div class="d-flex"> 
                                <a href="<?php echo e(route('admin.edit.account')); ?>" class="card-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                        class="icon icon-tabler me-2 icon-tabler-edit" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <path d="M9 7h-3a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-3"></path>
                                        <path d="M9 15h3l8.5 -8.5a1.5 1.5 0 0 0 -3 -3l-8.5 8.5v3"></path>
                                        <line x1="16" y1="5" x2="19" y2="8"></line>
                                    </svg>
                                    <?php echo e(__('Edit')); ?></a>
                                <a href="<?php echo e(route('admin.change.password')); ?>" class="card-btn">
                                    <svg xmlns="http://www.w3.org/2000/svg"
                                        class="icon icon-tabler me-2 icon-tabler-key" width="24" height="24"
                                        viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                        stroke-linecap="round" stroke-linejoin="round">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                        <circle cx="8" cy="15" r="4"></circle>
                                        <line x1="10.85" y1="12.15" x2="19" y2="4"></line>
                                        <line x1="18" y1="5" x2="20" y2="7"></line>
                                        <line x1="15" y1="8" x2="17" y2="10"></line>
                                    </svg>
                                    <?php echo e(__('Change Password')); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/account/account.blade.php ENDPATH**/ ?>