<?php
use Illuminate\Support\Str;

if (app()->getLocale() == null) {
    Session::put('locale', $business_card_details->card_lang);
    app()->setLocale(Session::get('locale'));
}
?>


<?php if(count(config('app.languages')) > 1): ?>
<div class="nav-item dropdown mx-2">
    <div class="lang">
        <select type="text" class="form-select small-btn" placeholder="<?php echo e(__('Select a language')); ?>" id="language" value="">
            <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($langLocale); ?>" <?php echo e(app()->getLocale() == $langLocale ? 'selected' : ''); ?>><strong><?php echo e(Str::upper($langLocale)); ?></strong></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>
<?php endif; ?>


<?php $__env->startSection('custom-js'); ?>
<script>
// Language switcher
$(document).ready(function() {
    "use strict";
    // Language switcher
    $('#language').change(function() {
        var selectedLocale = $(this).val();

        $.ajax({
            url: "<?php echo e(route('set.locale')); ?>",  // Use the route name defined earlier
            type: "POST",
            data: {
                locale: selectedLocale,
                _token: '<?php echo e(csrf_token()); ?>' // Include CSRF token
            },
            success: function(response) {
                console.log(response.message); // Log success message
                // Redirect page
                window.location = ``;
            },
            error: function(xhr) {
                console.error(xhr.responseText); // Log error message
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/templates/includes/bs-language-switcher.blade.php ENDPATH**/ ?>