


<?php $__env->startSection('css'); ?>
<script type="text/javascript" src="<?php echo e(asset('js/tom-select.base.min.js')); ?>"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.0.1/tinymce.min.js" integrity="sha512-KGtsnWohFUg0oksKq7p7eDgA1Rw2nBfqhGJn463/rGhtUY825dBqGexj8eP04LwfnsSW6dNAHAlOqKJKquHsnw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title mb-2">
                        <?php echo e(__('Settings')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">

            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <div class="card">
                <div class="card-body">
                    <div class="accordion" id="accordion-example">
                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-1">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-1" aria-expanded="false">
                                    <h2><?php echo e(__('General Configuration Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-1" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.general.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            
                                            <div class=" col-xl-4 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="show_website"><?php echo e(__('Show Website Front-end?')); ?></label>
                                                    <select name="show_website" id="show_website" class="form-select" required>
                                                        <option value="yes" <?php echo e($config[38]->config_value == 'yes' ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                        <option value="no" <?php echo e($config[38]->config_value == 'no' ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                    </select>
                                                    <small class="text-muted"><span><?php echo e(__('Note')); ?></span>: <?php echo e(__('Turn on or off your website.')); ?></small>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="timezone"><?php echo e(__('Timezone')); ?></label>
                                                    <select name="timezone" id="timezone" class="form-select" required>
                                                        <?php $__currentLoopData = timezone_identifiers_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($timezone); ?>" <?php echo e($config[2]->config_value
                                                            ==
                                                            $timezone ? 'selected' : ''); ?>>
                                                            <?php echo e($timezone); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="currency"><?php echo e(__('Currency')); ?></label>
                                                    <select name="currency" id="currency" class="form-select" required>
                                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($currency->iso_code); ?>" <?php echo e($config[1]->config_value == $currency->iso_code ? 'selected' : ''); ?>>
                                                            <?php echo e($currency->name); ?> (<?php echo e($currency->symbol); ?>)</option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4 col-12">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="currency_format"><?php echo e(__('Currency Format')); ?></label>
                                                    <select name="currency_format" id="currency_format" class="form-select" required>
                                                        <option value="1,234,567.89" <?php echo e($config[55]->config_value == "1,234,567.89" ? 'selected' : ''); ?>><?php echo e(__("1,234,567.89")); ?></option>
                                                        <option value="1.234.567,89" <?php echo e($config[55]->config_value == "1.234.567,89" ? 'selected' : ''); ?>><?php echo e(__("1.234.567,89")); ?></option>
                                                        <option value="1 234 567,89" <?php echo e($config[55]->config_value == "1 234 567,89" ? 'selected' : ''); ?>><?php echo e(__("1 234 567,89")); ?></option>
                                                        <option value="1'234'567.89" <?php echo e($config[55]->config_value == "1'234'567.89" ? 'selected' : ''); ?>><?php echo e(__("1'234'567.89")); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4 mb-2">
                                                <div class="mb-3">
                                                    <label class="form-label required" for="currency_decimals_place"><?php echo e(__('Decimals Places')); ?></label>
                                                    <input type="number" class="form-control" name="currency_decimals_place" id="currency_decimals_place" value="<?php echo e($config[56]->config_value); ?>" placeholder="<?php echo e(__('Decimals Places')); ?>" min="0" step="1" max="3" required>
                                                    <small><?php echo e(__('If you don\'t need decimal vale, set 0')); ?></small>
                                                </div>
                                            </div>

                                            <div class=" col-xl-4 mb-2"></div>

                                            <br>
                                            
                                            <div class=" col-xl-4">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Default Plan Term Settings')); ?>

                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label required" for="term"><?php echo e(__('Default Plan Term')); ?></label>
                                                    <select name="term" id="term" class="form-select" required>
                                                        <option value="monthly" <?php echo e($config[8]->config_value ==
                                                            'monthly'
                                                            ? '
                                                           selected' : ''); ?>>
                                                            <?php echo e(__('Monthly')); ?></option>
                                                        <option value="yearly" <?php echo e($config[8]->config_value ==
                                                            'yearly' ?
                                                            '
                                                           selected' : ''); ?>>
                                                            <?php echo e(__('Yearly')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Cookie Consent Settings')); ?>

                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label required" for="cookie"><?php echo e(__('Cookie Consent')); ?></label>
                                                    <select name="cookie" id="cookie" class="form-select" required>
                                                        <option value="true" <?php echo e(env('COOKIE_CONSENT_ENABLED') == true ? 'selected' : ''); ?>><?php echo e(__('Enable')); ?></option>
                                                        <option value="false" <?php echo e(env('COOKIE_CONSENT_ENABLED') == false || env('COOKIE_CONSENT_ENABLED') == '' ? 'selected' : ''); ?>><?php echo e(__('Disable')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4 mb-2">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Image Upload Limit')); ?>

                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label" for="image_limit"><?php echo e(__('Size in Megabytes')); ?>

                                                    </label>
                                                    <input type="number" class="form-control" name="image_limit"
                                                        value="<?php echo e($settings->image_limit['SIZE_LIMIT']); ?>"
                                                        placeholder="<?php echo e(__('Size')); ?>" min="1024">
                                                </div>
                                            </div>

                                            <div class="row">
                                                
                                                <div class="col-md-6 col-xl-6">
                                                    <h2 class="page-title my-3">
                                                        <?php echo e(__('Tawk.to Chatbot Settings')); ?>

                                                    </h2>
                                                    <div class="mb-3">
                                                        <label class="form-label"><?php echo e(__('Tawk.to Chatbot URL (s1.src)')); ?></label>
                                                        <div class="input-group">
                                                            <span class="input-group-text">
                                                                <?php echo e(__('https://embed.tawk.to/')); ?>

                                                            </span>
                                                            <input type="text" class="form-control" name="tawk_chat_bot_key"
                                                                value="<?php echo e($settings->tawk_chat_bot_key); ?>"
                                                                placeholder="<?php echo e(__('Tawk Chat Key')); ?>" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>

                                                
                                                <div class="col-md-6 col-xl-6 mb-2 d-none">
                                                    <h2 class="page-title my-3">
                                                        <?php echo e(__('Tiny Cloud (Text Editor) Configuration Settings')); ?>

                                                    </h2>
                                                    <div class="mb-3">
                                                        <label class="form-label required" for="tiny_api_key"><?php echo e(__('Tiny Cloud API Key')); ?>

                                                        </label>
                                                        <input type="text" class="form-control" name="tiny_api_key"
                                                            value="<?php echo e($config[39]->config_value); ?>"
                                                            placeholder="<?php echo e(__('Tiny Cloud API Key (Eg: ytf5**************************)')); ?>"
                                                            required>
                                                        <span><?php echo e(__('If you did not get a Tiny Cloud API Key, create a')); ?> <a href="https://www.tiny.cloud/my-account/dashboard"
                                                                rel="nofollow" target="_blank"><?php echo e(__('new API Key.')); ?></a> </span>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class="row">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('WhatsApp Chat Button Settings')); ?>

                                                </h2>
                                                <div class="col-xl-4 col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label required" for="show_whatsapp_chatbot"><?php echo e(__('Want to display whatsapp chat button on website?')); ?></label>
                                                        <select name="show_whatsapp_chatbot" id="show_whatsapp_chatbot" class="form-select"
                                                            required>
                                                            <option value="1" <?php echo e($config[40]->config_value == '1'
                                                                ? 'selected' : ''); ?>>
                                                                <?php echo e(__('Yes')); ?></option>
                                                            <option value="0" <?php echo e($config[40]->config_value == '0'
                                                                ? 'selected' : ''); ?>>
                                                                <?php echo e(__('No')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xl-4 col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label required"><?php echo e(__('WhatsApp Number')); ?></label>
                                                        <input type="tel" class="form-control" name="whatsapp_chatbot_mobile_number" value="<?php echo e($config[41]->config_value); ?>" placeholder="<?php echo e(__('WhatsApp Number')); ?>" oninput="javascript: if (this.value.length > 20) this.value = this.value.slice(0, 20); this.value = this.value.replace(/[^0-9]/g, '');">
                                                        <small><?php echo e(__('Note : With Country code (without +)')); ?></small>
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xl-4 col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label required"><?php echo e(__('Initial Chat Message')); ?></label>
                                                        <textarea class="form-control" name="whatsapp_chatbot_message" id="whatsapp_chatbot_message" cols="30" rows="2" placeholder="<?php echo e(__('Initial Chat Message')); ?>" required><?php echo e($config[42]->config_value); ?></textarea>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class="row">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Share Content Settings')); ?>

                                                </h2>

                                                <div class="col-xl-6">
                                                    <div class="mb-3">
                                                        <label class="form-label required"><?php echo e(__('Share Content')); ?></label>
                                                        <textarea class="form-control" name="share_content"
                                                            id="share_content" cols="10" rows="3"
                                                            placeholder="<?php echo e(__('Share Content')); ?>"
                                                            required><?php echo e($config[30]->config_value); ?></textarea>
                                                    </div>
                                                </div>

                                                
                                                <div class="col-xl-6 mt-3">
                                                    <h2 class="page-title my-3"> <?php echo e(__('Short codes :')); ?> </h2>
                                                    <span><span class="font-weight-bold">{ business_name }</span> - <?php echo e(__('Business Name')); ?></span><br>
                                                    <span><span class="font-weight-bold">{ business_url }</span> - <?php echo e(__('Business URL or Address')); ?></span><br>
                                                    <span><span class="font-weight-bold">{ appName }</span> - <?php echo e(__('App
                                                        Name')); ?></span>
                                                </div>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-2">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-2" aria-expanded="false">
                                    <h2><?php echo e(__('Website Configuration Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-2" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.website.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">

                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Theme Colors')); ?></label>
                                                    <div class="row g-2">

                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="blue"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'blue' ? 'checked'
                                                                : ''); ?>

                                                                />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-blue"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput form-colorinput-light">
                                                                <input name="app_theme" type="radio" value="indigo"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'indigo' ?
                                                                'checked' :
                                                                ''); ?> />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-indigo"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="green"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'green' ? 'checked'
                                                                :
                                                                ''); ?>

                                                                />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-green"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="yellow"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'yellow' ?
                                                                'checked' :
                                                                ''); ?> />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-yellow"></span>
                                                            </label>
                                                        </div>

                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="red"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'red' ? 'checked' :
                                                                ''); ?>

                                                                />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-red"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="purple"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'purple' ?
                                                                'checked' :
                                                                ''); ?> />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-purple"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput">
                                                                <input name="app_theme" type="radio" value="pink"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'pink' ? 'checked'
                                                                : ''); ?>

                                                                />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-pink"></span>
                                                            </label>
                                                        </div>
                                                        <div class="col-auto">
                                                            <label class="form-colorinput form-colorinput-light">
                                                                <input name="app_theme" type="radio" value="gray"
                                                                    class="form-colorinput-input" <?php echo e($config[11]->config_value == 'gray' ? 'checked'
                                                                : ''); ?>

                                                                />
                                                                <span
                                                                    class="form-colorinput-color rounded-circle bg-muted"></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <div class="form-label"><?php echo e(__('Banner Image')); ?></div>
                                                    <input type="file" class="form-control" name="primary_image"
                                                        placeholder="<?php echo e(__('Banner Image')); ?>"
                                                        accept=".png,.jpg,.jpeg,.gif,.svg" />
                                                    <small class="text-muted">
                                                        <?php echo e(__('Recommended size : 1000 x 667')); ?></small>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <div class="form-label"><?php echo e(__('Website Logo')); ?></div>
                                                    <input type="file" class="form-control" name="site_logo"
                                                        placeholder="<?php echo e(__('Website Logo')); ?>"
                                                        accept=".png,.jpg,.jpeg,.gif,.svg" />
                                                    <small class="text-muted">
                                                        <?php echo e(__('Recommended size : 200 x 90')); ?></small>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <div class="form-label"><?php echo e(__('Favicon')); ?></div>
                                                    <input type="file" class="form-control" name="favi_icon"
                                                        placeholder="<?php echo e(__('Favicon')); ?>"
                                                        accept=".png,.jpg,.jpeg,.gif,.svg" />
                                                    <small class="text-muted">
                                                        <?php echo e(__('Recommended size : 200 x 200')); ?></small>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('App Name')); ?></label>
                                                    <input type="text" class="form-control" name="app_name"
                                                        value="<?php echo e(config('app.name')); ?>" maxlength="50"
                                                        placeholder="<?php echo e(__('App Name')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Site Name')); ?></label>
                                                    <input type="text" class="form-control" name="site_name"
                                                        value="<?php echo e($settings->site_name); ?>"
                                                        placeholder="<?php echo e(__('Site Name')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-3">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-3" aria-expanded="false">
                                    <h2><?php echo e(__('Payment Methods Configuration Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-3" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.payments.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Paypal Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Mode' )); ?></label>
                                                    <select type="text" class="form-select"
                                                        placeholder="<?php echo e(__('Select a payment mode')); ?>" id="paypal_mode"
                                                        name="paypal_mode" required>
                                                        <option value="sandbox" <?php echo e($config[3]->config_value ==
                                                            'sandbox'
                                                            ?
                                                            'selected' : ''); ?>>
                                                            <?php echo e(__('Sandbox')); ?></option>
                                                        <option value="live" <?php echo e($config[3]->config_value == 'live' ?
                                                            'selected' : ''); ?>>
                                                            <?php echo e(__('Live')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Client Key')); ?></label>
                                                    <input type="text" class="form-control" name="paypal_client_key"
                                                        value="<?php echo e($config[4]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Client Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label" required><?php echo e(__('Secret')); ?></label>
                                                    <input type="text" class="form-control" name="paypal_secret"
                                                        value="<?php echo e($config[5]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Secret')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Razorpay Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Client Key')); ?></label>
                                                    <input type="text" class="form-control" name="razorpay_client_key"
                                                        value="<?php echo e($config[6]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Client Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Secret')); ?></label>
                                                    <input type="text" class="form-control" name="razorpay_secret"
                                                        value="<?php echo e($config[7]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Secret')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('PhonePe Settings')); ?>

                                            </h2>
                                            
                                            <div class="col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Merchant ID')); ?></label>
                                                    <input type="text" class="form-control" name="merchantId"
                                                        value="<?php echo e($config[44]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Merchant ID')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Salt Key')); ?></label>
                                                    <input type="text" class="form-control" name="saltKey"
                                                        value="<?php echo e($config[45]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Salt Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Stripe Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Publishable Key')); ?></label>
                                                    <input type="text" class="form-control"
                                                        name="stripe_publishable_key"
                                                        value="<?php echo e($config[9]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Publishable Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Secret')); ?></label>
                                                    <input type="text" class="form-control" name="stripe_secret"
                                                        value="<?php echo e($config[10]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Secret')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Paystack Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Public Key')); ?></label>
                                                    <input type="text" class="form-control" name="paystack_public_key"
                                                        value="<?php echo e($config[33]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Public Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Secret Key')); ?></label>
                                                    <input type="text" class="form-control" name="paystack_secret"
                                                        value="<?php echo e($config[34]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Secret Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Merchant Email')); ?></label>
                                                    <input type="text" class="form-control" name="merchant_email"
                                                        value="<?php echo e($config[36]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Merchant Email')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Mollie Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Key')); ?></label>
                                                    <input type="text" class="form-control" name="mollie_key"
                                                        value="<?php echo e($config[37]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Mercadopago Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Public Key')); ?></label>
                                                    <input type="text" class="form-control" name="mercado_pago_public_key"
                                                        value="<?php echo e($config[47]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Public Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Access Token')); ?></label>
                                                    <input type="text" class="form-control" name="mercado_pago_access_token"
                                                        value="<?php echo e($config[48]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Access Token')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Toyyibpay Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Mode' )); ?></label>
                                                    <select type="text" class="form-select"
                                                        placeholder="<?php echo e(__('Select a payment mode')); ?>" id="toyyibpay_mode"
                                                        name="toyyibpay_mode" required>
                                                        <option value="sandbox" <?php echo e($config[54]->config_value ==
                                                            'sandbox'
                                                            ?
                                                            'selected' : ''); ?>>
                                                            <?php echo e(__('Sandbox')); ?></option>
                                                        <option value="live" <?php echo e($config[54]->config_value == 'live' ?
                                                            'selected' : ''); ?>>
                                                            <?php echo e(__('Live')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('API Key')); ?></label>
                                                    <input type="text" class="form-control" name="toyyibpay_api_key"
                                                        value="<?php echo e($config[49]->config_value); ?>"
                                                        placeholder="<?php echo e(__('API Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Category Code')); ?></label>
                                                    <input type="text" class="form-control" name="toyyibpay_category_code"
                                                        value="<?php echo e($config[50]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Category Code')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Flutterwave Settings')); ?>

                                            </h2>
                                            
                                            <div class="col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Public Key')); ?></label>
                                                    <input type="text" class="form-control" name="flw_public_key"
                                                        value="<?php echo e($config[51]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Public Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Secret Key')); ?></label>
                                                    <input type="text" class="form-control" name="flw_secret_key"
                                                        value="<?php echo e($config[52]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Secret Key')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Encryption Key')); ?></label>
                                                    <input type="text" class="form-control" name="flw_encryption_key"
                                                        value="<?php echo e($config[53]->config_value); ?>"
                                                        placeholder="<?php echo e(__('Encryption Key')); ?>" required>
                                                </div>
                                            </div>

                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Offline (Bank Transfer) Settings')); ?>

                                            </h2>

                                            
                                            <div class="col-xl-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Offline (Bank Transfer) Details')); ?></label>
                                                    <textarea class="form-control" name="bank_transfer" id="bank_transfer" rows="3"
                                                        placeholder="<?php echo e(__('Offline (Bank Transfer) Details')); ?>"
                                                        required><?php echo e($config[31]->config_value); ?></textarea>
                                                </div>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-4">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-4" aria-expanded="false">
                                    <h2><?php echo e(__('Webtools and Google Configuration Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-4" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.google.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">

                                            
                                            <h2 class="page-title my-3">
                                                <?php echo e(__('Google reCAPTCHA Configuration Settings')); ?>

                                            </h2>
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <div class="form-label"><?php echo e(__('reCAPTCHA Enable')); ?></div>
                                                    <select class="form-select" placeholder="<?php echo e(__('Select a reCAPTCHA')); ?>" id="recaptcha_enable" name="recaptcha_enable">
                                                        <option value="on" <?php echo e($settings->recaptcha_configuration['RECAPTCHA_ENABLE'] == 'on' ? 'selected' : ''); ?>><?php echo e(__('On')); ?></option>
                                                        <option value="off" <?php echo e($settings->recaptcha_configuration['RECAPTCHA_ENABLE'] == 'off' ? 'selected' : ''); ?>><?php echo e(__('Off')); ?></option>
                                                    </select>
                                                </div>
                                                <span><?php echo e(__('If you did not get a reCAPTCHA (v2 Checkbox), create a')); ?>

                                                    <a href="https://www.google.com/recaptcha/about/" target="_blank"><?php echo e(__('reCAPTCHA')); ?></a> </span>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('reCAPTCHA Site Key')); ?></label>
                                                    <input type="text" class="form-control" name="recaptcha_site_key"
                                                        value="<?php echo e($settings->recaptcha_configuration['RECAPTCHA_SITE_KEY']); ?>"
                                                        placeholder="<?php echo e(__('reCAPTCHA Site Key')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('reCAPTCHA Secret Key')); ?></label>
                                                    <input type="text" class="form-control" name="recaptcha_secret_key"
                                                        value="<?php echo e($settings->recaptcha_configuration['RECAPTCHA_SECRET_KEY']); ?>"
                                                        placeholder="<?php echo e(__('reCAPTCHA Secret Key')); ?>">
                                                </div>
                                            </div>

                                            
                                            <h2 class="page-title my-4">
                                                <?php echo e(__('Google OAuth Configuration Settings')); ?>

                                            </h2>
                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <div class="form-label"><?php echo e(__('Google Auth Enable')); ?></div>
                                                    <select class="form-select"
                                                        placeholder="<?php echo e(__('Select a Google Auth Enable')); ?>"
                                                        id="google_auth_enable" name="google_auth_enable">
                                                        <option value="on" <?php echo e($settings->google_configuration['GOOGLE_ENABLE'] == 'on' ? 'selected' : ''); ?>><?php echo e(__('On')); ?></option>
                                                        <option value="off" <?php echo e($settings->google_configuration['GOOGLE_ENABLE'] == 'off' ? 'selected' : ''); ?>><?php echo e(__('Off')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Google Client ID')); ?></label>
                                                    <input type="text" class="form-control" name="google_client_id"
                                                        value="<?php echo e($settings->google_configuration['GOOGLE_CLIENT_ID']); ?>"
                                                        placeholder="<?php echo e(__('Google CLIENT ID')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Google Client Secret')); ?></label>
                                                    <input type="text" class="form-control" name="google_client_secret"
                                                        value="<?php echo e($settings->google_configuration['GOOGLE_CLIENT_SECRET']); ?>"
                                                        placeholder="<?php echo e(__('Google CLIENT Secret')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-3">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Google Redirect')); ?></label>
                                                    <input type="text" class="form-control" name="google_redirect"
                                                        value="<?php echo e($settings->google_configuration['GOOGLE_REDIRECT']); ?>"
                                                        placeholder="<?php echo e(__('Google Redirect')); ?>">
                                                </div>
                                            </div>
                                            <span><?php echo e(__('If you did not get a Google OAuth Client ID & Secret Key, follow a')); ?> <a
                                                    href="https://support.google.com/cloud/answer/6158849?hl=en#zippy=%2Cuser-consent%2Cpublic-and-internal-applications%2Cauthorized-domains/"
                                                    target="_blank"><?php echo e(__(' steps')); ?></a> </span>

                                            
                                            <div class="col-xl-12 mt-3">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Google Analytics Configuration Settings')); ?>

                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Google Analytics ID')); ?></label>
                                                    <div class="input-group mb-2">
                                                        <span class="input-group-text">
                                                            <?php echo e(__('https://www.googletagmanager.com/gtag/js?id=')); ?>

                                                        </span>
                                                        <input type="text" class="form-control "
                                                            name="google_analytics_id"
                                                            value="<?php echo e($settings->google_analytics_id); ?>"
                                                            placeholder="<?php echo e(__('Google Analytics ID')); ?>"
                                                            autocomplete="off">

                                                    </div>
                                                </div>
                                                <span><?php echo e(__('If you did not get a Google analytics id, create a')); ?>

                                                    <a href="https://analytics.google.com/analytics/web/"
                                                        target="_blank"><?php echo e(__('new analytics id.')); ?></a> </span>
                                            </div>

                                            
                                            <div class="col-xl-12 mt-3">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Webtools and Google AdSense Configuration Settings')); ?>

                                                </h2>
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Google AdSense code')); ?></label>
                                                    <div class="input-group mb-2">
                                                        <span class="input-group-text">
                                                            <?php echo e(__('https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=')); ?>

                                                        </span>
                                                        <input type="text" class="form-control "
                                                            name="google_adsense_code"
                                                            value="<?php echo e($settings->google_adsense_code); ?>"
                                                            placeholder="<?php echo e(__('Google AdSense code')); ?>"
                                                            autocomplete="off">
                                                    </div>
                                                    <small><?php echo e(__("Note")); ?> :</small><br>
                                                    <small><?php echo e(__("Type DISABLE_ADSENSE_ONLY for enable Webtools without AdSense")); ?></small><br>
                                                    <small><?php echo e(__("Enter your AdSense code for enable Webtools with AdSense")); ?></small><br>
                                                    <small><?php echo e(__("Type DISABLE_BOTH for disable Webtools & AdSense")); ?></small><br>
                                                </div>
                                                <span><?php echo e(__('If you did not get a Google AdSense code, create a')); ?>

                                                    <a href="https://www.google.com/adsense/new" target="_blank"><?php echo e(__('new AdSense code.')); ?></a> </span>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-5">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-5" aria-expanded="false">
                                    <h2><?php echo e(__('Email Configuration Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-5" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.email.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Sender Name')); ?></label>
                                                    <input type="text" class="form-control" name="mail_sender"
                                                        value="<?php echo e($settings->email_configuration['name']); ?>" maxlength="50"
                                                        placeholder="<?php echo e(__('Sender Name')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Sender Email Address')); ?></label>
                                                    <input type="text" class="form-control" name="mail_address"
                                                        value="<?php echo e($settings->email_configuration['address']); ?>"
                                                        placeholder="<?php echo e(__('Sender Email Address')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Mailer Driver')); ?></label>
                                                    <input type="text" class="form-control" name="mail_driver"
                                                        value="<?php echo e($settings->email_configuration['driver']); ?>"
                                                        placeholder="<?php echo e(__('Mailer Driver')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Mailer Host')); ?></label>
                                                    <input type="text" class="form-control" name="mail_host"
                                                        value="<?php echo e($settings->email_configuration['host']); ?>"
                                                        placeholder="<?php echo e(__('Mailer Host')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Mailer Port')); ?></label>
                                                    <input type="number" class="form-control" name="mail_port" oninput="validatePort(this)" maxlength="4"
                                                        value="<?php echo e($settings->email_configuration['port']); ?>"
                                                        placeholder="<?php echo e(__('Mailer Port')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label" for="mail_encryption"><?php echo e(__('Mailer Encryption')); ?></label>
                                                    <select name="mail_encryption" id="mail_encryption" class="form-select">
                                                        <option value="tls" <?php echo e($settings->email_configuration['encryption'] == 'tls' ? 'selected' : ''); ?>><?php echo e(__('TLS/STARTTLS')); ?></option>
                                                        <option value="ssl" <?php echo e($settings->email_configuration['encryption'] == 'ssl' ? 'selected' : ''); ?>><?php echo e(__('SSL')); ?></option>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Mailer Username')); ?></label>
                                                    <input type="text" class="form-control" name="mail_username"
                                                        value="<?php echo e($settings->email_configuration['username']); ?>"
                                                        placeholder="<?php echo e(__('Mailer Username')); ?>">
                                                </div>
                                            </div>

                                            
                                            <div class=" col-xl-4">
                                                <div class="mb-3">
                                                    <label class="form-label"><?php echo e(__('Mailer Password')); ?></label>
                                                    <input type="password" class="form-control" name="mail_password"
                                                        value="<?php echo e($settings->email_configuration['password']); ?>" maxlength="30"
                                                        placeholder="<?php echo e(__('Mailer Password')); ?>">
                                                </div>
                                            </div>

                                             
                                            <div class=" col-xl-4 mt-3">
                                                <div class="mb-3">
                                                    <label class="form-label"></label>
                                                    <a href="<?php echo e(route('admin.test.email')); ?>" class="btn btn-primary">
                                                        <?php echo e(__('Test Mail')); ?>

                                                    </a>
                                                </div>
                                            </div>

                                            
                                            <div class="row">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Customer Email Verification System')); ?>

                                                </h2>
                                                <div class="col-xl-4 col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label required" for="disable_user_email_verification"><?php echo e(__('Require customer email verification?')); ?></label>
                                                        <select name="disable_user_email_verification" id="disable_user_email_verification" class="form-select" required>
                                                            <option value="1" <?php echo e($config[43]->config_value == '1' ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                            <option value="0" <?php echo e($config[43]->config_value == '0' ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        
                        <div class="accordion-item">
                            <h4 class="accordion-header" id="heading-6">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapse-6" aria-expanded="false">
                                    <h2><?php echo e(__('Subdomain (vCard and Store) Settings')); ?></h2>
                                </button>
                            </h4>
                            <div id="collapse-6" class="accordion-collapse collapse"
                                data-bs-parent="#accordion-example">
                                <div class="accordion-body pt-0">
                                    <form action="<?php echo e(route('admin.change.subdomain.settings')); ?>" method="post"
                                        enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">

                                            
                                            <div class="row">
                                                <h2 class="page-title my-3">
                                                    <?php echo e(__('Enable subdomain in vcard and store?')); ?>

                                                </h2>
                                                <div class="col-xl-6 col-12">
                                                    <div class="mb-3">
                                                        <label class="form-label required" for="enable_subdomain"><?php echo e(__('Enable subdomain in vcard and store?')); ?></label>
                                                        <select name="enable_subdomain" id="enable_subdomain" class="form-select" required>
                                                            <option value="1" <?php echo e($config[46]->config_value == '1' ? 'selected' : ''); ?>><?php echo e(__('Yes')); ?></option>
                                                            <option value="0" <?php echo e($config[46]->config_value == '0' ? 'selected' : ''); ?>><?php echo e(__('No')); ?></option>
                                                        </select>
                                                    </div>
                                                    <small><strong><?php echo e(__('Note')); ?>: <?php echo e(__('The mode of enabling this feature will be brought in the next update depending on the plan purchased by the customer.')); ?></strong></small>
                                                </div>
                                            </div>

                                            
                                            <div class="text-end bottom-fix">
                                                <div class="d-flex">
                                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                                        <?php echo e(__('Update')); ?>

                                                    </button>
                                                </div>
                                            </div>

                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startSection('scripts'); ?>
<script>
function validatePort(input) {
    "use strict";
    
    const maxLength = 5; // Set your desired max length
    if (input.value.length > maxLength) {
    input.value = input.value.slice(0, maxLength);
    }
}
</script>
<script>
    tinymce.init({
      selector: 'textarea#bank_transfer',
      plugins: 'code preview importcss searchreplace autolink autosave save directionality visualblocks visualchars link table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
      menubar: 'file edit view insert format tools table help',
      toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | pagebreak | link',
      toolbar_sticky: true,
      height: 200,
      menubar: false,
      statusbar: false,
      autosave_interval: '30s',
      autosave_prefix: '{path}{query}-{id}-',
      autosave_restore_when_empty: false,
      autosave_retention: '2m',
      content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }',
    });
</script>
<script>
    // Array of element IDs
    var elementSelectors = ['show_website', 'timezone', 'currency', 'currency_format', 'term', 'cookie', 'show_whatsapp_chatbot', 'paypal_mode', 'toyyibpay_mode', 'recaptcha_enable', 'google_auth_enable', 'mail_encryption', 'disable_user_email_verification', 'enable_subdomain'];
    
    // Function to initialize TomSelect and enforce the "required" attribute
    function initializeTomSelectWithRequired(el) {
        new TomSelect(el, {
            copyClassesToDropdown: false,
            dropdownClass: 'dropdown-menu ts-dropdown',
            optionClass: 'dropdown-item',
            controlInput: '<input>',
            maxOptions: null,
            render: {
                item: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
                option: function(data, escape) {
                    if (data.customProperties) {
                        return '<div><span class="dropdown-item-indicator">' + data.customProperties + '</span>' + escape(data.text) + '</div>';
                    }
                    return '<div>' + escape(data.text) + '</div>';
                },
            },
        });
    
        // Ensure the "required" attribute is enforced
        el.addEventListener('change', function() {
            if (el.value) {
                el.setCustomValidity('');
            } else {
                el.setCustomValidity('This field is required');
            }
        });
    
        // Trigger validation on load
        el.dispatchEvent(new Event('change'));
    }
    
    // Loop through each element ID
    elementSelectors.forEach(function(id) {
        // Check if the element exists
        var el = document.getElementById(id);
        if (el) {
            // Apply TomSelect and enforce the "required" attribute
            initializeTomSelectWithRequired(el);
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/settings/index.blade.php ENDPATH**/ ?>