

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-xl">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Transactions')); ?> 
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-xl mt-3">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="col-12">
                <div class="card">
                    <div class="table-responsive">
                        <table class="table card-table table-vcenter text-nowrap datatable" id="transactions-table">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('S.No')); ?></th>
                                    <th><?php echo e(__('Transaction Date')); ?></th>
                                    <th class="w-1"><?php echo e(__('Trans ID')); ?></th>
                                    <th><?php echo e(__('Payment Trans ID')); ?></th>
                                    <th><?php echo e(__('Customer Name')); ?></th>
                                    <th><?php echo e(__('Gateway Name')); ?></th>
                                    <th><?php echo e(__('Amount')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Actions')); ?></th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                    <div><?php echo e(__('If you proceed with this transaction, you will have payment status success, and user chosen plan will be activated.')); ?>

                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary btn-sm me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger btn-sm" id="transaction_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#transactions-table').DataTable({
            processing: false, // Disable processing indicator
            serverSide: true,
            ajax: "<?php echo e(route('admin.transactions')); ?>",
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'created_at', name: 'created_at' },
                { data: 'gobiz_transaction_id', name: 'gobiz_transaction_id' },
                { data: 'transaction_id', name: 'transaction_id' },
                { data: 'user', name: 'user' },
                { data: 'payment_gateway_name', name: 'payment_gateway_name' },
                { data: 'transaction_amount', name: 'transaction_amount' },
                { data: 'payment_status', name: 'payment_status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ]
        });
    });
    
    function getTransaction(transactionId) {
        "use strict";
        $("#delete-modal").modal("show");
        var link = document.getElementById("transaction_id");
        link.getAttribute("href");
        link.setAttribute("href", "/admin/transaction-status/" + transactionId + "/SUCCESS");
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/transactions/index.blade.php ENDPATH**/ ?>