


<?php
// Number of enquiries
$enquiries = "<span class='text-danger'>Unlimited</span>";
if ($plan_details->no_of_enquires != 999) {
    $enquiries = "<span class='text-danger'>".$plan_details->no_of_enquires."</span>";
}
?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Enquiries')); ?>

                    </h2>
                    <p class="mt-1"><strong><?php echo __('Based on your subscription, you can find a maximum of '.$enquiries.' enquiries here.'); ?></strong></p>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table" id="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('S.No')); ?></th>
                                        <th><?php echo e(__('Date')); ?></th>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Email')); ?></th>
                                        <th><?php echo e(__('Mobile Number')); ?></th>
                                        <th><?php echo e(__('Message')); ?></th>
                                        <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $businessEnquries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enquiry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($enquiry->created_at->diffForHumans()); ?></td>
                                        <td class="text-capitalize"><?php echo e($enquiry->name); ?></td>
                                        <td><a href="mailto:<?php echo e($enquiry->email); ?>"><?php echo e($enquiry->email); ?></a></td>
                                        <td><a href="tel:<?php echo e($enquiry->phone); ?>"><?php echo e($enquiry->phone); ?></a></td>
                                        <td class="text-capitalize"><?php echo e($enquiry->message); ?></td>
                                        <td class="text-end">
                                            <a class="btn btn-primary btn-sm small-btn"
                                                href="mailto:<?php echo e($enquiry->email); ?>"><?php echo e(__('Reply')); ?></a>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startPush('custom-js'); ?>
<script>

</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/cards/enquiries.blade.php ENDPATH**/ ?>