<?php
    // Settings
    use App\Setting;
    use App\Page;
    use Illuminate\Support\Facades\DB;

    $setting = Setting::where('status', 1)->first();
    $pages = Page::get();
    $homePage = DB::table('pages')
        ->where('page_name', 'home')
        ->get();

    // Check if the website is down for maintenance
    $isDown = app()->isDownForMaintenance();
?>

<style>
/* Default: Hide the menu */
.mobile-menu {
    display: none;
}

/* Show the menu between 1024px and 1435px */
@media screen and (min-width: 1024px) and (max-width: 1435px) {
    .mobile-menu {
        display: block;
        position: fixed;
        top: 0;
        left: 0;
        bottom: 0;
        width: 66.67%; /* 4/6 width */
        max-width: 320px; /* Tailwind sm:max-w-xs equivalent */
        z-index: 50;
        background: white;
    }

    .mobile-menu-backdrop {
        position: fixed;
        inset: 0; /* shorthand for top: 0; left: 0; bottom: 0; right: 0 */
        background: rgba(31, 41, 55, 0.8); /* bg-gray-800 with 80% opacity */
        z-index: 49;
    }
}

</style>

<section
    class="bg-<?php echo e(request()->is('/') ? 'gradient-' . $config[11]->config_value . '2' : 'white'); ?> lg:px-20 background-animate">
    <section>
        <div class="flex items-center justify-between px-8 py-5">
            
            <div class="w-auto">
                <div class="flex flex-wrap items-center">
                    <div class="w-auto mr-14">
                        <a href="/">
                            <img src="<?php echo e(asset($settings->site_logo)); ?>" alt="<?php echo e($settings->site_name); ?>" width="150">
                        </a>
                    </div>
                    <?php if($config[38]->config_value != "no"): ?>
                        <div class="w-auto">
                            <div class="flex flex-wrap items-center">
                                <div class="w-auto hidden xl:block">
                                    <ul class="flex items-center mr-10">
                                        <?php if($pages[204]->page_name == 'about' && $pages[204]->status == 'active'): ?>
                                            <li class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg"><a
                                                    href="<?php echo e(route('about')); ?>"><?php echo e(__('About')); ?></a></li>
                                        <?php endif; ?>
                                        <li class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg"><a
                                                href="<?php echo e(route('home-locale')); ?>#how-it-works"><?php echo e(__('How it works?')); ?></a>
                                        </li>
                                        <li class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg"><a
                                                href="<?php echo e(route('home-locale')); ?>#features"><?php echo e(__('Features')); ?></a></li>
                                        <li class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg"><a
                                                href="<?php echo e(route('home-locale')); ?>#pricing"><?php echo e(__('Pricing')); ?></a></li>
                                        <?php if($pages[195]->page_name == 'contact' && $pages[195]->status == 'active'): ?>
                                            <li class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg"><a
                                                    href="<?php echo e(route('contact')); ?>"><?php echo e(__('Contact')); ?></a></li>
                                        <?php endif; ?>

                                        
                                        <?php if($pages): ?>
                                            <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($page->page_name == 'Custom Page' && $page->status == 'active'): ?>
                                                    <li
                                                        class="font-heading mr-9 text-gray-900 hover:text-gray-700 text-lg <?php echo e(request()->is('p/' . $page->section_title) ? 'font-bold' : ''); ?>">
                                                        <a
                                                            href="<?php echo e(route('custom.page', $page->section_title)); ?>"><?php echo e(__($page->section_name)); ?></a>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>

                                        
                                        <?php if($settings->google_adsense_code != 'DISABLE_BOTH'): ?>
                                            <div @click.away="open = false"
                                                class="hidden cursor-pointer lg:inline-block px-2 transition duration-200 relative"
                                                x-data="{ open: false }">
                                                <a @click="open = !open"
                                                    class="font-heading mr-4 text-gray-900 hover:text-gray-700 text-lg">
                                                    <span><?php echo e(__('Web Tools')); ?></span>
                                                    <svg fill="currentColor" viewBox="0 0 20 20"
                                                        :class="{ 'rotate-180': open, 'rotate-0': !open }"
                                                        class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                                                        <path fill-rule="evenodd"
                                                            d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                            clip-rule="evenodd"></path>
                                                    </svg>
                                                </a>
                                                <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                                    x-transition:enter-start="transform opacity-0 scale-95"
                                                    x-transition:enter-end="transform opacity-100 scale-100"
                                                    x-transition:leave="transition ease-in duration-75"
                                                    x-transition:leave-start="transform opacity-100 scale-100"
                                                    x-transition:leave-end="transform opacity-0 scale-95"
                                                    class="journal-scroll absolute w-full h-80 overflow-y-scroll mt-2 rounded-lg shadow-lg md:w-40">
                                                    <div class="px-2 py-2 bg-white capitalize rounded-sm shadow">
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.html.beautifier')); ?>"><?php echo e(__('HTML Beautifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.html.minifier')); ?>"><?php echo e(__('HTML Minifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.css.beautifier')); ?>"><?php echo e(__('CSS Beautifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.css.minifier')); ?>"><?php echo e(__('CSS Minifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.js.beautifier')); ?>"><?php echo e(__('JS Beautifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.js.minifier')); ?>"><?php echo e(__('JS Minifier')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.random.password.generator')); ?>"><?php echo e(__('Random Password Generator')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.bcrypt.password.generator')); ?>"><?php echo e(__('Bcrypt Password Generator')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.md5.password.generator')); ?>"><?php echo e(__('MD5 Password Generator')); ?></a>
                                                        
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.text.counter')); ?>"><?php echo e(__('Text Counter')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.lorem.generator')); ?>"><?php echo e(__('Lorem Generator')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.emojies')); ?>"><?php echo e(__('Emojies')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.dns.lookup')); ?>"><?php echo e(__('DNS Lookup')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.ip.lookup')); ?>"><?php echo e(__('IP Address Lookup')); ?></a>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(route('web.whois.lookup')); ?>"><?php echo e(__('WHOIS Lookup')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="w-auto">
                <div class="flex flex-wrap items-center">
                    <div class="w-auto hidden 2xl:block">
                        <div class="flex flex-wrap">
                            
                            <?php if(!$isDown): ?>
                                
                                <div class="w-auto">
                                    <?php if(count(config('app.languages')) > 1): ?>
                                        <div @click.away="open = false"
                                            class="hidden cursor-pointer lg:inline-block py-2 transition duration-200 relative"
                                            x-data="{ open: false }">
                                            <a @click="open = !open"
                                                class="font-heading mr-4 text-gray-900 hover:text-gray-700 text-lg">
                                                <span><?php echo e(strtoupper(app()->getLocale())); ?></span>
                                                <svg fill="currentColor" viewBox="0 0 20 20"
                                                    :class="{ 'rotate-180': open, 'rotate-0': !open }"
                                                    class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                                                    <path fill-rule="evenodd"
                                                        d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                        clip-rule="evenodd"></path>
                                                </svg>
                                            </a>
                                            <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                                x-transition:enter-start="transform opacity-0 scale-95"
                                                x-transition:enter-end="transform opacity-100 scale-100"
                                                x-transition:leave="transition ease-in duration-75"
                                                x-transition:leave-start="transform opacity-100 scale-100"
                                                x-transition:leave-end="transform opacity-0 scale-95"
                                                class="journal-scroll absolute w-full max-h-80 overflow-y-scroll mt-2 rounded-lg shadow-lg md:w-40">
                                                <div class="px-2 py-2 bg-white capitalize rounded-sm shadow">
                                                    <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                            href="<?php echo e(url()->current()); ?>?change_language=<?php echo e($langLocale); ?>"><?php echo e(strtoupper($langName)); ?></a>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            
                            <?php if($config[38]->config_value != "no"): ?>
                                <?php if(auth()->guard()->guest()): ?>
                                    <div class="w-auto">
                                        <a class="font-heading block py-2 px-5 mr-5 text-lg text-gray-900 rounded-10"
                                            href="<?php echo e(route('login')); ?>"><?php echo e(__('Sign In')); ?></a>
                                    </div>

                                    <?php if(Route::has('register')): ?>
                                        <div class="w-auto">
                                            <a class="group relative font-heading block py-2 px-5 text-lg text-gray-900 border-2 border-gray-900 overflow-hidden rounded-10"
                                                href="<?php echo e(route('register')); ?>">
                                                <div
                                                    class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-gray-900 transition ease-in-out duration-500">
                                                </div>
                                                <p class="relative z-10 group-hover:text-white"><?php echo e(__('Sign Up')); ?></p>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                <?php else: ?>
                                    
                                    <?php if(!$isDown): ?>
                                        <div class="w-auto">
                                            <a class="group relative font-heading block py-2 px-5 text-lg text-gray-900 border-2 border-gray-900 overflow-hidden rounded-10"
                                                href="<?php echo e(route('user.dashboard')); ?>">
                                                <div
                                                    class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-gray-900 transition ease-in-out duration-500">
                                                </div>
                                                <p class="relative z-10 group-hover:text-white"><?php echo e(__('Dashboard')); ?></p>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="w-auto 2xl:hidden">
                        <?php if($config[38]->config_value != "no"): ?>
                            <a href="#">
                                <svg class="navbar-burger text-gray-800" width="51" height="51"
                                    viewbox="0 0 56 56" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect width="56" height="56" rx="28" fill="currentColor"></rect>
                                    <path d="M37 32H19M37 24H19" stroke="white" stroke-width="1.5" stroke-linecap="round"
                                        stroke-linejoin="round"></path>
                                </svg>
                            </a>
                        <?php else: ?>
                            
                            <?php if(!$isDown): ?>
                                <?php if(count(config('app.languages')) > 1): ?>
                                    <div @click.away="open = false"
                                        class="cursor-pointer lg:inline-block py-2 transition duration-200 relative"
                                        x-data="{ open: false }">
                                        <a @click="open = !open"
                                            class="font-heading mr-4 text-gray-900 hover:text-gray-700 text-lg">
                                            <span><?php echo e(strtoupper(app()->getLocale())); ?></span>
                                            <svg fill="currentColor" viewBox="0 0 20 20"
                                                :class="{ 'rotate-180': open, 'rotate-0': !open }"
                                                class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                                                <path fill-rule="evenodd"
                                                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                    clip-rule="evenodd"></path>
                                            </svg>
                                        </a>
                                        <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                            x-transition:enter-start="transform opacity-0 scale-95"
                                            x-transition:enter-end="transform opacity-100 scale-100"
                                            x-transition:leave="transition ease-in duration-75"
                                            x-transition:leave-start="transform opacity-100 scale-100"
                                            x-transition:leave-end="transform opacity-0 scale-95"
                                            class="journal-scroll absolute max-h-80 overflow-y-scroll mt-2 rounded-lg shadow-lg" style="margin-left: -75px; margin-top: -1px;">
                                            <div class="px-2 py-2 bg-white capitalize rounded-sm shadow">
                                                <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                        href="<?php echo e(url()->current()); ?>?change_language=<?php echo e($langLocale); ?>"><?php echo e(strtoupper($langName)); ?></a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="hidden navbar-menu fixed top-0 left-0 bottom-0 w-4/6 sm:max-w-xs z-50">
            <div class="navbar-backdrop fixed inset-0 bg-gray-800 opacity-80"></div>
            <nav class="relative z-10 px-9 py-8 bg-white h-full">
                <div class="flex flex-wrap justify-between h-full">
                    <div class="w-full">
                        <div class="flex items-center justify-between -m-2">
                            <div class="w-auto p-2">
                                <a class="inline-block" href="/">
                                    <img src="<?php echo e(asset($settings->site_logo)); ?>" alt="<?php echo e($settings->site_name); ?>"
                                        width="100">
                                </a>
                            </div>
                            <div class="w-auto p-2">
                                <a class="navbar-burger" href="#">
                                    <svg width="24" height="24" viewbox="0 0 24 24" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6 18L18 6M6 6L18 18" stroke="#111827" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="flex flex-col justify-center py-8 w-full">
                        <ul>
                            <?php if($pages[204]->page_name == 'about' && $pages[204]->status == 'active'): ?>
                                <li class="mb-6"><a
                                        class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                        href="<?php echo e(route('about')); ?>"><?php echo e(__('About')); ?></a></li>
                            <?php endif; ?>
                            <li class="mb-6"><a
                                    class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('home-locale')); ?>#how-it-works"><?php echo e(__('How it works?')); ?></a></li>
                            <li class="mb-6"><a
                                    class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('home-locale')); ?>#features"><?php echo e(__('Features')); ?></a></li>
                            <li class="mb-6"><a
                                    class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                    href="<?php echo e(route('home-locale')); ?>#pricing"><?php echo e(__('Pricing')); ?></a></li>
                            <?php if($pages[195]->page_name == 'contact' && $pages[195]->status == 'active'): ?>
                                <li class="mb-6"><a
                                        class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                        href="<?php echo e(route('contact')); ?>"><?php echo e(__('Contact')); ?></a></li>
                            <?php endif; ?>

                            
                            <?php if($pages): ?>
                                <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($page->page_name == 'Custom Page' && $page->status == 'active'): ?>
                                        <li
                                            class="mb-6 <?php echo e(request()->is('p/' . $page->section_title) ? 'font-bold' : ''); ?>">
                                            <a class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700"
                                                href="<?php echo e(route('custom.page', $page->section_title)); ?>"><?php echo e(__($page->section_name)); ?></a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                            
                            <?php if($settings->google_adsense_code != 'DISABLE_BOTH'): ?>
                                <li @click.away="open = false" class="mb-6 relative" x-data="{ open: false }">
                                    <a @click="open = !open"
                                        class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700">
                                        <span><?php echo e(__('Web Tools')); ?></span>
                                        <svg fill="currentColor" viewBox="0 0 20 20"
                                            :class="{ 'rotate-180': open, 'rotate-0': !open }"
                                            class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                                            <path fill-rule="evenodd"
                                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                    </a>
                                    <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                        x-transition:enter-start="transform opacity-0 scale-95"
                                        x-transition:enter-end="transform opacity-100 scale-100"
                                        x-transition:leave="transition ease-in duration-75"
                                        x-transition:leave-start="transform opacity-100 scale-100"
                                        x-transition:leave-end="transform opacity-0 scale-95"
                                        class="journal-scroll absolute w-full h-40 overflow-y-scroll mt-2 rounded-lg shadow-lg md:w-40 z-50">
                                        <div class="px-2 py-2 bg-white capitalize rounded-sm shadow">
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.html.beautifier')); ?>"><?php echo e(__('HTML Beautifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.html.minifier')); ?>"><?php echo e(__('HTML Minifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.css.beautifier')); ?>"><?php echo e(__('CSS Beautifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.css.minifier')); ?>"><?php echo e(__('CSS Minifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.js.beautifier')); ?>"><?php echo e(__('JS Beautifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.js.minifier')); ?>"><?php echo e(__('JS Minifier')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.random.password.generator')); ?>"><?php echo e(__('Random Password Generator')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.bcrypt.password.generator')); ?>"><?php echo e(__('Bcrypt Password Generator')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.md5.password.generator')); ?>"><?php echo e(__('MD5 Password Generator')); ?></a>
                                            
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.text.counter')); ?>"><?php echo e(__('Text Counter')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.lorem.generator')); ?>"><?php echo e(__('Lorem Generator')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.emojies')); ?>"><?php echo e(__('Emojies')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.dns.lookup')); ?>"><?php echo e(__('DNS Lookup')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.ip.lookup')); ?>"><?php echo e(__('IP Address Lookup')); ?></a>
                                            <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                href="<?php echo e(route('web.whois.lookup')); ?>"><?php echo e(__('WHOIS Lookup')); ?></a>
                                        </div>
                                    </div>
                                </li>
                            <?php endif; ?>

                            
                            <?php if(count(config('app.languages')) > 1): ?>
                                <li @click.away="open = false" class="mb-6 relative" x-data="{ open: false }">
                                    <a @click="open = !open"
                                        class="font-heading font-medium text-lg text-gray-900 hover:text-gray-700">
                                        <span><?php echo e(strtoupper(app()->getLocale())); ?></span>
                                        <svg fill="currentColor" viewBox="0 0 20 20"
                                            :class="{ 'rotate-180': open, 'rotate-0': !open }"
                                            class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                                            <path fill-rule="evenodd"
                                                d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                                                clip-rule="evenodd"></path>
                                        </svg>
                                    </a>
                                    <div x-show="open" x-transition:enter="transition ease-out duration-100"
                                        x-transition:enter-start="transform opacity-0 scale-95"
                                        x-transition:enter-end="transform opacity-100 scale-100"
                                        x-transition:leave="transition ease-in duration-75"
                                        x-transition:leave-start="transform opacity-100 scale-100"
                                        x-transition:leave-end="transform opacity-0 scale-95"
                                        class="journal-scroll absolute w-full h-40 overflow-y-scroll mt-2 rounded-lg shadow-lg md:w-40 z-50">
                                        <div class="px-2 py-2 bg-white capitalize rounded-sm shadow">
                                            <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="block px-4 py-2 mt-2 text-lg capitalize font-semi-bold bg-transparent rounded-sm dark-mode:bg-transparent md:mt-0 focus:outline-none focus:shadow-outline"
                                                    href="<?php echo e(url()->current()); ?>?change_language=<?php echo e($langLocale); ?>"><?php echo e(strtoupper($langName)); ?></a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="flex flex-col justify-end w-full">
                        <div class="flex flex-wrap">
                            
                            <?php if(auth()->guard()->guest()): ?>
                                <div class="w-full">
                                    <a class="p-0.5 font-heading block w-full text-lg text-gray-900 font-medium rounded-10"
                                        href="<?php echo e(route('login')); ?>">
                                        <div class="py-2 px-5 rounded-10">
                                            <p><?php echo e(__('Login')); ?></p>
                                        </div>
                                    </a>
                                </div>

                                <?php if(Route::has('register')): ?>
                                    <div class="w-full">
                                        <a href="<?php echo e(route('register')); ?>"
                                            class="group relative p-0.5 font-heading block w-full text-lg text-gray-900 font-medium bg-gradient-cyan overflow-hidden rounded-10">
                                            <div
                                                class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-gradient-cyan transition ease-in-out duration-500">
                                            </div>
                                            <div class="py-2 px-5 bg-white rounded-lg">
                                                <p class="relative z-10"><?php echo e(__('Try now')); ?></p>
                                            </div>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            <?php else: ?>
                                
                                <?php if(!$isDown): ?>
                                    <div class="w-full">
                                        <a href="<?php echo e(route('user.dashboard')); ?>"
                                            class="group relative p-0.5 font-heading block w-full text-lg text-gray-900 font-medium bg-gradient-cyan overflow-hidden rounded-10">
                                            <div
                                                class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-gradient-cyan transition ease-in-out duration-500">
                                            </div>
                                            <div class="py-2 px-5 bg-white rounded-lg">
                                                <p class="relative z-10"><?php echo e(__('Dashboard')); ?></p>
                                            </div>
                                        </a>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </nav>
        </div>
    </section>

    
    <?php if(isset($banner) && $banner): ?>
        <div class="container mx-auto px-4">
            <div class="flex flex-wrap items-center -m-4 lg:pt-24 pt-10 pb-36">
                <div class="w-full lg:w-1/2 p-6">
                    <div class="lg:max-w-xl">
                        <h1 class="mb-6 font-heading text-7xl md:text-10xl xl:text-12xl text-gray-900 font-bold">
                            <?php echo e(__($homePage[0]->section_content)); ?></h1>
                        <p class="mb-9 text-gray-600 text-lg"><?php echo e(__($homePage[1]->section_content)); ?></p>
                        <button
                            class="group relative font-heading px-10 py-5 my-2 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-<?php echo e($config[11]->config_value); ?>-800 overflow-hidden rounded-md">
                            <a href="<?php echo e(url($homePage[5]->section_content)); ?>" target="_blank">
                                <div
                                    class="absolute top-0 left-0 transform -translate-x-full group-hover:-translate-x-0 h-full w-full transition ease-in-out duration-500 bg-gray-800">
                                </div>
                                <p class="relative z-10"><?php echo e(__($homePage[4]->section_content)); ?></p>
                            </a>
                        </button>
                        <button
                            class="group relative font-heading px-10 py-5 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gray-900 overflow-hidden rounded-md">
                            <a href="<?php echo e(url($homePage[3]->section_content)); ?>" target="_blank">
                                <div
                                    class="absolute top-0 left-0 transform -translate-x-full group-hover:-translate-x-0 h-full w-full transition ease-in-out duration-500 bg-gray-800">
                                </div>
                                <p class="relative z-10"><?php echo e(__($homePage[2]->section_content)); ?></p>
                            </a>
                        </button>
                    </div>
                </div>
                <div class="w-full lg:w-1/2 p-6">
                    <img class="block mx-auto" src="<?php echo e(asset($config[12]->config_value)); ?>"
                        alt="<?php echo e($settings->site_name); ?>">
                </div>
            </div>
        </div>
    <?php endif; ?>
</section>
<?php /**PATH /home/betvscaa/public_html/resources/views/website/includes/header.blade.php ENDPATH**/ ?>