<?php if($paginator->hasPages()): ?>
<div class="card pagination-card">
    <div class="card-footer pagination-card-footer d-flex align-items-center">
        <p class="m-0 text-muted"><?php echo __(''); ?> <span><?php echo e($paginator->firstItem()); ?></span> <?php echo __('to'); ?>

            <span><?php echo e($paginator->lastItem()); ?></span> <?php echo __('of'); ?> <span><?php echo e($paginator->total()); ?></span> <?php echo __('results'); ?>

        </p>
        <nav class="custom-nav">
            <ul class="pagination">
                
                <?php if($paginator->onFirstPage()): ?>
                <li class="btn btn-sm btn-primary li-link disabled" aria-disabled="true">
                    <span><?php echo app('translator')->get('pagination.previous'); ?></span>
                </li>
                <?php else: ?>
                <li><a class="btn btn-sm btn-primary li-link" href="<?php echo e($paginator->previousPageUrl()); ?>"
                        rel="prev"><?php echo app('translator')->get('pagination.previous'); ?></a></li>
                <?php endif; ?>

                
                <?php if($paginator->hasMorePages()): ?>
                <li><a class="btn btn-sm btn-primary li-link" href="<?php echo e($paginator->nextPageUrl()); ?>"
                        rel="next"><?php echo app('translator')->get('pagination.next'); ?></a></li>
                <?php else: ?>
                <li class="btn btn-sm btn-primary li-link disabled" aria-disabled="true"><span><?php echo app('translator')->get('pagination.next'); ?></span>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
    </div>
</div>
<?php endif; ?>

<style>
    .btn-group-sm>.btn, .btn-sm {
        --tblr-btn-line-height: 1.5;
        --tblr-btn-icon-size: .75rem;
        margin-right: 5px;
        font-size: 12px !important;
        margin: 13px 0 10px 5px !important;
    }

    .li-link {
        padding: 10px;
        margin: 4px;
    }

    .btn.disabled, .btn:disabled, fieldset:disabled .btn {
        border-color: #0000 !important;
    }

    .custom-nav {
        position: absolute;
        right: 5px;
        top: -2px;
    }
</style><?php /**PATH /home/betvscaa/public_html/resources/views/vendor/pagination/tailwind.blade.php ENDPATH**/ ?>