


<?php $__env->startSection('css'); ?>
<!-- Bootstrap Tags Input CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.css">

<script src="https://cdnjs.cloudflare.com/ajax/libs/tinymce/7.0.1/tinymce.min.js" integrity="sha512-KGtsnWohFUg0oksKq7p7eDgA1Rw2nBfqhGJn463/rGhtUY825dBqGexj8eP04LwfnsSW6dNAHAlOqKJKquHsnw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<style>
.bootstrap-tagsinput .tag {
    margin-right: 2px;
    color: #ffffff;
    background: #206bc4;
    border-radius: 5px;
    padding: 5px;
    margin-top: 10px;
}

.cover-preview {
    width: 50% !important;
}
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="container-fluid">
            <!-- Page title -->
            <div class="page-header d-print-none">
                <div class="row align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Create Blog')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">

                
                <?php if(Session::has("failed")): ?>
                <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('failed')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                
                <?php if(Session::has("success")): ?>
                <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                    <div class="d-flex">
                        <div>
                            <?php echo e(Session::get('success')); ?>

                        </div>
                    </div>
                    <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                <?php endif; ?>

                <div class="row row-deck row-cards">
                    
                    <div class="col-sm-12 col-lg-12">
                        <form action="<?php echo e(route('admin.publish.blog')); ?>" method="post" enctype="multipart/form-data" class="card">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-xl-12">
                                        <div class="row">

                                            
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Cover')); ?></div>
                                                    <input type="file" class="form-control" name="blog_cover" id="cover" accept=".jpeg,.jpg,.png,.webp" required />
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-6 col-xl-6 mb-3">
                                                <div class="form-label"><?php echo e(__('Cover Image Preview')); ?></div>
                                                <a target="_blank" id="divCoverImg">
                                                    <img id="coverPreview" class="card-img-top cover-preview">
                                                </a>
                                            </div>

                                            
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Name')); ?></label>
                                                    <input type="text" class="form-control text-capitalize" name="blog_name" id="blog_name" maxlength="200" placeholder="<?php echo e(__('Eg: Blog title')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Slug')); ?></label>
                                                    <input type="text" class="form-control" name="blog_slug" id="blog_slug" maxlength="200" placeholder="<?php echo e(__('Eg: blog-url')); ?>" required>
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Short description')); ?></label>
                                                    <textarea class="form-control text-capitalize" name="short_description" id="short_description" placeholder="<?php echo e(__('Eg: Blog title')); ?>" cols="30" rows="3" required></textarea>
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Description')); ?></div>
                                                    <textarea name="long_description" id="long_description" cols="30" rows="5" class="form-control text-capitalize" placeholder="<?php echo e(__('Description')); ?>"></textarea>
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Categories')); ?></label>
                                                    <select class="form-select" placeholder="<?php echo e(__('Choose a category')); ?>" name="category_id" id="category_id" required>
                                                        <option value="" selected disabled><?php echo e(__('Choose a category')); ?></option>
                                                        <?php $__currentLoopData = $blogsCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blogsCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($blogsCategory->blog_category_id); ?>"<?php echo e($blogsCategory->blog_category_id == '66087535342' ? 'selected' : ''); ?>><?php echo e(__($blogsCategory->blog_category_title)); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            
                                            <div class="col-md-6 col-xl-6">
                                                <div class="mb-3">
                                                    <label class="form-label required"><?php echo e(__('Tags')); ?></label>
                                                    <input type="text" class="form-control" name="tags" id="tags" placeholder="<?php echo e(__('tag 1, tag 2')); ?>" required>
                                                    <small class="form-text text-muted"><?php echo e(__('Press Enter to add a tag.')); ?></small>
                                                </div>
                                                <div id="tagsContainer"></div>
                                            </div>

                                            <h2 class="page-title mt-3 mb-3">
                                                <?php echo e(__('SEO Configurations')); ?>

                                            </h2>
    
                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Title')); ?></div>
                                                    <textarea name="seo_title" id="seo_title" cols="30" rows="1"
                                                        class="form-control text-capitalize" placeholder="<?php echo e(__('Title')); ?>"
                                                        required></textarea>
                                                </div>
                                            </div>
    
                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Description')); ?></div>
                                                    <textarea name="seo_description" id="seo_description" cols="30" rows="5"
                                                        class="form-control" placeholder="<?php echo e(__('Description')); ?>"
                                                        required></textarea>
                                                </div>
                                            </div>
    
                                            
                                            <div class="col-md-12 col-xl-12">
                                                <div class="mb-3">
                                                    <div class="form-label required"><?php echo e(__('Keywords')); ?></div>
                                                    <input type="text" class="form-control" name="seo_keywords" placeholder="<?php echo e(__('Keywords')); ?>"
                                                        required />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer text-end">
                                <div class="d-flex">
                                    <a href="<?php echo e(route('admin.blog.categories')); ?>"
                                        class="btn btn-outline-primary btn-md"><?php echo e(__('Cancel')); ?></a>
                                    <button type="submit" class="btn btn-primary btn-md ms-auto">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-plus"
                                            width="24" height="24" viewBox="0 0 24 24" stroke-width="2"
                                            stroke="currentColor" fill="none" stroke-linecap="round"
                                            stroke-linejoin="round">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                                            <line x1="12" y1="5" x2="12" y2="19"></line>
                                            <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        <?php echo e(__('Publish')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        
        <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>


<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('js/lightgallery.min.js')); ?>"></script>
<!-- Bootstrap Tags Input JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-tagsinput/0.8.0/bootstrap-tagsinput.min.js"></script>
<script>
    // Preview Cover
    $(document).ready(() => {
        "use strict";

        const coverInp = $("#cover");
        let imgURL;

        coverInp.change(function(e) {
            imgURL = URL.createObjectURL(e.target.files[0]);

            var coverImg = document.getElementById("coverPreview");
            coverImg.getAttribute("src");
            coverImg.setAttribute("src", imgURL);

            // New blank
            var divCoverImg = document.getElementById("divCoverImg");
            divCoverImg.getAttribute("href");
            divCoverImg.setAttribute("href", imgURL);
        });
    });

    // Convert slug
    $('#blog_name').on("change keyup paste click", function() {
        "use strict";
        var Text = $(this).val();
        Text = Text.toLowerCase();
        Text = Text.replace(/[^a-zA-Z0-9]+/g, '-');
        $('#blog_slug').val(Text);
    });

    // HTML Editor
    tinymce.init({
        selector: '#long_description',
        plugins: 'code preview importcss searchreplace autolink autosave save directionality visualblocks visualchars link charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount charmap quickbars emoticons',
        menubar: 'file edit view insert format tools',
        toolbar: 'code undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | preview save print | insertfile link anchor | ltr rtl',
        content_style: 'body { font-family:Times New Roman,Arial,sans-serif; font-size:16px }',
        menubar: false,
        statusbar: false,
    });

    // Tags
    $(document).ready(function() {
        "use strict";

        $('#tags').tagsinput({
            confirmKeys: [13, 188] // Allows pressing Enter or comma to add a tag
        });

        $(".bootstrap-tagsinput input").addClass('form-control d-inline');
        $(".bootstrap-tagsinput").addClass('col-md-12 col-xl-12');
    });
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/blogs/create.blade.php ENDPATH**/ ?>