

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Customers')); ?>

                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table" id="customers-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('#')); ?></th>
                                        <th><?php echo e(__('Full Name')); ?></th>
                                        <th><?php echo e(__('Email')); ?></th>
                                        <th><?php echo e(__('Current Plan')); ?></th>
                                        <th><?php echo e(__('Joined')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('admin.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<div class="modal modal-blur fade" id="status-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div><?php echo e(__('If you proceed, you will active/deactivate this customer data.')); ?></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="user_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>

<div class="modal modal-blur fade" id="delete-modal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title text-capitalize"><?php echo e(__('customer data. It is not revertable action.')); ?></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="deleted_user_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>
<script type="text/javascript">
    $(document).ready(function() {
        $('#customers-table').DataTable({
            processing: false,
            serverSide: true,
            ajax: "<?php echo e(route('admin.customers')); ?>",
            language: {
                loadingRecords: "Please wait - loading...",
                emptyTable: "No data available in the table" // Message for an empty table
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'name', name: 'name' },
                { data: 'email', name: 'email' },
                { data: 'plan', name: 'plan' },
                { data: 'created_at', name: 'created_at' },
                { data: 'status', name: 'status' },
                { data: 'action', name: 'action', orderable: false, searchable: false },
            ],
            preDrawCallback: function(settings) {
                // Add placeholder-glow class to the table before rendering
                $('#customers-table_wrapper').addClass('placeholder-glow');

                // Check if there are rows in the tbody after draw
                if ($('#customers-table tbody tr').length === 0) {
                    // If there are no rows, add 10 placeholder rows with 7 columns each
                    var placeholderRows = '';
                    for (var i = 0; i < 10; i++) {
                        placeholderRows += '<tr>' + '<td class="text-center"><div class="placeholder placeholder-xs col-12"></div></td>'.repeat(7) + '</tr>';
                    }
                    $('#customers-table tbody').html(placeholderRows);
                }
            },
            drawCallback: function(settings) {
                // Remove the placeholder-glow class once the table is fully rendered
                $('#customers-table_wrapper').removeClass('placeholder-glow');

                // clear any existing placeholder rows
                $('#customers-table tbody tr').each(function() {
                    var actionCell = $(this).find('td').eq(6); // Targeting the 9th column (index 7)
                    if (actionCell.find('span.placeholder').length > 0) {
                        actionCell.empty(); // Clear the placeholder once data is available
                    }
                });
            }
        });
    });
    
    function activateUser(userId) {
        "use strict";
        $("#status-modal").modal("show");
        var link = document.getElementById("user_id");
        link.getAttribute("href");
        link.setAttribute("href", "/admin/update-status?id=" + userId);
    }
    
    function deactivateUser(userId) {
        "use strict";
        $("#status-modal").modal("show");
        var link = document.getElementById("user_id");
        link.getAttribute("href");
        link.setAttribute("href", "/admin/update-status?id=" + userId);
    }
    
    function deleteUser(userId) {
        "use strict";
        $("#delete-modal").modal("show");
        var link = document.getElementById("deleted_user_id");
        link.getAttribute("href");
        link.setAttribute("href", "/admin/delete-customer?id=" + userId);
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.index', ['header' => true, 'nav' => true, 'demo' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/admin/pages/customers/index.blade.php ENDPATH**/ ?>