

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <!-- Page title --> 
    <div class="page-header d-print-none">
        <div class="container-fluid">
            <div class="row g-2 align-items-center">
                <div class="col">
                    <div class="page-pretitle">
                        <?php echo e(__('Overview')); ?>

                    </div>
                    <h2 class="page-title">
                        <?php echo e(__('Business Cards')); ?>

                    </h2>
                </div>
                <div class="col-auto ms-auto d-print-none">
                    <div class="d-flex">
                        <a href="<?php echo e(route('user.choose.card.type')); ?>" class="btn btn-icon btn-primary" data-bs-toggle="tooltip" data-bs-placement="bottom" title="<?php echo e(__('Create new vcard')); ?>">
                            <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon d-lg-none d-inline" width="24" height="24"
                                viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none"
                                stroke-linecap="round" stroke-linejoin="round">
                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                <line x1="12" y1="5" x2="12" y2="19" />
                                <line x1="5" y1="12" x2="19" y2="12" />
                            </svg>
                            <span class="d-lg-inline d-none"><?php echo e(__('Create new vcard')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="row row-deck row-cards">
                <div class="col-sm-12 col-lg-12">
                    <div class="card">
                        <div class="table-responsive">
                            <table class="table table-vcenter card-table" id="businessCardsTable">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('#')); ?></th>
                                        <th><?php echo e(__('Created')); ?></th>
                                        <th><?php echo e(__('Name')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th class="w-1"><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<div class="modal modal-blur fade" id="deleteModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div><?php echo e(__('If you proceed, you will enabled/disabled this card.')); ?></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="plan_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>

<div class="modal modal-blur fade" id="openQR" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <div class="modal-title"><?php echo e(__('Scan QR')); ?></div>
            </div>
            <div class="modal-body text-center qr-code"></div>
        </div>
    </div>
</div>


<div class="modal modal-blur fade" id="forceDeleteModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div id="delete_status"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="delete_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<div class="modal modal-blur fade" id="duplicateModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <div class="modal-title"><?php echo e(__('Are you sure?')); ?></div>
                <div id="duplicate_status"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-outline-primary me-auto" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                <a class="btn btn-danger" id="duplicate_id"><?php echo e(__('Yes, proceed')); ?></a>
            </div>
        </div>
    </div>
</div>


<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function() {
        $('#businessCardsTable').DataTable({
            processing: false,
            serverSide: true,
            ajax: '<?php echo e(route('user.cards')); ?>',
            language: {
                loadingRecords: "Please wait - loading...",
                emptyTable: "No data available in the table" // Message for an empty table
            },
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                { data: 'created_at', name: 'created_at' },
                { data: 'title', name: 'title' },
                { data: 'card_status', name: 'card_status' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            preDrawCallback: function(settings) {
                // Add placeholder-glow class to the table before rendering
                $('#businessCardsTable_wrapper').addClass('placeholder-glow');

                // Check if there are rows in the tbody after draw
                if ($('#businessCardsTable tbody tr').length === 0) {
                    // If there are no rows, add 10 placeholder rows with 5 columns each
                    var placeholderRows = '';
                    for (var i = 0; i < 10; i++) {
                        placeholderRows += '<tr>' + '<td class="text-center"><div class="placeholder placeholder-xs col-12"></div></td>'.repeat(5) + '</tr>';
                    }
                    $('#businessCardsTable tbody').html(placeholderRows);
                }
            },
            drawCallback: function(settings) {
                // Remove the placeholder-glow class once the table is fully rendered
                $('#businessCardsTable_wrapper').removeClass('placeholder-glow');

                // clear any existing placeholder rows
                $('#businessCardsTable tbody tr').each(function() {
                    var actionCell = $(this).find('td').eq(4); // Targeting the 5th column (index 4)
                    if (actionCell.find('span.placeholder').length > 0) {
                        actionCell.empty(); // Clear the placeholder once data is available
                    }
                });
            }
        });
    });

    // Duplicate card
    function duplicateCard(id, type) {
        "use strict";

        $("#duplicateModal").modal("show");
        var duplicate_status = document.getElementById("duplicate_status");
        duplicate_status.innerHTML = "<?php echo __('If you proceed, you will duplicate this card.') ?>"
        var duplicate_link = document.getElementById("duplicate_id");
        duplicate_link.getAttribute("href");
        duplicate_link.setAttribute("href", "<?php echo e(route('user.duplicate')); ?>?id=" + id + "&type=" + type);
    }

    // Delete card
    function deleteCard(id, action) {
        "use strict";

        $("#forceDeleteModal").modal("show");
        var delete_status = document.getElementById("delete_status");
        delete_status.innerHTML = "<?php echo __('If you proceed, you will') ?> " + action + " <?php echo __('this card.') ?>"
        var delete_link = document.getElementById("delete_id");
        delete_link.getAttribute("href");
        delete_link.setAttribute("href", "<?php echo e(route('user.delete.card')); ?>?id=" + id);
    }
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/cards/cards.blade.php ENDPATH**/ ?>