


<?php $__env->startSection('css'); ?>
<script>
window.onload = function() {
    defaultContactForm();
}
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-wrapper">
    <div class="page-body">
        <div class="container-fluid">
            
            <?php if(Session::has("failed")): ?>
            <div class="alert alert-important alert-danger alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('failed')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>

            
            <?php if(Session::has("success")): ?>
            <div class="alert alert-important alert-success alert-dismissible mb-2" role="alert">
                <div class="d-flex">
                    <div>
                        <?php echo e(Session::get('success')); ?>

                    </div>
                </div>
                <a class="btn-close btn-close-white" data-bs-dismiss="alert" aria-label="close"></a>
            </div>
            <?php endif; ?>
            
            <div class="card">
                <div class="row g-0">
                    <div class="col-12 col-md-3 border-end">
                        <div class="card-body">
                            <h4 class="subheader"><?php echo e(__('Update Business Card')); ?></h4>
                            <div class="list-group list-group-transparent">
                                
                                <?php echo $__env->make('user.pages.edit-cards.includes.nav-link', ['link' => 'contact'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-9 d-flex flex-column">
                        <form action="<?php echo e(route('user.update.contact.form', Request::segment(3))); ?>" method="post" enctype="multipart/form-data" id="myForm">
                            <?php echo csrf_field(); ?>
                            <div class="card-body">
                                <h3 class="card-title mb-4"><?php echo e(__('Contact & Inquiry Form')); ?></h3>

                                <div class="row">
                                    <div class="col-md-6 col-xl-6">
                                        <div class="mb-3">
                                            <div class="form-label"><?php echo e(__('Hide Contact / Inquiry Form')); ?>

                                            </div>
                                            <label class="form-check form-switch">
                                                <input class="form-check-input" type="checkbox"
                                                    onchange="displayContactForm()" name="contact_form"
                                                    id="contact-form" <?php echo e($business_card->enquiry_email == null ?
                                                'checked' : ''); ?>>
                                            </label>
                                        </div>
                                    </div>

                                    <div id="contactForm">
                                        <h2 class="page-title mb-3">
                                            <?php echo e(__('Appointment, Contact & Inquiry Form Configuration')); ?>

                                        </h2>

                                        <!-- Email -->
                                        <div class="col-md-6 col-xl-6">
                                            <div class="mb-3">
                                                <label class="form-label required"><?php echo e(__('Want to receive email')); ?></label>
                                                <input type="email" class="form-control" name="receive_email"
                                                    id="receive_email" value="<?php echo e($business_card->enquiry_email); ?>" placeholder="<?php echo e(__('Email Address')); ?>"
                                                    required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer bg-transparent mt-auto">
                                <div class="btn-list justify-content-end">
                                    <a href="<?php echo e(route('user.cards')); ?>" class="btn">
                                        <?php echo e(__('Cancel')); ?>

                                    </a>

                                    
                                    <?php
                                    $route = route('user.cards');

                                    // Check business hours is "ENABLED"
                                    if ($plan_details->password_protected == 1 || $plan_details->advanced_settings == 1) {
                                        $route = route('user.edit.advanced.setting', Request::segment(3));
                                    }
                                    ?>

                                    <a href="<?php echo e($route); ?>" class="btn btn-primary">
                                        <?php echo e(__('Skip')); ?>

                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(__('Submit')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<?php $__env->startPush('custom-js'); ?>
<script>
function displayContactForm() {
    "use strict";
    var disp = $('input[name="contact_form"]:checked').length;
    console.log(disp);
    if (disp == 0) {
        $("#contactForm").show();
        $('#receive_email').attr('required', 'required');
    } else {
        $("#contactForm").hide();
        $('#receive_email').removeAttr('required', 'required');
    }
}
function defaultContactForm() {
    "use strict";
    var disp = $('input[name="contact_form"]:checked').length;
    console.log(disp);
    if (disp == 0) {
        $("#contactForm").show();
        $('#receive_email').attr('required', 'required');
    } else {
        $("#contactForm").hide();
        $('#receive_email').removeAttr('required', 'required');
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/edit-contact.blade.php ENDPATH**/ ?>