


<?php $__env->startSection('css'); ?>
    <style>
        .section {
            margin-bottom: 20px;
        }

        .code-block {
            background-color: #f1f1f1;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-family: monospace;
        }

        .image {
            text-align: center;
            margin: 15px 0;
        }

        .image img {
            max-width: 100%;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .tip {
            background-color: #e2f0d9;
            padding: 10px;
            border-left: 5px solid #4caf50;
            border-radius: 5px;
            margin-top: 10px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <!-- Page title -->
        <div class="page-header d-print-none">
            <div class="container-fluid">
                <div class="row g-2 align-items-center">
                    <div class="col">
                        <div class="page-pretitle">
                            <?php echo e(__('Overview')); ?>

                        </div>
                        <h2 class="page-title">
                            <?php echo e(__('Setting Up Cloudflare DNS Records and Page Rules')); ?>

                        </h2>
                    </div>
                </div>
            </div>
        </div>
        <div class="page-body">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-6 col-md-12 mb-3">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <!-- Section 1: Setting Up Cloudflare DNS Records -->
                                <div class="mb-4">
                                    <h2 class="text-muted">1. <?php echo e(__('Setting Up Cloudflare DNS Records')); ?></h2>
                                    <h3 class="mt-3"><?php echo e(__('Log In to Cloudflare')); ?></h3>
                                    <ul>
                                        <li><?php echo e(__('Visit the')); ?> <a href="https://dash.cloudflare.com" target="_blank"
                                                class="text-decoration-underline"><?php echo e(__('Cloudflare dashboard')); ?></a> <?php echo e(__('and log in to your account.')); ?></li>
                                    </ul>

                                    <h3 class="mt-4"><?php echo e(__('Select Your Domain')); ?></h3>
                                    <ul>
                                        <li><?php echo e(__('From the dashboard, select the domain you want to configure.')); ?></li>
                                    </ul>

                                    <h3 class="mt-4"><?php echo e(__('Add DNS Records')); ?></h3>
                                    <ul>
                                        <li><?php echo e(__('Go to the')); ?> <strong><?php echo e(__('DNS')); ?></strong> <?php echo e(__('tab and click')); ?> <strong><?php echo e(__('Add Record')); ?></strong> <?php echo e(__('to add the necessary DNS entries.')); ?></li>
                                    </ul>

                                    
                                    <div class="table-responsive">
                                        <table class="table table-vcenter">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('Type')); ?></th>
                                                    <th><?php echo e(__('Name')); ?></th>
                                                    <th><?php echo e(__('IPv4 address / Target')); ?></th>
                                                    <th><?php echo e(__('Proxy status')); ?></th>
                                                    <th><?php echo e(__('TTL')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>A</td>
                                                    <td>@ (for root domain)</td>
                                                    <td>Enter your server’s IP address</td>
                                                    <td>Enable (orange cloud icon)</td>
                                                    <td>Auto</td>
                                                </tr>
                                                <tr>
                                                    <td>CNAME</td>
                                                    <td>www</td>
                                                    <td><?php echo e(str_replace(['http://', 'https://', 'www.'], '', config('app.url'))); ?>

                                                    </td>
                                                    <td>Disabled (gray cloud icon)</td>
                                                    <td>Auto</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    <ul class="mt-3">
                                        <li><?php echo e(__('Save each record after entering the details.')); ?></li>
                                    </ul>

                                    
                                    <div>
                                        <?php echo e(__('Example DNS Records:')); ?>

                                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#exampleModal">
                                            <?php echo e(__('DNS Records')); ?>

                                        </button>
                                    </div>

                                    
                                    <div class="modal modal-blur fade" id="exampleModal" tabindex="-1"
                                        aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('DNS Records')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <img src="<?php echo e(asset('img/cloudflare-rules/cloudflare-dns-settings.png')); ?>"
                                                        alt="Cloudflare DNS Settings" class="card-img-top" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-12">
                        <div class="card shadow-sm">
                            <div class="card-body">
                                <!-- Section 2: Creating Page Rules -->
                                <div>
                                    <h2 class="text-muted">2. <?php echo e(__('Creating Page Rules')); ?></h2>
                                    <h3 class="mt-3"><?php echo e(__('Navigate to Page Rules')); ?></h3>
                                    <ul>
                                        <li><?php echo e(__('Go to the')); ?> <strong><?php echo e(__('Page Rules')); ?></strong> <?php echo e(__('tab on your domain\'s dashboard.')); ?></li>
                                    </ul>

                                    <h3 class="mt-4"><?php echo e(__('Add a New Page Rule')); ?></h3>
                                    <ul>
                                        <li><?php echo e(__('Click')); ?> <strong><?php echo e(__('Create Page Rule')); ?></strong> <?php echo e(__('and configure rules as needed.')); ?></li>
                                    </ul>

                                    
                                    <div class="mb-3">
                                        <?php echo e(__('Example Page Rules:')); ?>

                                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#exampleModal2">
                                            <?php echo e(__('Page Rules')); ?>

                                        </button>
                                    </div>

                                    
                                    <div class="modal modal-blur fade" id="exampleModal2" tabindex="-1"
                                        aria-labelledby="exampleModalLabel2" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel2"><?php echo e(__('Page Rules')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <img src="<?php echo e(asset('img/cloudflare-rules/page-rules-tab.png')); ?>"
                                                        alt="Page Rules Tab on Cloudflare" class="card-img-top" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <h3><?php echo e(__('Example Page Rule Configurations:')); ?></h3>
                                    
                                    <div class="table-responsive mb-3">
                                        <table class="table table-vcenter">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('URL')); ?></th>
                                                    <th><?php echo e(__('Setting')); ?></th>
                                                    <th><?php echo e(__('Select')); ?></th>
                                                    <th><?php echo e(__('Destination URL')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td><?php echo e(__('example.com')); ?></td>
                                                    <td><?php echo e(__('Forwarding URL')); ?></td>
                                                    <td><?php echo e(__('301 Permanent Redirect')); ?></td>
                                                    <td><?php echo e(__('https://www.example.com')); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>

                                    
                                    <div>
                                        <?php echo e(__('Example Redirect:')); ?>

                                        <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal"
                                            data-bs-target="#exampleModal3">
                                            <?php echo e(__('Redirect')); ?>

                                        </button>
                                    </div>

                                    
                                    <div class="modal modal-blur fade" id="exampleModal3" tabindex="-1"
                                        aria-labelledby="exampleModalLabel3" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel3"><?php echo e(__('Redirect')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                        aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <img src="<?php echo e(asset('img/cloudflare-rules/page-rules-redirect.png')); ?>"
                                                        alt="Page Rules Redirect" class="card-img-top" />
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <h3 class="mt-4"><?php echo e(__('Always Use HTTPS')); ?></h3>
                                    
                                    <div class="table-responsive">
                                        <table class="table table-vcenter">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(__('URL')); ?></th>
                                                    <th><?php echo e(__('Setting')); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>*example.com/*</td>
                                                    <td><?php echo e(__('Always Use HTTPS')); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <p class="mt-3"><?php echo e(__('Click')); ?> <strong><?php echo e(__('Save and Deploy')); ?></strong> <?php echo e(__('to activate the rule.')); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="alert alert-success mt-4" role="alert">
                        <strong><?php echo e(__('Tip:')); ?></strong> <?php echo __('Page rules are applied in order from top to bottom. Arrange them carefully based on priority. Use wildcards (<code>*</code>) for broader rule coverage, like <code>*example.com/*</code> to cover all pages.'); ?>

                    </div>
                </div>
            </div>
            <?php echo $__env->make('user.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.index', ['header' => true, 'nav' => true, 'demo' => true, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/custom-domain-cloudflare-rules/index.blade.php ENDPATH**/ ?>