<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" dir="<?php echo e(App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he') ? 'rtl' : 'ltr'); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($settings->site_name); ?></title>

    <link rel="icon" href="<?php echo e(asset($settings->favicon)); ?>" sizes="96x96" type="image/png" />

    <!-- CSS files -->
    <?php if(App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he')): ?>
        <link href="<?php echo e(asset('css/tabler.rtl.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-flags.rtl.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-payments.rtl.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-vendors.rtl.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/demo.rtl.min.css')); ?>" rel="stylesheet" />
    <?php else: ?>
        <link href="<?php echo e(asset('css/tabler.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-flags.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-payments.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/tabler-vendors.min.css')); ?>" rel="stylesheet" />
        <link href="<?php echo e(asset('css/demo.min.css')); ?>" rel="stylesheet" />
    <?php endif; ?>

    <link href="<?php echo e(asset('css/styles.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet" />
    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/chart.js')); ?>"></script>
    <?php echo $__env->yieldContent('css'); ?>
</head>

<body data-bs-theme="<?php echo e(Auth::user()->choosed_theme == 'light' ? 'light' : 'dark'); ?>">

    
    <div id="nativecode-loader">
        <div class="nativecode-loading"></div>
    </div>

    <div id="wrapper" class="page">

        <?php if(isset($nav) && $nav): ?>
            <?php echo $__env->make('admin.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        <?php if(isset($header) && $header): ?>
            <?php echo $__env->make('admin.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        
        <?php echo $__env->yieldContent('content'); ?>
    </div>

    <!-- Tabler Core -->
    <script type="text/javascript" src="<?php echo e(asset('js/tabler.min.js')); ?>"></script>
    <?php if(isset($demo) && $demo): ?>
    <script type="text/javascript" src="<?php echo e(asset('js/admin-delete-query.js')); ?>"></script>
    <?php endif; ?>
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.dataTables.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/dataTables.bootstrap4.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/datatable.js')); ?>"></script>
    
    <script>
        $(document).click(function (event) {
            "use strict";
            var clickover = $(event.target);
            var $navbar = $(".navbar-collapse");
            var _opened = $navbar.hasClass("show");
            if (_opened && !clickover.closest('.navbar').length) {
                $navbar.collapse('hide');
            }
        });
        // Wait for the window to load
        window.onload = function() {
            // Get the preloader element
            var preloader = document.getElementById('nativecode-loader');

            // Add the fade-out class to start the fade-out effect
            setTimeout(function() {
                preloader.classList.add('fade-out');

                // After the fade-out effect, remove the preloader and show the content
                setTimeout(function() {
                    preloader.style.display = 'none'; // Remove preloader from view
                    document.querySelector('.page').style.display = 'block'; // Show content
                }, 7000); // This duration matches the CSS transition duration (2s)
            }, 100); // Optional delay to allow the page to load fully
        };
        // Choose langages
        $('#chooseLang, #selectLang').change(function () {
            "use strict";
            // set the window's location property to the value of the option the user has selected
            window.location = `?change_language=` + $(this).val();
        });
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html><?php /**PATH /home/betvscaa/public_html/resources/views/admin/layouts/index.blade.php ENDPATH**/ ?>