<header class="navbar navbar-expand-md d-none d-lg-flex d-print-none">
    <div class="container-<?php echo e((App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he') ? 'xl' : 'fluid')); ?>">
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar-menu"
            aria-controls="navbar-menu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="navbar-nav flex-row order-md-last">
            
            <?php if(count(config('app.languages')) > 1): ?>
                <div class="nav-item dropdown mx-2">
                    <div class="lang">
                        <select class="form-select small-btn" placeholder="<?php echo e(__('Select a language')); ?>" id="chooseLang">
                            <?php $__currentLoopData = config('app.languages'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $langLocale => $langName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($langLocale); ?>" <?php echo e(app()->getLocale() == $langLocale ? 'selected' : ''); ?>><strong><?php echo e($langName); ?></strong></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            <?php endif; ?>
            <div class="nav-item dropdown">
                <a href="#" class="nav-link d-flex lh-1 text-reset p-0" data-bs-toggle="dropdown"
                    aria-label="Open user menu">
                    <span class="img-rounded">
                        <img class="img-rounded"
                            src="<?php echo e(asset(Auth::user()->profile_image == null ? 'profile.png' : auth::user()->profile_image)); ?>"
                            alt="<?php echo e(auth::user()->name); ?>">
                    </span>
                    <div class="d-none d-xl-block ps-2">
                        <div><?php echo e(Auth::user()->name); ?></div>
                        <div class="mt-1 small text-muted"><?php echo e(__('Customer')); ?></div>
                    </div>
                </a>
                <div class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                    <a href="<?php echo e(route('user.account')); ?>" class="dropdown-item"><?php echo e(__('Profile & account')); ?></a>
                    
                    <a href="<?php echo e(route('user.change.theme', 'dark')); ?>" class="dropdown-item hide-theme-dark"
                        data-bs-placement="bottom">
                        <?php echo e(__('Dark mode')); ?>

                    </a>
                    <a href="<?php echo e(route('user.change.theme', 'light')); ?>" class="dropdown-item hide-theme-light"
                        data-bs-placement="bottom">
                        <?php echo e(__('Light mode')); ?>

                    </a>
                    <a href="<?php echo e(route('logout')); ?>" class="dropdown-item"
                        onclick="event.preventDefault(); document.getElementById('logout-form').submit();"><?php echo e(__('Logout')); ?></a>
                    <form class="logout" id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                    </form>
                </div>
            </div>
        </div>
        <div class="collapse navbar-collapse" id="navbar-menu"></div>
    </div>
</header><?php /**PATH /home/betvscaa/public_html/resources/views/user/includes/header.blade.php ENDPATH**/ ?>