<?php
// Page content
use Illuminate\Support\Facades\DB;

$config = DB::table('config')->get();
$supportPage = DB::table('pages')->where('page_name', 'footer')->orWhere('page_name', 'contact')->get();

// Default
$navbar = true;
$footer = true;

if ($config[38]->config_value == "no") { 
    // $navbar = false;
    $footer = false;
}
?>



<?php $__env->startSection('content'); ?>

<section class="pt-12 lg:pb-20 overflow-hidden">
    <div class="container mx-auto px-4">
        <div class="flex flex-wrap items-center -m-6">
            <div class="w-full md:w-1/2 p-6 lg:block hidden">
                <div class="p-1 mx-auto max-w-max overflow-hidden rounded-full">
                    <img class="object-cover rounded-full" src="<?php echo e(asset($config[13]->config_value)); ?>" alt="<?php echo e($config[0]->config_value); ?>">
                </div>
            </div>
            <div class="w-full md:w-1/2 p-6">
                <div class="md:max-w-md">
                    <h2 class="mb-3 font-heading font-bold text-6xl sm:text-7xl"><?php echo e(__('Sign Up')); ?></h2>
                    <p class="mb-8 text-lg"><?php echo e(__('Join the digital business card revolution and simplify your networking.')); ?></p>

                    
                    <form method="POST" action="<?php echo e(route('register')); ?>">
                        <?php echo csrf_field(); ?>  
                        <div class="flex flex-wrap -m-2 mb-6">
                            
                            <div class="w-full p-2">
                                <p class="mb-2.5 font-medium text-base"><?php echo e(__('Full Name')); ?></p>
                                <div
                                    class="p-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 focus-within:ring-4 focus-within:ring-indigo-500 rounded-lg">
                                    <input class="w-full px-6 py-4 placeholder-gray-500 text-base outline-none rounded-lg <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        type="text" placeholder="<?php echo e(__('Your name')); ?>" name="name" value="<?php echo e(old('name')); ?>" required autocomplete="name" autofocus>
                                </div>
                            </div>
                            <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback mx-2" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            
                            <div class="w-full p-2">
                                <p class="mb-2.5 font-medium text-base"><?php echo e(__('Email address')); ?></p>
                                <div
                                    class="p-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 focus-within:ring-4 focus-within:ring-indigo-500 rounded-lg <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                    <input class="w-full px-6 py-4 placeholder-gray-500 text-base outline-none rounded-lg"
                                        type="email" placeholder="<?php echo e(__('Your email address')); ?>" name="email" value="<?php echo e(old('email')); ?>" required autocomplete="email">
                                </div>
                            </div>
                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback mx-2" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            
                            <div class="w-full p-2">
                                <p class="mb-2.5 font-medium text-base"><?php echo e(__('Password')); ?></p>
                                <div
                                    class="p-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 focus-within:ring-4 focus-within:ring-indigo-500 rounded-lg">
                                    <input class="w-full px-6 py-4 placeholder-gray-500 text-base outline-none rounded-lg <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        type="password" placeholder="********" name="password" id="password" required autocomplete="new-password">
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <a class="ml-2 text-xs text-gray-800 font-medium float-right cursor-pointer" title="Show password"
                                    data-bs-toggle="tooltip" onclick="showPassword()"><?php echo e(__('Show / Hide Password')); ?></a>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback mx-2" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            
                            <div class="w-full p-2">
                                <p class="mb-2.5 font-medium text-base"><?php echo e(__('Confirm Password')); ?></p>
                                <div
                                    class="p-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 focus-within:ring-4 focus-within:ring-indigo-500 rounded-lg">
                                    <input class="w-full px-6 py-4 placeholder-gray-500 text-base outline-none rounded-lg <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        type="password" placeholder="********" name="password_confirmation" id="password_confirmation" id="" required autocomplete="new-password">
                                </div>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback mx-2" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            
                            <?php if($settings->recaptcha_configuration['RECAPTCHA_ENABLE'] == 'on'): ?>
                            <div class="w-full p-2">
                                <?php echo htmlFormSnippet(); ?>

                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="flex flex-wrap -m-1.5 mb-1">
                            <div class="w-auto p-1.5">
                                <input class="w-4 h-4" type="checkbox" name="terms" id="terms" checked>
                            </div>
                            <div class="flex-1 p-1.5">
                                <p class="text-gray-500 text-sm">
                                    <span><?php echo e(__('I agree to the')); ?></span>
                                    <a class="hover:text-gray-200" href="#"><?php echo e(__('Terms & Conditions')); ?></a>
                                    <span><?php echo e(__('of')); ?> <?php echo e(config('app.name')); ?>.</span>
                                </p>
                            </div>
                        </div>
                        <?php $__errorArgs = ['terms'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback mx-2" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="group relative md:max-w-max my-5">
                            <div
                                class="absolute top-0 left-0 w-full h-full bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 opacity-0 group-hover:opacity-50 rounded-full transition ease-out duration-300">
                            </div>
                            <button
                                class="p-1 w-full font-heading font-semibold text-xs text-white uppercase tracking-px overflow-hidden rounded-full">
                                <div class="relative py-5 px-14 bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-full">
                                    <div
                                        class="absolute top-0 left-0 transform -translate-y-full group-hover:-translate-y-0 h-full w-full bg-white transition ease-in-out duration-500">
                                    </div>
                                    <p class="relative z-10 group-hover:text-gray-900"><?php echo e(__('Sign Up')); ?></p>
                                </div>
                            </button>
                        </div>
                    </form>
                    <p class="text-gray-500 text-sm">
                        <span><?php echo e(__('Already have an account?')); ?></span>
                        <a class="hover:text-gray-200" href="<?php echo e(route('login')); ?>"><?php echo e(__('Login now')); ?></a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>


<?php $__env->startSection('custom-js'); ?>
<script>
function showPassword() {
    "use strict";
    var password = document.getElementById("password");
    var confirmPassword = document.getElementById("password_confirmation");
    if (password.type === "password") {
        password.type = "text";
        confirmPassword.type = "text";
    } else {
        password.type = "password";
        confirmPassword.type = "password";
    }
}
</script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', ['nav' => $navbar, 'banner' => false, 'footer' => $footer, 'cookie' => false, 'setting' => true,
'title' => true, 'title' => 'Sign Up'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/auth/register.blade.php ENDPATH**/ ?>