<?php
use App\User;
use App\Plan;
use App\BusinessCard;
use Carbon\Carbon;

// Card details
$business_card = BusinessCard::where('card_id', Request::segment(3))->first();

// Fetch the user plan
$plan = User::where('id', Auth::user()->id)->where('status', 1)->first();
$planData = json_decode($plan->plan_details, true);

if ($planData) {
    // Fetch the default plan details only once if necessary
    if (!$planData || !isset($planData['appointment'])) {
        $planDefaults = Plan::where('plan_id', $plan->plan_id)->first();
    }

    // Check and assign missing plan details
    $planData['appointment'] = $planData['appointment'] ?? $planDefaults->appointment;

    // Update plan details if necessary
    if ($planData !== json_decode($plan->plan_details, true)) {
        $plan->plan_details = json_encode($planData);
        $plan->updated_at = Carbon::now();
        $plan->save();
    }

    // Fetch the updated plan details
    $plan_details = json_decode($plan->plan_details, true);
}
?>

<a href="<?php echo e(route("user.edit.card", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'basic' ? 'active' : ''); ?>"><?php echo e(__('Basic Details')); ?></a>

<a href="<?php echo e(route("user.edit.social.links", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'links' ? 'active' : ''); ?>"><?php echo e(__('Social Links')); ?></a>

<?php if($business_card->type == "personal"): ?>
    <?php if($plan_details['appointment'] == 1): ?>
    <a href="<?php echo e(route("user.edit.appointment", Request::segment(3))); ?>"
        class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'appointment' ? 'active' : ''); ?>"><?php echo e(__('Appointment')); ?></a>
    <?php endif; ?>
<?php endif; ?>

<?php if($business_card->type == "business"): ?>
<a href="<?php echo e(route("user.edit.payment.links", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'payments' ? 'active' : ''); ?>"><?php echo e(__('Payment Links')); ?></a>

<a href="<?php echo e(route("user.edit.services", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'services' ? 'active' : ''); ?>"><?php echo e(__('Services')); ?></a>

<a href="<?php echo e(route("user.edit.vproducts", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'products' ? 'active' : ''); ?>"><?php echo e(__('Products')); ?></a>

<a href="<?php echo e(route("user.edit.galleries", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'galleries' ? 'active' : ''); ?>"><?php echo e(__('Galleries')); ?></a>

<a href="<?php echo e(route("user.edit.testimonials", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'testimonial' ? 'active' : ''); ?>"><?php echo e(__('Testimonials')); ?></a>

<?php if($plan_details['business_hours'] == 1): ?>
<a href="<?php echo e(route("user.edit.business.hours", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'hours' ? 'active' : ''); ?>"><?php echo e(__('Business Hours')); ?></a>
<?php endif; ?>

<?php if($plan_details['appointment'] == 1): ?>
<a href="<?php echo e(route("user.edit.appointment", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'appointment' ? 'active' : ''); ?>"><?php echo e(__('Appointment')); ?></a>
<?php endif; ?>

<?php if($plan_details['contact_form'] == 1): ?>
<a href="<?php echo e(route("user.edit.contact.form", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'contact' ? 'active' : ''); ?>"><?php echo e(__('Contact Form')); ?></a>
<?php endif; ?>

<?php if($plan_details['password_protected'] == 1 || $plan_details['advanced_settings'] == 1): ?>
<a href="<?php echo e(route("user.edit.advanced.setting", Request::segment(3))); ?>"
    class="list-group-item list-group-item-action d-flex align-items-center <?php echo e($link == 'advanced' ? 'active' : ''); ?>"><?php echo e(__('Advanced Settings')); ?></a>
<?php endif; ?>
<?php endif; ?><?php /**PATH /home/betvscaa/public_html/resources/views/user/pages/edit-cards/includes/nav-link.blade.php ENDPATH**/ ?>