<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <?php if(isset($setting) && $setting): ?>
        <?php echo SEOMeta::generate(); ?>

        <?php echo OpenGraph::generate(); ?>

        <?php echo Twitter::generate(); ?>

        <?php echo JsonLd::generate(); ?>

    <?php endif; ?>

    
    <?php if(isset($title) && $title): ?>
        <title><?php echo e($title); ?></title>
    <?php endif; ?>

    
    <?php if(isset($setting) && $setting): ?>
        <meta name="google-site-verification" content="<?php echo e($settings->google_key); ?>">
        <link rel="icon" href="<?php echo e(asset($settings->favicon)); ?>" sizes="96x96" type="image/png" />
    <?php endif; ?>

    <?php echo htmlScriptTagJsApi(); ?>


    <!-- CSS files -->
    <link rel="stylesheet" href="<?php echo e(asset('app/css/tailwind.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('app/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/sweetalert.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/fontawesome.min.css')); ?>" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@tabler/icons-webfont@latest/tabler-icons.min.css">
    <script type="text/javascript" src="<?php echo e(asset('app/js/main.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/alpine.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

    <?php if(isset($setting) && $setting): ?>
        
        <?php if(!empty($settings->google_analytics_id) && Cookie::get('laravel_cookie_consent')): ?>
            <!-- Global site tag (gtag.js) - Google Analytics -->
            <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($settings->google_analytics_id); ?>"></script>
            <script>
                window.dataLayer = window.dataLayer || [];

                function gtag() {
                    dataLayer.push(arguments);
                }
                gtag('js', new Date());

                gtag('config', '<?php echo e($settings->google_analytics_id); ?>');
            </script>
        <?php endif; ?>
    <?php endif; ?>

    <?php if($settings->google_adsense_code != 'DISABLE_ADSENSE_ONLY' && Cookie::get('laravel_cookie_consent')): ?>
        
        <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>" crossorigin="anonymous"></script>
    <?php endif; ?>

    
    <?php echo $__env->yieldContent('custom-script'); ?>
</head>

<body class="antialiased bg-body text-body font-body"
    dir="<?php echo e(App::isLocale('ar') || App::isLocale('ur') || App::isLocale('he') ? 'rtl' : 'ltr'); ?>">

    <div class="">
        
        <?php if(isset($nav) && $nav): ?>
            <?php echo $__env->make('website.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>

        
        <?php echo $__env->yieldContent('content'); ?>

        
        <?php if(env('COOKIE_CONSENT_ENABLED') == true): ?>
            <?php echo $__env->make('cookie-consent::index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </div>

    
    <?php if($config[40]->config_value == '1'): ?>
        <a href="https://api.whatsapp.com/send?phone=<?php echo e($config[41]->config_value); ?>&text=<?php echo e(urlencode($config[42]->config_value)); ?>"
            class="whatapp-chatbot" target="_blank">
            <i class="fab fa-whatsapp whatapp-chatbot-icon"></i>
        </a>
    <?php endif; ?>

    
    <?php if(isset($settings) && $settings): ?>
        <?php if($settings->tawk_chat_bot_key != null && $config[40]->config_value != '1' && Cookie::get('laravel_cookie_consent')): ?>
            <!--Start of Tawk.to Script-->
            <script>
                (function($) {
                    "use strict";
                    var Tawk_API = Tawk_API || {},
                        Tawk_LoadStart = new Date();
                    var s1 = document.createElement("script"),
                        s0 = document.getElementsByTagName("script")[0];
                    s1.async = true;
                    s1.src = 'https://embed.tawk.to/<?php echo e($settings->tawk_chat_bot_key); ?>';
                    s1.charset = 'UTF-8';
                    s1.setAttribute('crossorigin', '*');
                    s0.parentNode.insertBefore(s1, s0);
                })(jQuery);
            </script>
            <!--End of Tawk.to Script-->
        <?php endif; ?>
    <?php endif; ?>

    
    <?php if(isset($footer) && $footer): ?>
        <?php echo $__env->make('website.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <!-- Smooth Scroll -->
    <script type="text/javascript" src="<?php echo e(asset('js/smooth-scroll.polyfills.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('app/js/footer.js')); ?>"></script>

    
    <?php echo $__env->yieldContent('custom-js'); ?>
</body>

</html>
<?php /**PATH /home/betvscaa/public_html/resources/views/layouts/index.blade.php ENDPATH**/ ?>