


<?php $__env->startSection('custom-script'); ?>
<?php if($settings->google_adsense_code != 'DISABLE_ADSENSE_ONLY'): ?>

<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=<?php echo e($settings->google_adsense_code); ?>" crossorigin="anonymous"></script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div>
    <section class="text-gray-700">
        <div class="container px-5 py-24 mx-auto">
            
            <div class="mb-2">
                <h1 class="text-3xl font-bold font-large title-font text-gray-900 mb-4">
                    <?php echo e(__('Whois Lookup')); ?>

                </h1>
            </div>

            
            <form action="<?php echo e(route('web.result.whois.lookup')); ?>" method="post">
                <?php echo csrf_field(); ?>

                
                <div class='mb-3 space-y-2 w-full'>
                    <label class='font-bold text-gray-600 py-2'><?php echo e(__('Domain URL')); ?> <abbr title='required'>*</abbr></label>
                    <input placeholder='<?php echo e(__('Eg: https://domain.com')); ?>' class='appearance-none block w-full bg-grey-lighter text-grey-darker border border-grey-lighter rounded-lg h-10 px-4' required='required' value='<?php echo e($domain ?? (old('domain') ?? '')); ?>' type='text' name='domain' id='domain'>
                </div>

                <button type="submit" class="group relative font-heading px-10 py-5 mb-8 w-full lg:w-auto uppercase text-white text-xs font-semibold tracking-px bg-gradient-to-r from-<?php echo e($config[11]->config_value); ?>-400 to-<?php echo e($config[11]->config_value); ?>-500 overflow-hidden rounded-md"><?php echo e(__('Search')); ?></button>
            </form>

            
            <?php if(isset($results)): ?>
            <div class='flex flex-wrap lg:w-full sm:mx-auto sm:mb-2 lg:mt-12'>  
                <div class="rounded-xl border p-5 shadow-md w-full bg-white">
                    <div class="flex w-full items-center justify-between border-b pb-3">
                        <div class="flex items-center space-x-3">
                            <div class="text-lg font-bold text-slate-700"><?php echo e(__('Result')); ?></div>
                        </div>
                        <div class="flex items-center space-x-8">
                            <button class="rounded-2xl border bg-neutral-100 px-3 py-1 font-semibold"><?php echo e(__('WHOIS')); ?></button>
                        </div>
                    </div>

                    
                    <?php if(empty($results)): ?>
                        <?php echo e(__('No results found.')); ?>

                    <?php else: ?>
                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Domain Name')); ?></div>
                        <div class="text-lg text-neutral-600"><img width="20" height="20" src="https://icons.duckduckgo.com/ip3/<?php echo e($results->domainName); ?>.ico" alt="<?php echo e($results->domainName); ?>"><?php echo e($results->domainName); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Registrar Name')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results->registrar)); ?></div>
                    </div>

                    
                    <?php if($results->owner): ?>
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Registrant name')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__($results->owner)); ?></div>
                    </div>
                    <?php endif; ?>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Domain Created date')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                            \Carbon\Carbon::createFromTimestamp($results->creationDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                            \Carbon\Carbon::createFromTimestamp($results->creationDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                            config('app.timezone')))->toOffsetName()])); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Domain Updated date')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                            \Carbon\Carbon::createFromTimestamp($results->updatedDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                            \Carbon\Carbon::createFromTimestamp($results->updatedDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                            config('app.timezone')))->toOffsetName()])); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Domain Expiration date')); ?></div>
                        <div class="text-lg text-neutral-600"><?php echo e(__(':date at :time (UTC :offset)', ['date' =>
                            \Carbon\Carbon::createFromTimestamp($results->expirationDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('Y-m-d')), 'time' =>
                            \Carbon\Carbon::createFromTimestamp($results->expirationDate)->tz(Auth::user()->timezone
                            ?? config('app.timezone'))->format(__('H:i:s')), 'offset' =>
                            \Carbon\CarbonTimeZone::create((Auth::user()->timezone ??
                            config('app.timezone')))->toOffsetName()])); ?></div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('Domain Name servers')); ?></div>
                        <div class="text-lg text-neutral-600">
                            <?php $__currentLoopData = $results->nameServers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serverName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="text-break <?php echo e(!$loop->first ? 'mt-1' : ''); ?>">
                                <?php echo e($serverName); ?>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('States')); ?></div>
                        <div class="text-lg text-neutral-600">
                            <?php $__currentLoopData = $results->states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stateName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="text-break <?php echo e(!$loop->first ? 'mt-1' : ''); ?>">
                                <?php echo e($stateName); ?>

                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>

                    
                    <?php if($results->whoisServer): ?>
                    <div class="mt-4 mb-2">
                        <div class="mb-3 text-xl font-bold"><?php echo e(__('WHOIS server name')); ?></div>
                        <div class="text-lg text-neutral-600">
                            <?php echo e($results->whoisServer); ?>

                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </section>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.index', ['nav' => true, 'banner' => false, 'footer' => true, 'cookie' => true, 'setting' => true,
'title' => __('Whois Lookup - Web Tools')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/betvscaa/public_html/resources/views/website/pages/web-tools/whois.blade.php ENDPATH**/ ?>