<!DOCTYPE html>
<html lang="en">

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ __('New Appointment') }} {{ __($details['status']) }}</title>
    <style>
        /* Basic Tailwind-inspired styles for email */
        /* Tailwind CSS for email styles */
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f7fafc;
        }

        .container {
            max-width: 100%;
            margin: 20px auto;
            padding: 24px;
            background-color: #ffffff;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }

        .title {
            font-size: 1.25rem;
            font-weight: 600;
            color: #2d3748;
            margin-bottom: 16px;
        }

        .text {
            font-size: 1rem;
            color: #4a5568;
            margin-bottom: 16px;
        }

        .highlight {
            font-weight: 600;
            color: #1a202c;
        }

        .appointment-details {
            background-color: #f7fafc;
            padding: 16px;
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            margin-top: 16px;
        }

        .appointment-details p {
            font-weight: 600;
            color: #1a202c;
            margin-bottom: 8px;
        }

        .list-item {
            margin-bottom: 8px;
        }

        .list-item span {
            font-weight: 600;
            color: #2d3748;
        }

        .button {
            display: inline-block;
            padding: 12px 24px;
            background-color: #3182ce;
            color: #ffffff;
            text-decoration: none;
            font-weight: 600;
            border-radius: 8px;
            margin-top: 24px;
        }

        .button:hover {
            background-color: #2b6cb0;
        }

        .footer {
            text-align: center;
            font-size: 0.875rem;
            color: #718096;
            margin-top: 32px;
        }

        .footer p {
            margin-bottom: 8px;
        }

        @media (max-width: 640px) {
            .container {
                margin: 20px auto;
                padding: 16px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <!-- Header Section -->
        <div class="header">
            <h1>{{ __('Appointment') }} {{ __($details['status']) }}</h1>

            @if ($details['status'] == 'Pending')
                <p>{{ __('Your appointment request is pending and will be confirmed shortly.') }}</p>
            @endif

            @if ($details['status'] == 'Confirmed')
                <p>{{ __('Your appointment has been successfully scheduled!') }}</p>
            @endif

            @if ($details['status'] == 'Canceled')
                <p>{{ __('Your appointment has been canceled. Please contact us if you have any questions or need further assistance.') }}
                </p>
            @endif

            @if ($details['status'] == 'Completed')
                <p>{{ __('Your appointment has been completed. Thank you for choosing our service, and we look forward to serving you again!') }}
                </p>
            @endif

            @if ($details['status'] == 'Rescheduled')
                <p>{{ __('Your appointment has been rescheduled. Please contact us if you have any questions or need further assistance.') }}
                </p>
            @endif
        </div>

        <!-- Content Section -->
        @if ($details['status'] == 'Confirmed' || $details['status'] == 'Rescheduled')
            <div class="content">
                <p>{{ __('Hi,') }}</p>
                <p>{{ __('We are pleased to confirm your appointment with us. Here are the details:') }}</p>
                <p><strong>{{ __('Date') }}:</strong> {{ $details['appointmentDate'] }}</p>
                <p><strong>{{ __('Time') }}:</strong> {{ $details['appointmentTime'] }}</p>
                <p>{{ __('If you have any questions or need to reschedule or need further assistance, please don\'t hesitate to contact us.') }}
                </p>
                <p>{{ __('Thank you for choosing our service!') }}</p>

                <!-- Google Calendar Button -->
                @if (!empty($details['googleCalendarUrl']))
                    <p><strong>{{ __('You can add this appointment to your Google Calendar by clicking the link below:') }}</strong>
                    </p>
                    <a href="{{ $details['googleCalendarUrl'] }}" target="_blank"
                        class="button">{{ __('Add to Google Calendar') }}</a>
                @endif
            </div>
        @endif

        <!-- Footer Section -->
        <div class="footer">
            &copy; {{ env('APP_NAME') }}. {{ __('All rights reserved.') }}
        </div>
    </div>
</body>

</html>
