<?php

use App\Currency;
use Illuminate\Support\Facades\DB;

// if (!function_exists('formatCurrency')) {
//     function formatCurrency($amount)
//     {
//         // Fetch settings from the database
//         $currencies = Currency::get();
//         $config = DB::table('config')->get();
//         $setCurrencyConfig = $config[1]->config_value;

//         // Find the matching currency
//         foreach ($currencies as $currency) {
//             if ($currency->iso_code === $setCurrencyConfig) {
//                 $setCurrency = $currency->symbol;
//                 $setDecimalSymbol = $currency->decimal_mark;
//                 $setThousandSeparator = $currency->thoudands_separator;
//                 $setDecimalsPlaces = $currency->decimals;
//                 break;
//             }
//         }

//         $currencySymbol = $setCurrency ?? '$';
//         $decimalSymbol = $setDecimalSymbol ?? '.';
//         $thousandSeparator = $setThousandSeparator ?? ',';
//         $decimals = $setDecimalsPlaces ?? 2;

//         return $currencySymbol . number_format($amount, $decimals, $decimalSymbol, $thousandSeparator);
//     }
// }

if (!function_exists('formatCurrency')) {
    function formatCurrency($amount)
    {
        // Fetch settings from the database
        $config = DB::table('config')->get();

        // Set decimal value
        $formatType = $config[55]->config_value ?? '1.234.567,89';
        $setDecimalsPlaces = (int)$config[56]->config_value ?? 2;

        // Define formatting styles based on user preference
        switch ($formatType) {
            case '1,234,567.89':
                return number_format($amount, $setDecimalsPlaces, '.', ',');
            case '1.234.567,89':
                return number_format($amount, $setDecimalsPlaces, ',', '.');
            case '1 234 567,89':
                return number_format($amount, $setDecimalsPlaces, ',', ' ');
            case "1'234'567.89":
                return number_format($amount, $setDecimalsPlaces, '.', "'");
            default:
                return number_format($amount, $setDecimalsPlaces, '.', ','); // default format
        }
    }
}
